/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.api.impl;

import com.google.common.annotations.VisibleForTesting;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.delegation.web.DelegationTokenAuthenticatedURL;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntityType;
import org.apache.hadoop.yarn.client.api.TimelineReaderClient;
import org.apache.hadoop.yarn.client.api.impl.TimelineConnector;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class TimelineReaderClientImpl
extends TimelineReaderClient {
    private static final Logger LOG = LoggerFactory.getLogger(TimelineReaderClientImpl.class);
    private static final String RESOURCE_URI_STR_V2 = "/ws/v2/timeline/";
    private TimelineConnector connector;
    private URI baseUri;
    private String clusterId;

    public TimelineReaderClientImpl() {
        super(TimelineReaderClientImpl.class.getName());
    }

    protected void serviceInit(Configuration conf) throws Exception {
        String doAsUser;
        UserGroupInformation authUgi;
        if (!YarnConfiguration.timelineServiceV2Enabled((Configuration)conf)) {
            throw new IOException("Timeline V2 client is not properly configured. Either timeline service is not enabled or version is not set to 2");
        }
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        UserGroupInformation realUgi = ugi.getRealUser();
        if (realUgi != null) {
            authUgi = realUgi;
            doAsUser = ugi.getShortUserName();
        } else {
            authUgi = ugi;
            doAsUser = null;
        }
        DelegationTokenAuthenticatedURL.Token token = new DelegationTokenAuthenticatedURL.Token();
        this.connector = new TimelineConnector(false, authUgi, doAsUser, token);
        this.addIfService((Object)this.connector);
        String timelineReaderWebAppAddress = WebAppUtils.getTimelineReaderWebAppURLWithoutScheme(conf);
        this.baseUri = TimelineConnector.constructResURI(conf, timelineReaderWebAppAddress, RESOURCE_URI_STR_V2);
        this.clusterId = conf.get("yarn.resourcemanager.cluster-id", "yarn_cluster");
        LOG.info("Initialized TimelineReader URI=" + this.baseUri + ", clusterId=" + this.clusterId);
        super.serviceInit(conf);
    }

    @Override
    public TimelineEntity getApplicationEntity(ApplicationId appId, String fields, Map<String, String> filters) throws IOException {
        String path = StringHelper.PATH_JOINER.join((Object)"clusters", (Object)this.clusterId, new Object[]{"apps", appId});
        if (fields == null || fields.isEmpty()) {
            fields = "INFO";
        }
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"fields", (Object)fields);
        this.mergeFilters((MultivaluedMap<String, String>)params, filters);
        ClientResponse response = this.doGetUri(this.baseUri, path, (MultivaluedMap<String, String>)params);
        TimelineEntity entity = (TimelineEntity)response.getEntity(TimelineEntity.class);
        return entity;
    }

    @Override
    public TimelineEntity getApplicationAttemptEntity(ApplicationAttemptId appAttemptId, String fields, Map<String, String> filters) throws IOException {
        ApplicationId appId = appAttemptId.getApplicationId();
        String path = StringHelper.PATH_JOINER.join((Object)"clusters", (Object)this.clusterId, new Object[]{"apps", appId, "entities", TimelineEntityType.YARN_APPLICATION_ATTEMPT, appAttemptId});
        if (fields == null || fields.isEmpty()) {
            fields = "INFO";
        }
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"fields", (Object)fields);
        this.mergeFilters((MultivaluedMap<String, String>)params, filters);
        ClientResponse response = this.doGetUri(this.baseUri, path, (MultivaluedMap<String, String>)params);
        TimelineEntity entity = (TimelineEntity)response.getEntity(TimelineEntity.class);
        return entity;
    }

    @Override
    public List<TimelineEntity> getApplicationAttemptEntities(ApplicationId appId, String fields, Map<String, String> filters, long limit, String fromId) throws IOException {
        String path = StringHelper.PATH_JOINER.join((Object)"clusters", (Object)this.clusterId, new Object[]{"apps", appId, "entities", TimelineEntityType.YARN_APPLICATION_ATTEMPT});
        if (fields == null || fields.isEmpty()) {
            fields = "INFO";
        }
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"fields", (Object)fields);
        if (limit > 0L) {
            params.add((Object)"limit", (Object)Long.toString(limit));
        }
        if (fromId != null && !fromId.isEmpty()) {
            params.add((Object)"fromid", (Object)fromId);
        }
        this.mergeFilters((MultivaluedMap<String, String>)params, filters);
        ClientResponse response = this.doGetUri(this.baseUri, path, (MultivaluedMap<String, String>)params);
        TimelineEntity[] entities = (TimelineEntity[])response.getEntity(TimelineEntity[].class);
        return Arrays.asList(entities);
    }

    @Override
    public TimelineEntity getContainerEntity(ContainerId containerId, String fields, Map<String, String> filters) throws IOException {
        ApplicationId appId = containerId.getApplicationAttemptId().getApplicationId();
        String path = StringHelper.PATH_JOINER.join((Object)"clusters", (Object)this.clusterId, new Object[]{"apps", appId, "entities", TimelineEntityType.YARN_CONTAINER, containerId});
        if (fields == null || fields.isEmpty()) {
            fields = "INFO";
        }
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"fields", (Object)fields);
        this.mergeFilters((MultivaluedMap<String, String>)params, filters);
        ClientResponse response = this.doGetUri(this.baseUri, path, (MultivaluedMap<String, String>)params);
        TimelineEntity entity = (TimelineEntity)response.getEntity(TimelineEntity.class);
        return entity;
    }

    @Override
    public List<TimelineEntity> getContainerEntities(ApplicationId appId, String fields, Map<String, String> filters, long limit, String fromId) throws IOException {
        String path = StringHelper.PATH_JOINER.join((Object)"clusters", (Object)this.clusterId, new Object[]{"apps", appId, "entities", TimelineEntityType.YARN_CONTAINER});
        if (fields == null || fields.isEmpty()) {
            fields = "INFO";
        }
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"fields", (Object)fields);
        if (limit > 0L) {
            params.add((Object)"limit", (Object)Long.toString(limit));
        }
        if (fromId != null && !fromId.isEmpty()) {
            params.add((Object)"fromid", (Object)fromId);
        }
        this.mergeFilters((MultivaluedMap<String, String>)params, filters);
        ClientResponse response = this.doGetUri(this.baseUri, path, (MultivaluedMap<String, String>)params);
        TimelineEntity[] entity = (TimelineEntity[])response.getEntity(TimelineEntity[].class);
        return Arrays.asList(entity);
    }

    private void mergeFilters(MultivaluedMap<String, String> defaults, Map<String, String> filters) {
        if (filters != null && !filters.isEmpty()) {
            for (Map.Entry<String, String> entry : filters.entrySet()) {
                if (defaults.containsKey((Object)entry.getKey())) continue;
                defaults.add((Object)entry.getKey(), (Object)filters.get(entry.getValue()));
            }
        }
    }

    @VisibleForTesting
    protected ClientResponse doGetUri(URI base, String path, MultivaluedMap<String, String> params) throws IOException {
        ClientResponse resp = (ClientResponse)this.connector.getClient().resource(base).path(path).queryParams(params).accept(new String[]{"application/json"}).get(ClientResponse.class);
        if (resp == null || resp.getStatusInfo().getStatusCode() != ClientResponse.Status.OK.getStatusCode()) {
            String msg = "Response from the timeline reader server is " + (resp == null ? "null" : "not successful, HTTP error code: " + resp.getStatus() + ", Server response:\n" + (String)resp.getEntity(String.class));
            LOG.error(msg);
            throw new IOException(msg);
        }
        return resp;
    }
}

