/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.NodeHealthStatus;
import org.apache.hadoop.yarn.service.AbstractService;

public class NodeHealthCheckerService
extends AbstractService {
    private static Log LOG = LogFactory.getLog(NodeHealthCheckerService.class);
    private String nodeHealthScript;
    private long intervalTime;
    private long scriptTimeout;
    private Timer nodeHealthScriptScheduler;
    Shell.ShellCommandExecutor shexec = null;
    private Configuration conf;
    private static final String ERROR_PATTERN = "ERROR";
    static final String NODE_HEALTH_SCRIPT_TIMED_OUT_MSG = "Node health script timed out";
    private boolean isHealthy = true;
    private String healthReport = "";
    private long lastReportedTime = System.currentTimeMillis();
    private TimerTask timer;

    public NodeHealthCheckerService() {
        super(NodeHealthCheckerService.class.getName());
    }

    public NodeHealthCheckerService(Configuration conf) {
        this();
        this.init(conf);
    }

    public void init(Configuration conf) {
        this.conf = conf;
        this.nodeHealthScript = conf.get("yarn.nodemanager.health-checker.script.path");
        this.intervalTime = conf.getLong("yarn.nodemanager.health-checker.interval-ms", 600000L);
        this.scriptTimeout = conf.getLong("yarn.nodemanager.health-checker.script.timeout-ms", 1200000L);
        String[] args = conf.getStrings("yarn.nodemanager.health-checker.script.opts", new String[0]);
        this.timer = new NodeHealthMonitorExecutor(args);
    }

    public void start() {
        if (!NodeHealthCheckerService.shouldRun(this.conf)) {
            LOG.info((Object)"Not starting node health monitor");
            return;
        }
        this.nodeHealthScriptScheduler = new Timer("NodeHealthMonitor-Timer", true);
        this.nodeHealthScriptScheduler.scheduleAtFixedRate(this.timer, 0L, this.intervalTime);
    }

    public void stop() {
        Process p;
        if (!NodeHealthCheckerService.shouldRun(this.conf)) {
            return;
        }
        this.nodeHealthScriptScheduler.cancel();
        if (this.shexec != null && (p = this.shexec.getProcess()) != null) {
            p.destroy();
        }
    }

    private boolean isHealthy() {
        return this.isHealthy;
    }

    private synchronized void setHealthy(boolean isHealthy) {
        this.isHealthy = isHealthy;
    }

    private String getHealthReport() {
        return this.healthReport;
    }

    private synchronized void setHealthReport(String healthReport) {
        this.healthReport = healthReport;
    }

    private long getLastReportedTime() {
        return this.lastReportedTime;
    }

    private synchronized void setLastReportedTime(long lastReportedTime) {
        this.lastReportedTime = lastReportedTime;
    }

    public static boolean shouldRun(Configuration conf) {
        String nodeHealthScript = conf.get("yarn.nodemanager.health-checker.script.path");
        if (nodeHealthScript == null || nodeHealthScript.trim().isEmpty()) {
            return false;
        }
        File f = new File(nodeHealthScript);
        return f.exists() && f.canExecute();
    }

    private synchronized void setHealthStatus(boolean isHealthy, String output) {
        this.setHealthy(isHealthy);
        this.setHealthReport(output);
    }

    private synchronized void setHealthStatus(boolean isHealthy, String output, long time) {
        this.setHealthStatus(isHealthy, output);
        this.setLastReportedTime(time);
    }

    public synchronized void setHealthStatus(NodeHealthStatus healthStatus) {
        healthStatus.setIsNodeHealthy(this.isHealthy());
        healthStatus.setHealthReport(this.getHealthReport());
        healthStatus.setLastHealthReportTime(this.getLastReportedTime());
    }

    TimerTask getTimer() {
        return this.timer;
    }

    private class NodeHealthMonitorExecutor
    extends TimerTask {
        String exceptionStackTrace = "";

        public NodeHealthMonitorExecutor(String[] args) {
            ArrayList<String> execScript = new ArrayList<String>();
            execScript.add(NodeHealthCheckerService.this.nodeHealthScript);
            if (args != null) {
                execScript.addAll(Arrays.asList(args));
            }
            NodeHealthCheckerService.this.shexec = new Shell.ShellCommandExecutor(execScript.toArray(new String[execScript.size()]), null, null, NodeHealthCheckerService.this.scriptTimeout);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            HealthCheckerExitStatus status = HealthCheckerExitStatus.SUCCESS;
            try {
                NodeHealthCheckerService.this.shexec.execute();
            }
            catch (Shell.ExitCodeException e) {
                status = HealthCheckerExitStatus.FAILED_WITH_EXIT_CODE;
            }
            catch (Exception e) {
                LOG.warn((Object)("Caught exception : " + e.getMessage()));
                status = !NodeHealthCheckerService.this.shexec.isTimedOut() ? HealthCheckerExitStatus.FAILED_WITH_EXCEPTION : HealthCheckerExitStatus.TIMED_OUT;
                this.exceptionStackTrace = StringUtils.stringifyException((Throwable)e);
            }
            finally {
                if (status == HealthCheckerExitStatus.SUCCESS && this.hasErrors(NodeHealthCheckerService.this.shexec.getOutput())) {
                    status = HealthCheckerExitStatus.FAILED;
                }
                this.reportHealthStatus(status);
            }
        }

        void reportHealthStatus(HealthCheckerExitStatus status) {
            long now = System.currentTimeMillis();
            switch (status) {
                case SUCCESS: {
                    NodeHealthCheckerService.this.setHealthStatus(true, "", now);
                    break;
                }
                case TIMED_OUT: {
                    NodeHealthCheckerService.this.setHealthStatus(false, NodeHealthCheckerService.NODE_HEALTH_SCRIPT_TIMED_OUT_MSG);
                    break;
                }
                case FAILED_WITH_EXCEPTION: {
                    NodeHealthCheckerService.this.setHealthStatus(false, this.exceptionStackTrace);
                    break;
                }
                case FAILED_WITH_EXIT_CODE: {
                    NodeHealthCheckerService.this.setHealthStatus(true, "", now);
                    break;
                }
                case FAILED: {
                    NodeHealthCheckerService.this.setHealthStatus(false, NodeHealthCheckerService.this.shexec.getOutput());
                }
            }
        }

        private boolean hasErrors(String output) {
            String[] splits;
            for (String split : splits = output.split("\n")) {
                if (!split.startsWith(NodeHealthCheckerService.ERROR_PATTERN)) continue;
                return true;
            }
            return false;
        }
    }

    private static enum HealthCheckerExitStatus {
        SUCCESS,
        TIMED_OUT,
        FAILED_WITH_EXIT_CODE,
        FAILED_WITH_EXCEPTION,
        FAILED;

    }
}

