/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.api.records.impl.pb;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ProtoBase;
import org.apache.hadoop.yarn.api.records.impl.pb.ApplicationIdPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ContainerIdPBImpl;
import org.apache.hadoop.yarn.proto.YarnProtos;
import org.apache.hadoop.yarn.proto.YarnServerCommonProtos;
import org.apache.hadoop.yarn.server.api.records.HeartbeatResponse;
import org.apache.hadoop.yarn.server.api.records.NodeAction;

public class HeartbeatResponsePBImpl
extends ProtoBase<YarnServerCommonProtos.HeartbeatResponseProto>
implements HeartbeatResponse {
    YarnServerCommonProtos.HeartbeatResponseProto proto = YarnServerCommonProtos.HeartbeatResponseProto.getDefaultInstance();
    YarnServerCommonProtos.HeartbeatResponseProto.Builder builder = null;
    boolean viaProto = false;
    private List<ContainerId> containersToCleanup = null;
    private List<ApplicationId> applicationsToCleanup = null;

    public HeartbeatResponsePBImpl() {
        this.builder = YarnServerCommonProtos.HeartbeatResponseProto.newBuilder();
    }

    public HeartbeatResponsePBImpl(YarnServerCommonProtos.HeartbeatResponseProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    public YarnServerCommonProtos.HeartbeatResponseProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    private void mergeLocalToBuilder() {
        if (this.containersToCleanup != null) {
            this.addContainersToCleanupToProto();
        }
        if (this.applicationsToCleanup != null) {
            this.addApplicationsToCleanupToProto();
        }
    }

    private void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnServerCommonProtos.HeartbeatResponseProto.newBuilder(this.proto);
        }
        this.viaProto = false;
    }

    @Override
    public int getResponseId() {
        YarnServerCommonProtos.HeartbeatResponseProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return p.getResponseId();
    }

    @Override
    public void setResponseId(int responseId) {
        this.maybeInitBuilder();
        this.builder.setResponseId(responseId);
    }

    @Override
    public NodeAction getNodeAction() {
        YarnServerCommonProtos.HeartbeatResponseProtoOrBuilder p;
        YarnServerCommonProtos.HeartbeatResponseProtoOrBuilder heartbeatResponseProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasNodeAction()) {
            return null;
        }
        return this.convertFromProtoFormat(p.getNodeAction());
    }

    @Override
    public void setNodeAction(NodeAction nodeAction) {
        this.maybeInitBuilder();
        if (nodeAction == null) {
            this.builder.clearNodeAction();
            return;
        }
        this.builder.setNodeAction(this.convertToProtoFormat(nodeAction));
    }

    @Override
    public List<ContainerId> getContainersToCleanupList() {
        this.initContainersToCleanup();
        return this.containersToCleanup;
    }

    @Override
    public ContainerId getContainerToCleanup(int index) {
        this.initContainersToCleanup();
        return this.containersToCleanup.get(index);
    }

    @Override
    public int getContainersToCleanupCount() {
        this.initContainersToCleanup();
        return this.containersToCleanup.size();
    }

    private void initContainersToCleanup() {
        if (this.containersToCleanup != null) {
            return;
        }
        YarnServerCommonProtos.HeartbeatResponseProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        List<YarnProtos.ContainerIdProto> list = p.getContainersToCleanupList();
        this.containersToCleanup = new ArrayList<ContainerId>();
        for (YarnProtos.ContainerIdProto c : list) {
            this.containersToCleanup.add((ContainerId)this.convertFromProtoFormat(c));
        }
    }

    @Override
    public void addAllContainersToCleanup(List<ContainerId> containersToCleanup) {
        if (containersToCleanup == null) {
            return;
        }
        this.initContainersToCleanup();
        this.containersToCleanup.addAll(containersToCleanup);
    }

    private void addContainersToCleanupToProto() {
        this.maybeInitBuilder();
        this.builder.clearContainersToCleanup();
        if (this.containersToCleanup == null) {
            return;
        }
        Iterable<YarnProtos.ContainerIdProto> iterable = new Iterable<YarnProtos.ContainerIdProto>(){

            @Override
            public Iterator<YarnProtos.ContainerIdProto> iterator() {
                return new Iterator<YarnProtos.ContainerIdProto>(){
                    Iterator<ContainerId> iter;
                    {
                        this.iter = HeartbeatResponsePBImpl.this.containersToCleanup.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public YarnProtos.ContainerIdProto next() {
                        return HeartbeatResponsePBImpl.this.convertToProtoFormat(this.iter.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
        this.builder.addAllContainersToCleanup((Iterable<? extends YarnProtos.ContainerIdProto>)iterable);
    }

    @Override
    public void addContainerToCleanup(ContainerId containersToCleanup) {
        this.initContainersToCleanup();
        this.containersToCleanup.add(containersToCleanup);
    }

    @Override
    public void removeContainerToCleanup(int index) {
        this.initContainersToCleanup();
        this.containersToCleanup.remove(index);
    }

    @Override
    public void clearContainersToCleanup() {
        this.initContainersToCleanup();
        this.containersToCleanup.clear();
    }

    @Override
    public List<ApplicationId> getApplicationsToCleanupList() {
        this.initApplicationsToCleanup();
        return this.applicationsToCleanup;
    }

    @Override
    public ApplicationId getApplicationsToCleanup(int index) {
        this.initApplicationsToCleanup();
        return this.applicationsToCleanup.get(index);
    }

    @Override
    public int getApplicationsToCleanupCount() {
        this.initApplicationsToCleanup();
        return this.applicationsToCleanup.size();
    }

    private void initApplicationsToCleanup() {
        if (this.applicationsToCleanup != null) {
            return;
        }
        YarnServerCommonProtos.HeartbeatResponseProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        List<YarnProtos.ApplicationIdProto> list = p.getApplicationsToCleanupList();
        this.applicationsToCleanup = new ArrayList<ApplicationId>();
        for (YarnProtos.ApplicationIdProto c : list) {
            this.applicationsToCleanup.add((ApplicationId)this.convertFromProtoFormat(c));
        }
    }

    @Override
    public void addAllApplicationsToCleanup(List<ApplicationId> applicationsToCleanup) {
        if (applicationsToCleanup == null) {
            return;
        }
        this.initApplicationsToCleanup();
        this.applicationsToCleanup.addAll(applicationsToCleanup);
    }

    private void addApplicationsToCleanupToProto() {
        this.maybeInitBuilder();
        this.builder.clearApplicationsToCleanup();
        if (this.applicationsToCleanup == null) {
            return;
        }
        Iterable<YarnProtos.ApplicationIdProto> iterable = new Iterable<YarnProtos.ApplicationIdProto>(){

            @Override
            public Iterator<YarnProtos.ApplicationIdProto> iterator() {
                return new Iterator<YarnProtos.ApplicationIdProto>(){
                    Iterator<ApplicationId> iter;
                    {
                        this.iter = HeartbeatResponsePBImpl.this.applicationsToCleanup.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public YarnProtos.ApplicationIdProto next() {
                        return HeartbeatResponsePBImpl.this.convertToProtoFormat(this.iter.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
        this.builder.addAllApplicationsToCleanup((Iterable<? extends YarnProtos.ApplicationIdProto>)iterable);
    }

    @Override
    public void addApplicationToCleanup(ApplicationId applicationsToCleanup) {
        this.initApplicationsToCleanup();
        this.applicationsToCleanup.add(applicationsToCleanup);
    }

    @Override
    public void removeApplicationToCleanup(int index) {
        this.initApplicationsToCleanup();
        this.applicationsToCleanup.remove(index);
    }

    @Override
    public void clearApplicationsToCleanup() {
        this.initApplicationsToCleanup();
        this.applicationsToCleanup.clear();
    }

    private ContainerIdPBImpl convertFromProtoFormat(YarnProtos.ContainerIdProto p) {
        return new ContainerIdPBImpl(p);
    }

    private YarnProtos.ContainerIdProto convertToProtoFormat(ContainerId t) {
        return ((ContainerIdPBImpl)t).getProto();
    }

    private ApplicationIdPBImpl convertFromProtoFormat(YarnProtos.ApplicationIdProto p) {
        return new ApplicationIdPBImpl(p);
    }

    private YarnProtos.ApplicationIdProto convertToProtoFormat(ApplicationId t) {
        return ((ApplicationIdPBImpl)t).getProto();
    }

    private NodeAction convertFromProtoFormat(YarnServerCommonProtos.NodeActionProto p) {
        return NodeAction.valueOf(p.name());
    }

    private YarnServerCommonProtos.NodeActionProto convertToProtoFormat(NodeAction t) {
        return YarnServerCommonProtos.NodeActionProto.valueOf(t.name());
    }
}

