/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.api.records.impl.pb;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeHealthStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.ProtoBase;
import org.apache.hadoop.yarn.api.records.impl.pb.ContainerStatusPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.NodeHealthStatusPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.NodeIdPBImpl;
import org.apache.hadoop.yarn.proto.YarnProtos;
import org.apache.hadoop.yarn.proto.YarnServerCommonProtos;
import org.apache.hadoop.yarn.server.api.records.NodeStatus;

public class NodeStatusPBImpl
extends ProtoBase<YarnServerCommonProtos.NodeStatusProto>
implements NodeStatus {
    YarnServerCommonProtos.NodeStatusProto proto = YarnServerCommonProtos.NodeStatusProto.getDefaultInstance();
    YarnServerCommonProtos.NodeStatusProto.Builder builder = null;
    boolean viaProto = false;
    private NodeId nodeId = null;
    private List<ContainerStatus> containers = null;
    private NodeHealthStatus nodeHealthStatus = null;

    public NodeStatusPBImpl() {
        this.builder = YarnServerCommonProtos.NodeStatusProto.newBuilder();
    }

    public NodeStatusPBImpl(YarnServerCommonProtos.NodeStatusProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    public YarnServerCommonProtos.NodeStatusProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    private void mergeLocalToBuilder() {
        if (this.nodeId != null) {
            this.builder.setNodeId(this.convertToProtoFormat(this.nodeId));
        }
        if (this.containers != null) {
            this.addContainersToProto();
        }
        if (this.nodeHealthStatus != null) {
            this.builder.setNodeHealthStatus(this.convertToProtoFormat(this.nodeHealthStatus));
        }
    }

    private void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnServerCommonProtos.NodeStatusProto.newBuilder(this.proto);
        }
        this.viaProto = false;
    }

    private void addContainersToProto() {
        this.maybeInitBuilder();
        this.builder.clearContainersStatuses();
        if (this.containers == null) {
            return;
        }
        Iterable<YarnProtos.ContainerStatusProto> iterable = new Iterable<YarnProtos.ContainerStatusProto>(){

            @Override
            public Iterator<YarnProtos.ContainerStatusProto> iterator() {
                return new Iterator<YarnProtos.ContainerStatusProto>(){
                    Iterator<ContainerStatus> iter;
                    {
                        this.iter = NodeStatusPBImpl.this.containers.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public YarnProtos.ContainerStatusProto next() {
                        return NodeStatusPBImpl.this.convertToProtoFormat(this.iter.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
        this.builder.addAllContainersStatuses((Iterable<? extends YarnProtos.ContainerStatusProto>)iterable);
    }

    @Override
    public int getResponseId() {
        YarnServerCommonProtos.NodeStatusProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return p.getResponseId();
    }

    @Override
    public void setResponseId(int responseId) {
        this.maybeInitBuilder();
        this.builder.setResponseId(responseId);
    }

    @Override
    public NodeId getNodeId() {
        YarnServerCommonProtos.NodeStatusProtoOrBuilder p;
        YarnServerCommonProtos.NodeStatusProtoOrBuilder nodeStatusProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (this.nodeId != null) {
            return this.nodeId;
        }
        if (!p.hasNodeId()) {
            return null;
        }
        this.nodeId = this.convertFromProtoFormat(p.getNodeId());
        return this.nodeId;
    }

    @Override
    public void setNodeId(NodeId nodeId) {
        this.maybeInitBuilder();
        if (nodeId == null) {
            this.builder.clearNodeId();
        }
        this.nodeId = nodeId;
    }

    @Override
    public List<ContainerStatus> getContainersStatuses() {
        this.initContainers();
        return this.containers;
    }

    @Override
    public void setContainersStatuses(List<ContainerStatus> containers) {
        if (containers == null) {
            this.builder.clearContainersStatuses();
        }
        this.containers = containers;
    }

    private void initContainers() {
        if (this.containers != null) {
            return;
        }
        YarnServerCommonProtos.NodeStatusProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        List<YarnProtos.ContainerStatusProto> list = p.getContainersStatusesList();
        this.containers = new ArrayList<ContainerStatus>();
        for (YarnProtos.ContainerStatusProto c : list) {
            this.containers.add((ContainerStatus)this.convertFromProtoFormat(c));
        }
    }

    @Override
    public NodeHealthStatus getNodeHealthStatus() {
        YarnServerCommonProtos.NodeStatusProtoOrBuilder p;
        YarnServerCommonProtos.NodeStatusProtoOrBuilder nodeStatusProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (this.nodeHealthStatus != null) {
            return this.nodeHealthStatus;
        }
        if (!p.hasNodeHealthStatus()) {
            return null;
        }
        this.nodeHealthStatus = this.convertFromProtoFormat(p.getNodeHealthStatus());
        return this.nodeHealthStatus;
    }

    @Override
    public void setNodeHealthStatus(NodeHealthStatus healthStatus) {
        this.maybeInitBuilder();
        if (healthStatus == null) {
            this.builder.clearNodeHealthStatus();
        }
        this.nodeHealthStatus = healthStatus;
    }

    private YarnProtos.NodeIdProto convertToProtoFormat(NodeId nodeId) {
        return ((NodeIdPBImpl)nodeId).getProto();
    }

    private NodeId convertFromProtoFormat(YarnProtos.NodeIdProto proto) {
        return new NodeIdPBImpl(proto);
    }

    private YarnProtos.NodeHealthStatusProto convertToProtoFormat(NodeHealthStatus healthStatus) {
        return ((NodeHealthStatusPBImpl)healthStatus).getProto();
    }

    private NodeHealthStatus convertFromProtoFormat(YarnProtos.NodeHealthStatusProto proto) {
        return new NodeHealthStatusPBImpl(proto);
    }

    private ContainerStatusPBImpl convertFromProtoFormat(YarnProtos.ContainerStatusProto c) {
        return new ContainerStatusPBImpl(c);
    }

    private YarnProtos.ContainerStatusProto convertToProtoFormat(ContainerStatus c) {
        return ((ContainerStatusPBImpl)c).getProto();
    }
}

