/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.api.protocolrecords.impl.pb;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ProtoBase;
import org.apache.hadoop.yarn.api.records.impl.pb.ApplicationIdPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ContainerIdPBImpl;
import org.apache.hadoop.yarn.proto.YarnProtos;
import org.apache.hadoop.yarn.proto.YarnServerCommonProtos;
import org.apache.hadoop.yarn.proto.YarnServerCommonServiceProtos;
import org.apache.hadoop.yarn.server.api.protocolrecords.NodeHeartbeatResponse;
import org.apache.hadoop.yarn.server.api.records.MasterKey;
import org.apache.hadoop.yarn.server.api.records.NodeAction;
import org.apache.hadoop.yarn.server.api.records.impl.pb.MasterKeyPBImpl;

public class NodeHeartbeatResponsePBImpl
extends ProtoBase<YarnServerCommonServiceProtos.NodeHeartbeatResponseProto>
implements NodeHeartbeatResponse {
    YarnServerCommonServiceProtos.NodeHeartbeatResponseProto proto = YarnServerCommonServiceProtos.NodeHeartbeatResponseProto.getDefaultInstance();
    YarnServerCommonServiceProtos.NodeHeartbeatResponseProto.Builder builder = null;
    boolean viaProto = false;
    private List<ContainerId> containersToCleanup = null;
    private List<ApplicationId> applicationsToCleanup = null;
    private MasterKey masterKey = null;

    public NodeHeartbeatResponsePBImpl() {
        this.builder = YarnServerCommonServiceProtos.NodeHeartbeatResponseProto.newBuilder();
    }

    public NodeHeartbeatResponsePBImpl(YarnServerCommonServiceProtos.NodeHeartbeatResponseProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    public YarnServerCommonServiceProtos.NodeHeartbeatResponseProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    private void mergeLocalToBuilder() {
        if (this.containersToCleanup != null) {
            this.addContainersToCleanupToProto();
        }
        if (this.applicationsToCleanup != null) {
            this.addApplicationsToCleanupToProto();
        }
        if (this.masterKey != null) {
            this.builder.setMasterKey(this.convertToProtoFormat(this.masterKey));
        }
    }

    private void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnServerCommonServiceProtos.NodeHeartbeatResponseProto.newBuilder(this.proto);
        }
        this.viaProto = false;
    }

    @Override
    public int getResponseId() {
        YarnServerCommonServiceProtos.NodeHeartbeatResponseProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return p.getResponseId();
    }

    @Override
    public void setResponseId(int responseId) {
        this.maybeInitBuilder();
        this.builder.setResponseId(responseId);
    }

    @Override
    public MasterKey getMasterKey() {
        YarnServerCommonServiceProtos.NodeHeartbeatResponseProtoOrBuilder p;
        YarnServerCommonServiceProtos.NodeHeartbeatResponseProtoOrBuilder nodeHeartbeatResponseProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (this.masterKey != null) {
            return this.masterKey;
        }
        if (!p.hasMasterKey()) {
            return null;
        }
        this.masterKey = this.convertFromProtoFormat(p.getMasterKey());
        return this.masterKey;
    }

    @Override
    public void setMasterKey(MasterKey masterKey) {
        this.maybeInitBuilder();
        if (masterKey == null) {
            this.builder.clearMasterKey();
        }
        this.masterKey = masterKey;
    }

    @Override
    public NodeAction getNodeAction() {
        YarnServerCommonServiceProtos.NodeHeartbeatResponseProtoOrBuilder p;
        YarnServerCommonServiceProtos.NodeHeartbeatResponseProtoOrBuilder nodeHeartbeatResponseProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasNodeAction()) {
            return null;
        }
        return this.convertFromProtoFormat(p.getNodeAction());
    }

    @Override
    public void setNodeAction(NodeAction nodeAction) {
        this.maybeInitBuilder();
        if (nodeAction == null) {
            this.builder.clearNodeAction();
            return;
        }
        this.builder.setNodeAction(this.convertToProtoFormat(nodeAction));
    }

    @Override
    public String getDiagnosticsMessage() {
        YarnServerCommonServiceProtos.NodeHeartbeatResponseProtoOrBuilder p;
        YarnServerCommonServiceProtos.NodeHeartbeatResponseProtoOrBuilder nodeHeartbeatResponseProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasDiagnosticsMessage()) {
            return null;
        }
        return p.getDiagnosticsMessage();
    }

    @Override
    public void setDiagnosticsMessage(String diagnosticsMessage) {
        this.maybeInitBuilder();
        if (diagnosticsMessage == null) {
            this.builder.clearDiagnosticsMessage();
            return;
        }
        this.builder.setDiagnosticsMessage(diagnosticsMessage);
    }

    @Override
    public List<ContainerId> getContainersToCleanup() {
        this.initContainersToCleanup();
        return this.containersToCleanup;
    }

    private void initContainersToCleanup() {
        if (this.containersToCleanup != null) {
            return;
        }
        YarnServerCommonServiceProtos.NodeHeartbeatResponseProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        List<YarnProtos.ContainerIdProto> list = p.getContainersToCleanupList();
        this.containersToCleanup = new ArrayList<ContainerId>();
        for (YarnProtos.ContainerIdProto c : list) {
            this.containersToCleanup.add((ContainerId)this.convertFromProtoFormat(c));
        }
    }

    @Override
    public void addAllContainersToCleanup(List<ContainerId> containersToCleanup) {
        if (containersToCleanup == null) {
            return;
        }
        this.initContainersToCleanup();
        this.containersToCleanup.addAll(containersToCleanup);
    }

    private void addContainersToCleanupToProto() {
        this.maybeInitBuilder();
        this.builder.clearContainersToCleanup();
        if (this.containersToCleanup == null) {
            return;
        }
        Iterable<YarnProtos.ContainerIdProto> iterable = new Iterable<YarnProtos.ContainerIdProto>(){

            @Override
            public Iterator<YarnProtos.ContainerIdProto> iterator() {
                return new Iterator<YarnProtos.ContainerIdProto>(){
                    Iterator<ContainerId> iter;
                    {
                        this.iter = NodeHeartbeatResponsePBImpl.this.containersToCleanup.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public YarnProtos.ContainerIdProto next() {
                        return NodeHeartbeatResponsePBImpl.this.convertToProtoFormat(this.iter.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
        this.builder.addAllContainersToCleanup((Iterable<? extends YarnProtos.ContainerIdProto>)iterable);
    }

    @Override
    public List<ApplicationId> getApplicationsToCleanup() {
        this.initApplicationsToCleanup();
        return this.applicationsToCleanup;
    }

    private void initApplicationsToCleanup() {
        if (this.applicationsToCleanup != null) {
            return;
        }
        YarnServerCommonServiceProtos.NodeHeartbeatResponseProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        List<YarnProtos.ApplicationIdProto> list = p.getApplicationsToCleanupList();
        this.applicationsToCleanup = new ArrayList<ApplicationId>();
        for (YarnProtos.ApplicationIdProto c : list) {
            this.applicationsToCleanup.add((ApplicationId)this.convertFromProtoFormat(c));
        }
    }

    @Override
    public void addAllApplicationsToCleanup(List<ApplicationId> applicationsToCleanup) {
        if (applicationsToCleanup == null) {
            return;
        }
        this.initApplicationsToCleanup();
        this.applicationsToCleanup.addAll(applicationsToCleanup);
    }

    private void addApplicationsToCleanupToProto() {
        this.maybeInitBuilder();
        this.builder.clearApplicationsToCleanup();
        if (this.applicationsToCleanup == null) {
            return;
        }
        Iterable<YarnProtos.ApplicationIdProto> iterable = new Iterable<YarnProtos.ApplicationIdProto>(){

            @Override
            public Iterator<YarnProtos.ApplicationIdProto> iterator() {
                return new Iterator<YarnProtos.ApplicationIdProto>(){
                    Iterator<ApplicationId> iter;
                    {
                        this.iter = NodeHeartbeatResponsePBImpl.this.applicationsToCleanup.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public YarnProtos.ApplicationIdProto next() {
                        return NodeHeartbeatResponsePBImpl.this.convertToProtoFormat(this.iter.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
        this.builder.addAllApplicationsToCleanup((Iterable<? extends YarnProtos.ApplicationIdProto>)iterable);
    }

    @Override
    public long getNextHeartBeatInterval() {
        YarnServerCommonServiceProtos.NodeHeartbeatResponseProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return p.getNextHeartBeatInterval();
    }

    @Override
    public void setNextHeartBeatInterval(long nextHeartBeatInterval) {
        this.maybeInitBuilder();
        this.builder.setNextHeartBeatInterval(nextHeartBeatInterval);
    }

    private ContainerIdPBImpl convertFromProtoFormat(YarnProtos.ContainerIdProto p) {
        return new ContainerIdPBImpl(p);
    }

    private YarnProtos.ContainerIdProto convertToProtoFormat(ContainerId t) {
        return ((ContainerIdPBImpl)t).getProto();
    }

    private ApplicationIdPBImpl convertFromProtoFormat(YarnProtos.ApplicationIdProto p) {
        return new ApplicationIdPBImpl(p);
    }

    private YarnProtos.ApplicationIdProto convertToProtoFormat(ApplicationId t) {
        return ((ApplicationIdPBImpl)t).getProto();
    }

    private NodeAction convertFromProtoFormat(YarnServerCommonProtos.NodeActionProto p) {
        return NodeAction.valueOf(p.name());
    }

    private YarnServerCommonProtos.NodeActionProto convertToProtoFormat(NodeAction t) {
        return YarnServerCommonProtos.NodeActionProto.valueOf(t.name());
    }

    private MasterKeyPBImpl convertFromProtoFormat(YarnServerCommonProtos.MasterKeyProto p) {
        return new MasterKeyPBImpl(p);
    }

    private YarnServerCommonProtos.MasterKeyProto convertToProtoFormat(MasterKey t) {
        return ((MasterKeyPBImpl)t).getProto();
    }
}

