/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager;

import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.UnsupportedFileSystemException;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.server.nodemanager.ContainerExecutor;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerDiagnosticsUpdateEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.ContainerLocalizer;
import org.apache.hadoop.yarn.util.ConverterUtils;

public class DefaultContainerExecutor
extends ContainerExecutor {
    private static final Log LOG = LogFactory.getLog(DefaultContainerExecutor.class);
    private final FileContext lfs;
    private static final String WRAPPER_LAUNCH_SCRIPT = "default_container_executor.sh";
    private static final short USER_PERM = 488;
    private static final short APPCACHE_PERM = 456;
    private static final short FILECACHE_PERM = 456;
    private static final short APPDIR_PERM = 456;
    private static final short LOGDIR_PERM = 456;

    public DefaultContainerExecutor() {
        try {
            this.lfs = FileContext.getLocalFSFileContext();
        }
        catch (UnsupportedFileSystemException e) {
            throw new RuntimeException(e);
        }
    }

    DefaultContainerExecutor(FileContext lfs) {
        this.lfs = lfs;
    }

    @Override
    public void init() throws IOException {
    }

    @Override
    public void startLocalizer(Path nmPrivateContainerTokensPath, InetSocketAddress nmAddr, String user, String appId, String locId, List<Path> localDirs) throws IOException, InterruptedException {
        ContainerLocalizer localizer = new ContainerLocalizer(this.lfs, user, appId, locId, localDirs, RecordFactoryProvider.getRecordFactory((Configuration)this.getConf()));
        this.createUserLocalDirs(localDirs, user);
        this.createUserCacheDirs(localDirs, user);
        this.createAppDirs(localDirs, user, appId);
        this.createAppLogDirs(appId);
        Path appStorageDir = this.getFirstApplicationDir(localDirs, user, appId);
        String tokenFn = String.format("%s.tokens", locId);
        Path tokenDst = new Path(appStorageDir, tokenFn);
        this.lfs.util().copy(nmPrivateContainerTokensPath, tokenDst);
        LOG.info((Object)("Copying from " + nmPrivateContainerTokensPath + " to " + tokenDst));
        this.lfs.setWorkingDirectory(appStorageDir);
        LOG.info((Object)("CWD set to " + appStorageDir + " = " + this.lfs.getWorkingDirectory()));
        localizer.runLocalization(nmAddr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int launchContainer(Container container, Path nmPrivateContainerScriptPath, Path nmPrivateTokensPath, String userName, String appId, Path containerWorkDir) throws IOException {
        block8: {
            String[] sLocalDirs;
            ContainerId containerId = container.getContainerID();
            String containerIdStr = ConverterUtils.toString((ContainerId)containerId);
            String appIdStr = ConverterUtils.toString((ApplicationId)container.getContainerID().getApplicationAttemptId().getApplicationId());
            for (String sLocalDir : sLocalDirs = this.getConf().getStrings("yarn.nodemanager.local-dirs", new String[]{"/tmp/nm-local-dir"})) {
                Path usersdir = new Path(sLocalDir, "usercache");
                Path userdir = new Path(usersdir, userName);
                Path appCacheDir = new Path(userdir, "appcache");
                Path appDir = new Path(appCacheDir, appIdStr);
                Path containerDir = new Path(appDir, containerIdStr);
                this.lfs.mkdir(containerDir, null, false);
            }
            this.createContainerLogDirs(appIdStr, containerIdStr);
            Path launchDst = new Path(containerWorkDir, "launch_container.sh");
            this.lfs.util().copy(nmPrivateContainerScriptPath, launchDst);
            Path tokenDst = new Path(containerWorkDir, "container_tokens");
            this.lfs.util().copy(nmPrivateTokensPath, tokenDst);
            Path wrapperScriptDst = new Path(containerWorkDir, WRAPPER_LAUNCH_SCRIPT);
            FSDataOutputStream wrapperScriptOutStream = this.lfs.create(wrapperScriptDst, EnumSet.of(CreateFlag.CREATE, CreateFlag.OVERWRITE), new Options.CreateOpts[0]);
            Path pidFile = this.getPidFilePath(containerId);
            if (pidFile == null) {
                LOG.info((Object)("Container " + containerIdStr + " was marked as inactive. Returning terminated error"));
                return ContainerExecutor.ExitCode.TERMINATED.getExitCode();
            }
            this.writeLocalWrapperScript((DataOutputStream)wrapperScriptOutStream, launchDst.toUri().getPath().toString(), pidFile.toString());
            Shell.ShellCommandExecutor shExec = null;
            try {
                this.lfs.setPermission(launchDst, ContainerExecutor.TASK_LAUNCH_SCRIPT_PERMISSION);
                this.lfs.setPermission(wrapperScriptDst, ContainerExecutor.TASK_LAUNCH_SCRIPT_PERMISSION);
                Object[] command = new String[]{"bash", "-c", wrapperScriptDst.toUri().getPath().toString()};
                LOG.info((Object)("launchContainer: " + Arrays.toString(command)));
                shExec = new Shell.ShellCommandExecutor((String[])command, new File(containerWorkDir.toUri().getPath()), container.getLaunchContext().getEnvironment());
                if (this.isContainerActive(containerId)) {
                    shExec.execute();
                    break block8;
                }
                LOG.info((Object)("Container " + containerIdStr + " was marked as inactive. Returning terminated error"));
                int appDir = ContainerExecutor.ExitCode.TERMINATED.getExitCode();
                return appDir;
            }
            catch (IOException e) {
                block9: {
                    if (null != shExec) break block9;
                    int appDir = -1;
                    return appDir;
                }
                int exitCode = shExec.getExitCode();
                LOG.warn((Object)("Exit code from task is : " + exitCode));
                String message = shExec.getOutput();
                this.logOutput(message);
                container.handle((Event)new ContainerDiagnosticsUpdateEvent(containerId, message));
                int n = exitCode;
                return n;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeLocalWrapperScript(DataOutputStream out, String launchScriptDst, String pidFilePath) throws IOException {
        StringBuilder sb = new StringBuilder("#!/bin/bash\n\n");
        sb.append("echo $$ > " + pidFilePath + ".tmp\n");
        sb.append("/bin/mv -f " + pidFilePath + ".tmp " + pidFilePath + "\n");
        sb.append(ContainerExecutor.isSetsidAvailable ? "exec setsid" : "exec");
        sb.append(" /bin/bash ");
        sb.append("-c ");
        sb.append("\"");
        sb.append(launchScriptDst);
        sb.append("\"\n");
        PrintStream pout = null;
        try {
            pout = new PrintStream(out);
            pout.append(sb);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    @Override
    public boolean signalContainer(String user, String pid, ContainerExecutor.Signal signal) throws IOException {
        String sigpid = ContainerExecutor.isSetsidAvailable ? "-" + pid : pid;
        LOG.debug((Object)("Sending signal " + signal.getValue() + " to pid " + sigpid + " as user " + user));
        try {
            this.sendSignal(sigpid, ContainerExecutor.Signal.NULL);
        }
        catch (Shell.ExitCodeException e) {
            return false;
        }
        try {
            this.sendSignal(sigpid, signal);
        }
        catch (IOException e) {
            try {
                this.sendSignal(sigpid, ContainerExecutor.Signal.NULL);
            }
            catch (IOException ignore) {
                return false;
            }
            throw e;
        }
        return true;
    }

    protected void sendSignal(String pid, ContainerExecutor.Signal signal) throws IOException {
        Shell.ShellCommandExecutor shexec = null;
        String[] arg = new String[]{"kill", "-" + signal.getValue(), pid};
        shexec = new Shell.ShellCommandExecutor(arg);
        shexec.execute();
    }

    @Override
    public void deleteAsUser(String user, Path subDir, Path ... baseDirs) throws IOException, InterruptedException {
        if (baseDirs == null || baseDirs.length == 0) {
            LOG.info((Object)("Deleting absolute path : " + subDir));
            if (!this.lfs.delete(subDir, true)) {
                LOG.warn((Object)("delete returned false for path: [" + subDir + "]"));
            }
            return;
        }
        for (Path baseDir : baseDirs) {
            Path del = subDir == null ? baseDir : new Path(baseDir, subDir);
            LOG.info((Object)("Deleting path : " + del));
            if (this.lfs.delete(del, true)) continue;
            LOG.warn((Object)("delete returned false for path: [" + del + "]"));
        }
    }

    private Path getFirstApplicationDir(List<Path> localDirs, String user, String appId) {
        return this.getApplicationDir(localDirs.get(0), user, appId);
    }

    private Path getApplicationDir(Path base, String user, String appId) {
        return new Path(this.getAppcacheDir(base, user), appId);
    }

    private Path getUserCacheDir(Path base, String user) {
        return new Path(new Path(base, "usercache"), user);
    }

    private Path getAppcacheDir(Path base, String user) {
        return new Path(this.getUserCacheDir(base, user), "appcache");
    }

    private Path getFileCacheDir(Path base, String user) {
        return new Path(this.getUserCacheDir(base, user), "filecache");
    }

    private void createUserLocalDirs(List<Path> localDirs, String user) throws IOException {
        boolean userDirStatus = false;
        FsPermission userperms = new FsPermission(488);
        for (Path localDir : localDirs) {
            try {
                this.lfs.mkdir(this.getUserCacheDir(localDir, user), userperms, true);
            }
            catch (IOException e) {
                LOG.warn((Object)("Unable to create the user directory : " + localDir), (Throwable)e);
                continue;
            }
            userDirStatus = true;
        }
        if (!userDirStatus) {
            throw new IOException("Not able to initialize user directories in any of the configured local directories for user " + user);
        }
    }

    private void createUserCacheDirs(List<Path> localDirs, String user) throws IOException {
        LOG.info((Object)("Initializing user " + user));
        boolean appcacheDirStatus = false;
        boolean distributedCacheDirStatus = false;
        FsPermission appCachePerms = new FsPermission(456);
        FsPermission fileperms = new FsPermission(456);
        for (Path localDir : localDirs) {
            Path appDir = this.getAppcacheDir(localDir, user);
            try {
                this.lfs.mkdir(appDir, appCachePerms, true);
                appcacheDirStatus = true;
            }
            catch (IOException e) {
                LOG.warn((Object)("Unable to create app cache directory : " + appDir), (Throwable)e);
            }
            Path distDir = this.getFileCacheDir(localDir, user);
            try {
                this.lfs.mkdir(distDir, fileperms, true);
                distributedCacheDirStatus = true;
            }
            catch (IOException e) {
                LOG.warn((Object)("Unable to create file cache directory : " + distDir), (Throwable)e);
            }
        }
        if (!appcacheDirStatus) {
            throw new IOException("Not able to initialize app-cache directories in any of the configured local directories for user " + user);
        }
        if (!distributedCacheDirStatus) {
            throw new IOException("Not able to initialize distributed-cache directories in any of the configured local directories for user " + user);
        }
    }

    private void createAppDirs(List<Path> localDirs, String user, String appId) throws IOException {
        boolean initAppDirStatus = false;
        FsPermission appperms = new FsPermission(456);
        for (Path localDir : localDirs) {
            Path fullAppDir = this.getApplicationDir(localDir, user, appId);
            try {
                this.lfs.mkdir(fullAppDir, appperms, true);
                initAppDirStatus = true;
            }
            catch (IOException e) {
                LOG.warn((Object)("Unable to create app directory " + fullAppDir.toString()), (Throwable)e);
            }
        }
        if (!initAppDirStatus) {
            throw new IOException("Not able to initialize app directories in any of the configured local directories for app " + appId.toString());
        }
    }

    private void createAppLogDirs(String appId) throws IOException {
        String[] rootLogDirs = this.getConf().getStrings("yarn.nodemanager.log-dirs", new String[]{"/tmp/logs"});
        boolean appLogDirStatus = false;
        FsPermission appLogDirPerms = new FsPermission(456);
        for (String rootLogDir : rootLogDirs) {
            Path appLogDir = new Path(rootLogDir, appId);
            try {
                this.lfs.mkdir(appLogDir, appLogDirPerms, true);
            }
            catch (IOException e) {
                LOG.warn((Object)("Unable to create the app-log directory : " + appLogDir), (Throwable)e);
                continue;
            }
            appLogDirStatus = true;
        }
        if (!appLogDirStatus) {
            throw new IOException("Not able to initialize app-log directories in any of the configured local directories for app " + appId);
        }
    }

    private void createContainerLogDirs(String appId, String containerId) throws IOException {
        String[] rootLogDirs = this.getConf().getStrings("yarn.nodemanager.log-dirs", new String[]{"/tmp/logs"});
        boolean containerLogDirStatus = false;
        FsPermission containerLogDirPerms = new FsPermission(456);
        for (String rootLogDir : rootLogDirs) {
            Path appLogDir = new Path(rootLogDir, appId);
            Path containerLogDir = new Path(appLogDir, containerId);
            try {
                this.lfs.mkdir(containerLogDir, containerLogDirPerms, true);
            }
            catch (IOException e) {
                LOG.warn((Object)("Unable to create the container-log directory : " + appLogDir), (Throwable)e);
                continue;
            }
            containerLogDirStatus = true;
        }
        if (!containerLogDirStatus) {
            throw new IOException("Not able to initialize container-log directories in any of the configured local directories for container " + containerId);
        }
    }
}

