/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.webapp;

import com.google.inject.Inject;
import java.util.Map;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.webapp.NMView;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.webapp.SubView;
import org.apache.hadoop.yarn.webapp.YarnWebParams;
import org.apache.hadoop.yarn.webapp.hamlet.Hamlet;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.apache.hadoop.yarn.webapp.view.HtmlPage;
import org.apache.hadoop.yarn.webapp.view.JQueryUI;

public class AllContainersPage
extends NMView {
    @Override
    protected void preHead(Hamlet.HTML<HtmlPage._> html) {
        this.commonPreHead(html);
        this.setTitle("All containers running on this node");
        this.set("ui.dataTables.id", "containers");
        this.set(JQueryUI.initID((String)"ui.dataTables", (String)"containers"), this.containersTableInit());
        this.setTableStyles(html, "containers", new String[0]);
    }

    private String containersTableInit() {
        return JQueryUI.tableInit().append(", aoColumns:[null, null, {bSearchable:false}]} ").toString();
    }

    protected Class<? extends SubView> content() {
        return AllContainersBlock.class;
    }

    public static class AllContainersBlock
    extends HtmlBlock
    implements YarnWebParams {
        private final Context nmContext;

        @Inject
        public AllContainersBlock(Context nmContext) {
            this.nmContext = nmContext;
        }

        protected void render(HtmlBlock.Block html) {
            Hamlet.TBODY tableBody = ((Hamlet.TABLE)((Hamlet.THEAD)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)html.body().table("#containers").thead().tr().td()._(new Object[]{"ContainerId"})._()).td()._(new Object[]{"ContainerState"})._()).td()._(new Object[]{"logs"})._())._())._()).tbody();
            for (Map.Entry entry : this.nmContext.getContainers().entrySet()) {
                ContainerId containerId = (ContainerId)entry.getKey();
                Container container = (Container)entry.getValue();
                String containerIdStr = ConverterUtils.toString((ContainerId)containerId);
                ((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)tableBody.tr().td().a(this.url(new String[]{"container", containerIdStr}), containerIdStr)._()).td()._(new Object[]{container.getContainerState()})._()).td().a(this.url(new String[]{"containerlogs", containerIdStr, container.getUser()}), "logs")._())._();
            }
            ((Hamlet.BODY)((Hamlet.TABLE)tableBody._())._())._();
        }
    }
}

