/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.webapp;

import com.google.inject.Inject;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.Application;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerState;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.launcher.ContainerLaunch;
import org.apache.hadoop.yarn.server.nodemanager.webapp.NMView;
import org.apache.hadoop.yarn.server.security.ApplicationACLsManager;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.webapp.SubView;
import org.apache.hadoop.yarn.webapp.YarnWebParams;
import org.apache.hadoop.yarn.webapp.hamlet.Hamlet;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.apache.hadoop.yarn.webapp.view.HtmlPage;
import org.apache.hadoop.yarn.webapp.view.JQueryUI;

public class ContainerLogsPage
extends NMView {
    public static final String REDIRECT_URL = "redirect.url";

    @Override
    protected void preHead(Hamlet.HTML<HtmlPage._> html) {
        String redirectUrl = this.$(REDIRECT_URL);
        if (redirectUrl == null || redirectUrl.isEmpty()) {
            this.set("title", StringHelper.join((Object[])new Object[]{"Logs for ", this.$("container.id")}));
            html.meta_http("refresh", "10");
        } else if (redirectUrl.equals("false")) {
            this.set("title", StringHelper.join((Object[])new Object[]{"Failed redirect for ", this.$("container.id")}));
        } else {
            this.set("title", StringHelper.join((Object[])new Object[]{"Redirecting to log server for ", this.$("container.id")}));
            html.meta_http("refresh", "1; url=" + redirectUrl);
        }
        this.set("ui.accordion.id", "nav");
        this.set(JQueryUI.initID((String)"ui.accordion", (String)"nav"), "{autoHeight:false, active:0}");
        this.set("ui.themeswitcher.id", "themeswitcher");
    }

    protected Class<? extends SubView> content() {
        return ContainersLogsBlock.class;
    }

    public static class ContainersLogsBlock
    extends HtmlBlock
    implements YarnWebParams {
        private final Configuration conf;
        private final LocalDirAllocator logsSelector;
        private final Context nmContext;
        private final ApplicationACLsManager aclsManager;

        @Inject
        public ContainersLogsBlock(Configuration conf, Context context, ApplicationACLsManager aclsManager) {
            this.conf = conf;
            this.logsSelector = new LocalDirAllocator("yarn.nodemanager.log-dirs");
            this.nmContext = context;
            this.aclsManager = aclsManager;
        }

        protected void render(HtmlBlock.Block html) {
            ContainerId containerId;
            String redirectUrl = this.$(ContainerLogsPage.REDIRECT_URL);
            if (redirectUrl != null && redirectUrl.equals("false")) {
                html.h1("Failed while trying to construct the redirect url to the log server. Log Server url may not be configured");
            }
            try {
                containerId = ConverterUtils.toContainerId((String)this.$("container.id"));
            }
            catch (IllegalArgumentException e) {
                html.h1("Invalid containerId " + this.$("container.id"));
                return;
            }
            ApplicationId applicationId = containerId.getApplicationAttemptId().getApplicationId();
            Application application = (Application)this.nmContext.getApplications().get(applicationId);
            Container container = (Container)this.nmContext.getContainers().get(containerId);
            if (application == null) {
                html.h1("Unknown container. Container either has not started or has already completed or doesn't belong to this node at all.");
                return;
            }
            if (container == null) {
                this.printLogs(html, containerId, applicationId, application);
                return;
            }
            if (EnumSet.of(ContainerState.NEW, ContainerState.LOCALIZING, ContainerState.LOCALIZED).contains((Object)container.getContainerState())) {
                html.h1("Container is not yet running. Current state is " + (Object)((Object)container.getContainerState()));
                return;
            }
            if (container.getContainerState() == ContainerState.LOCALIZATION_FAILED) {
                html.h1("Container wasn't started. Localization failed.");
                return;
            }
            if (EnumSet.of(ContainerState.RUNNING, ContainerState.EXITED_WITH_FAILURE, ContainerState.EXITED_WITH_SUCCESS).contains((Object)container.getContainerState())) {
                this.printLogs(html, containerId, applicationId, application);
                return;
            }
            if (EnumSet.of(ContainerState.KILLING, ContainerState.CONTAINER_CLEANEDUP_AFTER_KILL, ContainerState.CONTAINER_RESOURCES_CLEANINGUP).contains((Object)container.getContainerState())) {
                this.printLogs(html, containerId, applicationId, application);
                return;
            }
            if (container.getContainerState().equals((Object)ContainerState.DONE)) {
                this.printLogs(html, containerId, applicationId, application);
                return;
            }
            html.h1("Container is no longer running...");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void printLogs(HtmlBlock.Block html, ContainerId containerId, ApplicationId applicationId, Application application) {
            String remoteUser = this.request().getRemoteUser();
            UserGroupInformation callerUGI = null;
            if (remoteUser != null) {
                callerUGI = UserGroupInformation.createRemoteUser((String)remoteUser);
            }
            if (callerUGI != null && !this.aclsManager.checkAccess(callerUGI, ApplicationAccessType.VIEW_APP, application.getUser(), applicationId)) {
                html.h1("User [" + remoteUser + "] is not authorized to view the logs for application " + applicationId);
                return;
            }
            if (!this.$("log.type").isEmpty()) {
                File logFile = null;
                try {
                    logFile = new File(this.logsSelector.getLocalPathToRead(ContainerLaunch.getRelativeContainerLogDir(applicationId.toString(), containerId.toString()) + "/" + this.$("log.type"), this.conf).toUri().getPath());
                }
                catch (Exception e) {
                    html.h1("Cannot find this log on the local disk.");
                    return;
                }
                long start = this.$("start").isEmpty() ? -4096L : Long.parseLong(this.$("start"));
                start = start < 0L ? logFile.length() + start : start;
                start = start < 0L ? 0L : start;
                long end = this.$("end").isEmpty() ? logFile.length() : Long.parseLong(this.$("end"));
                end = end < 0L ? logFile.length() + end : end;
                long l = end = end < 0L ? logFile.length() : end;
                if (start > end) {
                    html.h1("Invalid start and end values. Start: [" + start + "]" + ", end[" + end + "]");
                    return;
                }
                InputStreamReader reader = null;
                try {
                    long toRead = end - start;
                    if (toRead < logFile.length()) {
                        html.p()._(new Object[]{"Showing " + toRead + " bytes. Click "}).a(this.url(new String[]{"containerlogs", this.$("container.id"), this.$("app.owner"), logFile.getName(), "?start=0"}), "here")._(new Object[]{" for full log"})._();
                    }
                    reader = new FileReader(logFile);
                    int bufferSize = 65536;
                    char[] cbuf = new char[bufferSize];
                    long skipped = 0L;
                    for (long totalSkipped = 0L; totalSkipped < start; totalSkipped += skipped) {
                        skipped = reader.skip(start - totalSkipped);
                    }
                    int len = 0;
                    int currentToRead = toRead > (long)bufferSize ? bufferSize : (int)toRead;
                    this.writer().write("<pre>");
                    while ((len = reader.read(cbuf, 0, currentToRead)) > 0 && toRead > 0L) {
                        this.writer().write(cbuf, 0, len);
                        currentToRead = (toRead -= (long)len) > (long)bufferSize ? bufferSize : (int)toRead;
                    }
                    reader.close();
                    this.writer().write("</pre>");
                }
                catch (IOException e) {
                    html.h1("Exception reading log-file. Log file was likely aggregated. " + StringUtils.stringifyException((Throwable)e));
                }
                finally {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException e) {}
                    }
                }
            } else {
                List<File> containerLogsDirs = ContainersLogsBlock.getContainerLogDirs(this.conf, containerId);
                boolean foundLogFile = false;
                for (File containerLogsDir : containerLogsDirs) {
                    for (File logFile : containerLogsDir.listFiles()) {
                        foundLogFile = true;
                        html.p().a(this.url(new String[]{"containerlogs", this.$("container.id"), this.$("app.owner"), logFile.getName(), "?start=-4096"}), logFile.getName() + " : Total file length is " + logFile.length() + " bytes.")._();
                    }
                }
                if (!foundLogFile) {
                    html.h1("No logs available for container " + containerId.toString());
                    return;
                }
            }
        }

        static List<File> getContainerLogDirs(Configuration conf, ContainerId containerId) {
            String[] logDirs = conf.getStrings("yarn.nodemanager.log-dirs", new String[]{"/tmp/logs"});
            ArrayList<File> containerLogDirs = new ArrayList<File>(logDirs.length);
            for (String logDir : logDirs) {
                String appIdStr = ConverterUtils.toString((ApplicationId)containerId.getApplicationAttemptId().getApplicationId());
                File appLogDir = new File(logDir, appIdStr);
                String containerIdStr = ConverterUtils.toString((ContainerId)containerId);
                containerLogDirs.add(new File(appLogDir, containerIdStr));
            }
            return containerLogDirs;
        }
    }
}

