/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.webapp;

import com.google.inject.Inject;
import java.util.Date;
import org.apache.hadoop.util.VersionInfo;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.ResourceView;
import org.apache.hadoop.yarn.server.nodemanager.webapp.NMView;
import org.apache.hadoop.yarn.util.YarnVersionInfo;
import org.apache.hadoop.yarn.webapp.SubView;
import org.apache.hadoop.yarn.webapp.hamlet.Hamlet;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.apache.hadoop.yarn.webapp.view.HtmlPage;
import org.apache.hadoop.yarn.webapp.view.InfoBlock;
import org.apache.hadoop.yarn.webapp.view.JQueryUI;

public class NodePage
extends NMView {
    @Override
    protected void commonPreHead(Hamlet.HTML<HtmlPage._> html) {
        super.commonPreHead(html);
        this.set(JQueryUI.initID((String)"ui.accordion", (String)"nav"), "{autoHeight:false, active:0}");
    }

    protected Class<? extends SubView> content() {
        return NodeBlock.class;
    }

    public static class NodeBlock
    extends HtmlBlock {
        private final Context context;
        private final ResourceView resourceView;

        @Inject
        public NodeBlock(Context context, ResourceView resourceView) {
            this.context = context;
            this.resourceView = resourceView;
        }

        protected void render(HtmlBlock.Block html) {
            this.info("NodeManager information")._("Total Vmem allocated for Containers", (Object)(this.resourceView.getVmemAllocatedForContainers() + "bytes"))._("Total Pmem allocated for Container", (Object)(this.resourceView.getPmemAllocatedForContainers() + "bytes"))._("NodeHealthyStatus", (Object)this.context.getNodeHealthStatus().getIsNodeHealthy())._("LastNodeHealthTime", (Object)new Date(this.context.getNodeHealthStatus().getLastHealthReportTime()))._("NodeHealthReport", (Object)this.context.getNodeHealthStatus().getHealthReport())._("Node Manger Version:", (Object)(YarnVersionInfo.getBuildVersion() + " on " + YarnVersionInfo.getDate()))._("Hadoop Version:", (Object)(VersionInfo.getBuildVersion() + " on " + VersionInfo.getDate()));
            html._(InfoBlock.class);
        }
    }
}

