/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.avro.AvroRuntimeException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.YarnException;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeHealthStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.exceptions.YarnRemoteException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.server.api.ResourceTracker;
import org.apache.hadoop.yarn.server.api.protocolrecords.NodeHeartbeatRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RegisterNodeManagerRequest;
import org.apache.hadoop.yarn.server.api.records.HeartbeatResponse;
import org.apache.hadoop.yarn.server.api.records.NodeAction;
import org.apache.hadoop.yarn.server.api.records.NodeStatus;
import org.apache.hadoop.yarn.server.api.records.RegistrationResponse;
import org.apache.hadoop.yarn.server.nodemanager.CMgrCompletedAppsEvent;
import org.apache.hadoop.yarn.server.nodemanager.CMgrCompletedContainersEvent;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.NodeHealthCheckerService;
import org.apache.hadoop.yarn.server.nodemanager.NodeStatusUpdater;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.metrics.NodeManagerMetrics;
import org.apache.hadoop.yarn.server.security.ContainerTokenSecretManager;
import org.apache.hadoop.yarn.service.AbstractService;

public class NodeStatusUpdaterImpl
extends AbstractService
implements NodeStatusUpdater {
    private static final Log LOG = LogFactory.getLog(NodeStatusUpdaterImpl.class);
    private final Object heartbeatMonitor = new Object();
    private final Context context;
    private final Dispatcher dispatcher;
    private NodeId nodeId;
    private ContainerTokenSecretManager containerTokenSecretManager;
    private long heartBeatInterval;
    private ResourceTracker resourceTracker;
    private String rmAddress;
    private Resource totalResource;
    private int httpPort;
    private byte[] secretKeyBytes = new byte[0];
    private boolean isStopped;
    private RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    private boolean tokenKeepAliveEnabled;
    private long tokenRemovalDelayMs;
    private Map<ApplicationId, Long> appTokenKeepAliveMap = new HashMap<ApplicationId, Long>();
    private Random keepAliveDelayRandom = new Random();
    private final NodeHealthCheckerService healthChecker;
    private final NodeManagerMetrics metrics;

    public NodeStatusUpdaterImpl(Context context, Dispatcher dispatcher, NodeHealthCheckerService healthChecker, NodeManagerMetrics metrics, ContainerTokenSecretManager containerTokenSecretManager) {
        super(NodeStatusUpdaterImpl.class.getName());
        this.healthChecker = healthChecker;
        this.context = context;
        this.dispatcher = dispatcher;
        this.metrics = metrics;
        this.containerTokenSecretManager = containerTokenSecretManager;
    }

    public synchronized void init(Configuration conf) {
        this.rmAddress = conf.get("yarn.resourcemanager.resource-tracker.address", "0.0.0.0:8025");
        this.heartBeatInterval = conf.getLong("yarn.nodemanager.heartbeat.interval-ms", 1000L);
        int memoryMb = conf.getInt("yarn.nodemanager.resource.memory-mb", 8192);
        this.totalResource = (Resource)this.recordFactory.newRecordInstance(Resource.class);
        this.totalResource.setMemory(memoryMb);
        this.metrics.addResource(this.totalResource);
        this.tokenKeepAliveEnabled = conf.getBoolean("yarn.log-aggregation-enable", false) && this.isSecurityEnabled();
        this.tokenRemovalDelayMs = conf.getInt("yarn.nm.liveness-monitor.expiry-interval-ms", 600000);
        super.init(conf);
    }

    public void start() {
        this.nodeId = this.context.getNodeId();
        String httpBindAddressStr = this.getConfig().get("yarn.nodemanager.webapp.address", "0.0.0.0:9999");
        InetSocketAddress httpBindAddress = NetUtils.createSocketAddr((String)httpBindAddressStr, (int)9999, (String)"yarn.nodemanager.webapp.address");
        try {
            this.httpPort = httpBindAddress.getPort();
            this.registerWithRM();
            super.start();
            this.startStatusUpdater();
        }
        catch (Exception e) {
            throw new AvroRuntimeException((Throwable)e);
        }
    }

    public synchronized void stop() {
        this.isStopped = true;
        super.stop();
    }

    protected boolean isSecurityEnabled() {
        return UserGroupInformation.isSecurityEnabled();
    }

    protected ResourceTracker getRMClient() {
        Configuration conf = this.getConfig();
        YarnRPC rpc = YarnRPC.create((Configuration)conf);
        InetSocketAddress rmAddress = NetUtils.createSocketAddr((String)this.rmAddress, (int)8025, (String)"yarn.resourcemanager.resource-tracker.address");
        return (ResourceTracker)rpc.getProxy(ResourceTracker.class, rmAddress, conf);
    }

    private void registerWithRM() throws YarnRemoteException {
        this.resourceTracker = this.getRMClient();
        LOG.info((Object)("Connected to ResourceManager at " + this.rmAddress));
        RegisterNodeManagerRequest request = (RegisterNodeManagerRequest)this.recordFactory.newRecordInstance(RegisterNodeManagerRequest.class);
        request.setHttpPort(this.httpPort);
        request.setResource(this.totalResource);
        request.setNodeId(this.nodeId);
        RegistrationResponse regResponse = this.resourceTracker.registerNodeManager(request).getRegistrationResponse();
        if (NodeAction.SHUTDOWN.equals((Object)regResponse.getNodeAction())) {
            throw new YarnException("Recieved SHUTDOWN signal from Resourcemanager ,Registration of NodeManager failed");
        }
        if (UserGroupInformation.isSecurityEnabled()) {
            this.secretKeyBytes = regResponse.getSecretKey().array();
        }
        if (UserGroupInformation.isSecurityEnabled()) {
            LOG.info((Object)"Security enabled - updating secret keys now");
            this.containerTokenSecretManager.setSecretKey((CharSequence)this.nodeId.toString(), this.getRMNMSharedSecret());
        }
        LOG.info((Object)("Registered with ResourceManager as " + this.nodeId + " with total resource of " + this.totalResource));
    }

    @Override
    public byte[] getRMNMSharedSecret() {
        return (byte[])this.secretKeyBytes.clone();
    }

    private List<ApplicationId> createKeepAliveApplicationList() {
        if (!this.tokenKeepAliveEnabled) {
            return Collections.emptyList();
        }
        ArrayList<ApplicationId> appList = new ArrayList<ApplicationId>();
        Iterator<Map.Entry<ApplicationId, Long>> i = this.appTokenKeepAliveMap.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<ApplicationId, Long> e = i.next();
            ApplicationId appId = e.getKey();
            Long nextKeepAlive = e.getValue();
            if (!this.context.getApplications().containsKey(appId)) {
                i.remove();
                continue;
            }
            if (System.currentTimeMillis() <= nextKeepAlive) continue;
            appList.add(appId);
            this.trackAppForKeepAlive(appId);
        }
        return appList;
    }

    private NodeStatus getNodeStatus() {
        NodeStatus nodeStatus = (NodeStatus)this.recordFactory.newRecordInstance(NodeStatus.class);
        nodeStatus.setNodeId(this.nodeId);
        int numActiveContainers = 0;
        ArrayList<ContainerStatus> containersStatuses = new ArrayList<ContainerStatus>();
        Iterator i = this.context.getContainers().entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            ContainerId containerId = (ContainerId)e.getKey();
            Container container = (Container)e.getValue();
            ContainerStatus containerStatus = container.cloneAndGetContainerStatus();
            containersStatuses.add(containerStatus);
            ++numActiveContainers;
            LOG.info((Object)("Sending out status for container: " + containerStatus));
            if (containerStatus.getState() != ContainerState.COMPLETE) continue;
            i.remove();
            LOG.info((Object)("Removed completed container " + containerId));
        }
        nodeStatus.setContainersStatuses(containersStatuses);
        LOG.debug((Object)(this.nodeId + " sending out status for " + numActiveContainers + " containers"));
        NodeHealthStatus nodeHealthStatus = this.context.getNodeHealthStatus();
        nodeHealthStatus.setHealthReport(this.healthChecker.getHealthReport());
        nodeHealthStatus.setIsNodeHealthy(this.healthChecker.isHealthy());
        nodeHealthStatus.setLastHealthReportTime(this.healthChecker.getLastHealthReportTime());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Node's health-status : " + nodeHealthStatus.getIsNodeHealthy() + ", " + nodeHealthStatus.getHealthReport()));
        }
        nodeStatus.setNodeHealthStatus(nodeHealthStatus);
        List<ApplicationId> keepAliveAppIds = this.createKeepAliveApplicationList();
        nodeStatus.setKeepAliveApplications(keepAliveAppIds);
        return nodeStatus;
    }

    private void trackAppsForKeepAlive(List<ApplicationId> appIds) {
        if (this.tokenKeepAliveEnabled && appIds != null && appIds.size() > 0) {
            for (ApplicationId appId : appIds) {
                this.trackAppForKeepAlive(appId);
            }
        }
    }

    private void trackAppForKeepAlive(ApplicationId appId) {
        long nextTime = System.currentTimeMillis() + (long)(0.7 * (double)this.tokenRemovalDelayMs + 0.2 * (double)this.tokenRemovalDelayMs * (double)this.keepAliveDelayRandom.nextInt(100) / 100.0);
        this.appTokenKeepAliveMap.put(appId, nextTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendOutofBandHeartBeat() {
        Object object = this.heartbeatMonitor;
        synchronized (object) {
            this.heartbeatMonitor.notify();
        }
    }

    protected void startStatusUpdater() {
        new Thread("Node Status Updater"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                int lastHeartBeatID = 0;
                while (!NodeStatusUpdaterImpl.this.isStopped) {
                    try {
                        Object object = NodeStatusUpdaterImpl.this.heartbeatMonitor;
                        synchronized (object) {
                            NodeStatusUpdaterImpl.this.heartbeatMonitor.wait(NodeStatusUpdaterImpl.this.heartBeatInterval);
                        }
                        NodeStatus nodeStatus = NodeStatusUpdaterImpl.this.getNodeStatus();
                        nodeStatus.setResponseId(lastHeartBeatID);
                        NodeHeartbeatRequest request = (NodeHeartbeatRequest)NodeStatusUpdaterImpl.this.recordFactory.newRecordInstance(NodeHeartbeatRequest.class);
                        request.setNodeStatus(nodeStatus);
                        HeartbeatResponse response = NodeStatusUpdaterImpl.this.resourceTracker.nodeHeartbeat(request).getHeartbeatResponse();
                        if (response.getNodeAction() == NodeAction.SHUTDOWN) {
                            LOG.info((Object)"Recieved SHUTDOWN signal from Resourcemanager as part of heartbeat, hence shutting down.");
                            NodeStatusUpdaterImpl.this.stop();
                            break;
                        }
                        if (response.getNodeAction() == NodeAction.REBOOT) {
                            LOG.info((Object)"Node is out of sync with ResourceManager, hence shutting down.");
                            NodeStatusUpdaterImpl.this.stop();
                            break;
                        }
                        lastHeartBeatID = response.getResponseId();
                        List containersToCleanup = response.getContainersToCleanupList();
                        if (containersToCleanup.size() != 0) {
                            NodeStatusUpdaterImpl.this.dispatcher.getEventHandler().handle((Event)new CMgrCompletedContainersEvent(containersToCleanup));
                        }
                        List appsToCleanup = response.getApplicationsToCleanupList();
                        NodeStatusUpdaterImpl.this.trackAppsForKeepAlive(appsToCleanup);
                        if (appsToCleanup.size() == 0) continue;
                        NodeStatusUpdaterImpl.this.dispatcher.getEventHandler().handle((Event)new CMgrCompletedAppsEvent(appsToCleanup));
                    }
                    catch (Throwable e) {
                        LOG.error((Object)"Caught exception in status-updater", e);
                    }
                }
            }
        }.start();
    }
}

