/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.api.protocolrecords.impl.pb;

import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.ProtoBase;
import org.apache.hadoop.yarn.api.records.URL;
import org.apache.hadoop.yarn.api.records.impl.pb.LocalResourcePBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.URLPBImpl;
import org.apache.hadoop.yarn.exceptions.YarnRemoteException;
import org.apache.hadoop.yarn.exceptions.impl.pb.YarnRemoteExceptionPBImpl;
import org.apache.hadoop.yarn.proto.YarnProtos;
import org.apache.hadoop.yarn.proto.YarnServerNodemanagerServiceProtos;
import org.apache.hadoop.yarn.server.nodemanager.api.protocolrecords.LocalResourceStatus;
import org.apache.hadoop.yarn.server.nodemanager.api.protocolrecords.ResourceStatusType;

public class LocalResourceStatusPBImpl
extends ProtoBase<YarnServerNodemanagerServiceProtos.LocalResourceStatusProto>
implements LocalResourceStatus {
    YarnServerNodemanagerServiceProtos.LocalResourceStatusProto proto = YarnServerNodemanagerServiceProtos.LocalResourceStatusProto.getDefaultInstance();
    YarnServerNodemanagerServiceProtos.LocalResourceStatusProto.Builder builder = null;
    boolean viaProto = false;
    private LocalResource resource;
    private URL localPath;
    private YarnRemoteException exception;

    public LocalResourceStatusPBImpl() {
        this.builder = YarnServerNodemanagerServiceProtos.LocalResourceStatusProto.newBuilder();
    }

    public LocalResourceStatusPBImpl(YarnServerNodemanagerServiceProtos.LocalResourceStatusProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    public YarnServerNodemanagerServiceProtos.LocalResourceStatusProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    private void mergeLocalToBuilder() {
        if (this.resource != null && !((LocalResourcePBImpl)this.resource).getProto().equals((Object)this.builder.getResource())) {
            this.builder.setResource(this.convertToProtoFormat(this.resource));
        }
        if (this.localPath != null && !((URLPBImpl)this.localPath).getProto().equals((Object)this.builder.getLocalPath())) {
            this.builder.setLocalPath(this.convertToProtoFormat(this.localPath));
        }
        if (this.exception != null && !((YarnRemoteExceptionPBImpl)this.exception).getProto().equals((Object)this.builder.getException())) {
            this.builder.setException(this.convertToProtoFormat(this.exception));
        }
    }

    private void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnServerNodemanagerServiceProtos.LocalResourceStatusProto.newBuilder(this.proto);
        }
        this.viaProto = false;
    }

    @Override
    public LocalResource getResource() {
        YarnServerNodemanagerServiceProtos.LocalResourceStatusProtoOrBuilder p;
        YarnServerNodemanagerServiceProtos.LocalResourceStatusProtoOrBuilder localResourceStatusProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (this.resource != null) {
            return this.resource;
        }
        if (!p.hasResource()) {
            return null;
        }
        this.resource = this.convertFromProtoFormat(p.getResource());
        return this.resource;
    }

    @Override
    public ResourceStatusType getStatus() {
        YarnServerNodemanagerServiceProtos.LocalResourceStatusProtoOrBuilder p;
        YarnServerNodemanagerServiceProtos.LocalResourceStatusProtoOrBuilder localResourceStatusProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasStatus()) {
            return null;
        }
        return this.convertFromProtoFormat(p.getStatus());
    }

    @Override
    public URL getLocalPath() {
        YarnServerNodemanagerServiceProtos.LocalResourceStatusProtoOrBuilder p;
        YarnServerNodemanagerServiceProtos.LocalResourceStatusProtoOrBuilder localResourceStatusProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (this.localPath != null) {
            return this.localPath;
        }
        if (!p.hasLocalPath()) {
            return null;
        }
        this.localPath = this.convertFromProtoFormat(p.getLocalPath());
        return this.localPath;
    }

    @Override
    public long getLocalSize() {
        YarnServerNodemanagerServiceProtos.LocalResourceStatusProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return p.getLocalSize();
    }

    @Override
    public YarnRemoteException getException() {
        YarnServerNodemanagerServiceProtos.LocalResourceStatusProtoOrBuilder p;
        YarnServerNodemanagerServiceProtos.LocalResourceStatusProtoOrBuilder localResourceStatusProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (this.exception != null) {
            return this.exception;
        }
        if (!p.hasException()) {
            return null;
        }
        this.exception = this.convertFromProtoFormat(p.getException());
        return this.exception;
    }

    @Override
    public void setResource(LocalResource resource) {
        this.maybeInitBuilder();
        if (resource == null) {
            this.builder.clearResource();
        }
        this.resource = resource;
    }

    @Override
    public void setStatus(ResourceStatusType status) {
        this.maybeInitBuilder();
        if (status == null) {
            this.builder.clearStatus();
            return;
        }
        this.builder.setStatus(this.convertToProtoFormat(status));
    }

    @Override
    public void setLocalPath(URL localPath) {
        this.maybeInitBuilder();
        if (localPath == null) {
            this.builder.clearLocalPath();
        }
        this.localPath = localPath;
    }

    @Override
    public void setLocalSize(long size) {
        this.maybeInitBuilder();
        this.builder.setLocalSize(size);
    }

    @Override
    public void setException(YarnRemoteException exception) {
        this.maybeInitBuilder();
        if (exception == null) {
            this.builder.clearException();
        }
        this.exception = exception;
    }

    private YarnProtos.LocalResourceProto convertToProtoFormat(LocalResource rsrc) {
        return ((LocalResourcePBImpl)rsrc).getProto();
    }

    private LocalResourcePBImpl convertFromProtoFormat(YarnProtos.LocalResourceProto rsrc) {
        return new LocalResourcePBImpl(rsrc);
    }

    private URLPBImpl convertFromProtoFormat(YarnProtos.URLProto p) {
        return new URLPBImpl(p);
    }

    private YarnProtos.URLProto convertToProtoFormat(URL t) {
        return ((URLPBImpl)t).getProto();
    }

    private YarnServerNodemanagerServiceProtos.ResourceStatusTypeProto convertToProtoFormat(ResourceStatusType e) {
        return YarnServerNodemanagerServiceProtos.ResourceStatusTypeProto.valueOf(e.name());
    }

    private ResourceStatusType convertFromProtoFormat(YarnServerNodemanagerServiceProtos.ResourceStatusTypeProto e) {
        return ResourceStatusType.valueOf(e.name());
    }

    private YarnRemoteExceptionPBImpl convertFromProtoFormat(YarnProtos.YarnRemoteExceptionProto p) {
        return new YarnRemoteExceptionPBImpl(p);
    }

    private YarnProtos.YarnRemoteExceptionProto convertToProtoFormat(YarnRemoteException t) {
        return ((YarnRemoteExceptionPBImpl)t).getProto();
    }
}

