/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.server.api.ResourceTracker;
import org.apache.hadoop.yarn.server.api.protocolrecords.NodeHeartbeatResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RegisterNodeManagerRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RegisterNodeManagerResponse;
import org.apache.hadoop.yarn.server.api.records.MasterKey;
import org.apache.hadoop.yarn.server.api.records.NodeAction;
import org.apache.hadoop.yarn.server.api.records.NodeHealthStatus;
import org.apache.hadoop.yarn.server.api.records.NodeStatus;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.NodeHealthCheckerService;
import org.apache.hadoop.yarn.server.nodemanager.NodeStatusUpdater;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.ContainerManagerImpl;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.metrics.NodeManagerMetrics;

public class NodeStatusUpdaterImpl
extends AbstractService
implements NodeStatusUpdater {
    private static final Log LOG = LogFactory.getLog(NodeStatusUpdaterImpl.class);
    private final Object heartbeatMonitor = new Object();
    private final Context context;
    private final Dispatcher dispatcher;
    private NodeId nodeId;
    private long nextHeartBeatInterval;
    private ResourceTracker resourceTracker;
    private InetSocketAddress rmAddress;
    private Resource totalResource;
    private int httpPort;
    private volatile boolean isStopped;
    private RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    private boolean tokenKeepAliveEnabled;
    private long tokenRemovalDelayMs;
    private Map<ApplicationId, Long> appTokenKeepAliveMap = new HashMap<ApplicationId, Long>();
    private Random keepAliveDelayRandom = new Random();
    private final NodeHealthCheckerService healthChecker;
    private final NodeManagerMetrics metrics;
    private long rmConnectWaitMS;
    private long rmConnectionRetryIntervalMS;
    private boolean waitForEver;
    private Runnable statusUpdaterRunnable;
    private Thread statusUpdater;
    private long rmIdentifier = -1L;

    public NodeStatusUpdaterImpl(Context context, Dispatcher dispatcher, NodeHealthCheckerService healthChecker, NodeManagerMetrics metrics) {
        super(NodeStatusUpdaterImpl.class.getName());
        this.healthChecker = healthChecker;
        this.context = context;
        this.dispatcher = dispatcher;
        this.metrics = metrics;
    }

    protected void serviceInit(Configuration conf) throws Exception {
        this.rmAddress = conf.getSocketAddr("yarn.resourcemanager.resource-tracker.address", "0.0.0.0:8031", 8031);
        int memoryMb = conf.getInt("yarn.nodemanager.resource.memory-mb", 8192);
        float vMemToPMem = conf.getFloat("yarn.nodemanager.vmem-pmem-ratio", 2.1f);
        int virtualMemoryMb = (int)Math.ceil((float)memoryMb * vMemToPMem);
        int virtualCores = conf.getInt("yarn.nodemanager.resource.cpu-vcores", 8);
        this.totalResource = (Resource)this.recordFactory.newRecordInstance(Resource.class);
        this.totalResource.setMemory(memoryMb);
        this.totalResource.setVirtualCores(virtualCores);
        this.metrics.addResource(this.totalResource);
        this.tokenKeepAliveEnabled = this.isTokenKeepAliveEnabled(conf);
        this.tokenRemovalDelayMs = conf.getInt("yarn.nm.liveness-monitor.expiry-interval-ms", 600000);
        LOG.info((Object)("Initialized nodemanager for " + this.nodeId + ":" + " physical-memory=" + memoryMb + " virtual-memory=" + virtualMemoryMb + " virtual-cores=" + virtualCores));
        super.serviceInit(conf);
    }

    protected void serviceStart() throws Exception {
        this.nodeId = this.context.getNodeId();
        this.httpPort = this.context.getHttpPort();
        try {
            this.registerWithRM();
            super.serviceStart();
            this.startStatusUpdater();
        }
        catch (Exception e) {
            String errorMessage = "Unexpected error starting NodeStatusUpdater";
            LOG.error((Object)errorMessage, (Throwable)e);
            throw new YarnRuntimeException((Throwable)e);
        }
    }

    protected void serviceStop() throws Exception {
        this.isStopped = true;
        super.serviceStop();
    }

    protected void rebootNodeStatusUpdater() {
        this.isStopped = true;
        try {
            this.statusUpdater.join();
            this.registerWithRM();
            this.statusUpdater = new Thread(this.statusUpdaterRunnable, "Node Status Updater");
            this.isStopped = false;
            this.statusUpdater.start();
            LOG.info((Object)"NodeStatusUpdater thread is reRegistered and restarted");
        }
        catch (Exception e) {
            String errorMessage = "Unexpected error rebooting NodeStatusUpdater";
            LOG.error((Object)errorMessage, (Throwable)e);
            throw new YarnRuntimeException((Throwable)e);
        }
    }

    @InterfaceAudience.Private
    protected boolean isTokenKeepAliveEnabled(Configuration conf) {
        return conf.getBoolean("yarn.log-aggregation-enable", false) && UserGroupInformation.isSecurityEnabled();
    }

    protected ResourceTracker getRMClient() {
        Configuration conf = this.getConfig();
        YarnRPC rpc = YarnRPC.create((Configuration)conf);
        return (ResourceTracker)rpc.getProxy(ResourceTracker.class, this.rmAddress, conf);
    }

    @VisibleForTesting
    protected void registerWithRM() throws YarnException, IOException {
        RegisterNodeManagerResponse regNMResponse;
        Configuration conf = this.getConfig();
        this.rmConnectWaitMS = conf.getInt("yarn.nodemanager.resourcemanager.connect.wait.secs", 900) * 1000;
        this.rmConnectionRetryIntervalMS = conf.getLong("yarn.nodemanager.resourcemanager.connect.retry_interval.secs", 30L) * 1000L;
        if (this.rmConnectionRetryIntervalMS < 0L) {
            throw new YarnRuntimeException("Invalid Configuration. yarn.nodemanager.resourcemanager.connect.retry_interval.secs should not be negative.");
        }
        boolean bl = this.waitForEver = this.rmConnectWaitMS == -1000L;
        if (!this.waitForEver) {
            if (this.rmConnectWaitMS < 0L) {
                throw new YarnRuntimeException("Invalid Configuration. yarn.nodemanager.resourcemanager.connect.wait.secs can be -1, but can not be other negative numbers");
            }
            if (this.rmConnectWaitMS < this.rmConnectionRetryIntervalMS) {
                LOG.warn((Object)"yarn.nodemanager.resourcemanager.connect.wait.secs is smaller than yarn.nodemanager.resourcemanager.connect.retry_interval.secs. Only try connect once.");
                this.rmConnectWaitMS = 0L;
            }
        }
        int rmRetryCount = 0;
        long waitStartTime = System.currentTimeMillis();
        RegisterNodeManagerRequest request = (RegisterNodeManagerRequest)this.recordFactory.newRecordInstance(RegisterNodeManagerRequest.class);
        request.setHttpPort(this.httpPort);
        request.setResource(this.totalResource);
        request.setNodeId(this.nodeId);
        while (true) {
            try {
                LOG.info((Object)("Connecting to ResourceManager at " + this.rmAddress + ". current no. of attempts is " + ++rmRetryCount));
                this.resourceTracker = this.getRMClient();
                regNMResponse = this.resourceTracker.registerNodeManager(request);
                this.rmIdentifier = regNMResponse.getRMIdentifier();
            }
            catch (Throwable e) {
                LOG.warn((Object)("Trying to connect to ResourceManager, current no. of failed attempts is " + rmRetryCount));
                if (System.currentTimeMillis() - waitStartTime < this.rmConnectWaitMS || this.waitForEver) {
                    try {
                        LOG.info((Object)("Sleeping for " + this.rmConnectionRetryIntervalMS / 1000L + " seconds before next connection retry to RM"));
                        Thread.sleep(this.rmConnectionRetryIntervalMS);
                    }
                    catch (InterruptedException ex) {}
                    continue;
                }
                String errorMessage = "Failed to Connect to RM, no. of failed attempts is " + rmRetryCount;
                LOG.error((Object)errorMessage, e);
                throw new YarnRuntimeException(errorMessage, e);
            }
            break;
        }
        if (NodeAction.SHUTDOWN.equals((Object)regNMResponse.getNodeAction())) {
            String message = "Message from ResourceManager: " + regNMResponse.getDiagnosticsMessage();
            throw new YarnRuntimeException("Recieved SHUTDOWN signal from Resourcemanager ,Registration of NodeManager failed, " + message);
        }
        MasterKey masterKey = regNMResponse.getContainerTokenMasterKey();
        if (masterKey != null) {
            this.context.getContainerTokenSecretManager().setMasterKey(masterKey);
        }
        if ((masterKey = regNMResponse.getNMTokenMasterKey()) != null) {
            this.context.getNMTokenSecretManager().setMasterKey(masterKey);
        }
        LOG.info((Object)("Registered with ResourceManager as " + this.nodeId + " with total resource of " + this.totalResource));
        LOG.info((Object)"Notifying ContainerManager to unblock new container-requests");
        ((ContainerManagerImpl)this.context.getContainerManager()).setBlockNewContainerRequests(false);
    }

    private List<ApplicationId> createKeepAliveApplicationList() {
        if (!this.tokenKeepAliveEnabled) {
            return Collections.emptyList();
        }
        ArrayList<ApplicationId> appList = new ArrayList<ApplicationId>();
        Iterator<Map.Entry<ApplicationId, Long>> i = this.appTokenKeepAliveMap.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<ApplicationId, Long> e = i.next();
            ApplicationId appId = e.getKey();
            Long nextKeepAlive = e.getValue();
            if (!this.context.getApplications().containsKey(appId)) {
                i.remove();
                continue;
            }
            if (System.currentTimeMillis() <= nextKeepAlive) continue;
            appList.add(appId);
            this.trackAppForKeepAlive(appId);
        }
        return appList;
    }

    @Override
    public NodeStatus getNodeStatusAndUpdateContainersInContext() {
        NodeStatus nodeStatus = (NodeStatus)this.recordFactory.newRecordInstance(NodeStatus.class);
        nodeStatus.setNodeId(this.nodeId);
        int numActiveContainers = 0;
        ArrayList<ContainerStatus> containersStatuses = new ArrayList<ContainerStatus>();
        Iterator i = this.context.getContainers().entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            ContainerId containerId = (ContainerId)e.getKey();
            Container container = (Container)e.getValue();
            ContainerStatus containerStatus = container.cloneAndGetContainerStatus();
            containersStatuses.add(containerStatus);
            ++numActiveContainers;
            LOG.info((Object)("Sending out status for container: " + containerStatus));
            if (containerStatus.getState() != ContainerState.COMPLETE) continue;
            i.remove();
            LOG.info((Object)("Removed completed container " + containerId));
        }
        nodeStatus.setContainersStatuses(containersStatuses);
        LOG.debug((Object)(this.nodeId + " sending out status for " + numActiveContainers + " containers"));
        NodeHealthStatus nodeHealthStatus = this.context.getNodeHealthStatus();
        nodeHealthStatus.setHealthReport(this.healthChecker.getHealthReport());
        nodeHealthStatus.setIsNodeHealthy(this.healthChecker.isHealthy());
        nodeHealthStatus.setLastHealthReportTime(this.healthChecker.getLastHealthReportTime());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Node's health-status : " + nodeHealthStatus.getIsNodeHealthy() + ", " + nodeHealthStatus.getHealthReport()));
        }
        nodeStatus.setNodeHealthStatus(nodeHealthStatus);
        List<ApplicationId> keepAliveAppIds = this.createKeepAliveApplicationList();
        nodeStatus.setKeepAliveApplications(keepAliveAppIds);
        return nodeStatus;
    }

    private void trackAppsForKeepAlive(List<ApplicationId> appIds) {
        if (this.tokenKeepAliveEnabled && appIds != null && appIds.size() > 0) {
            for (ApplicationId appId : appIds) {
                this.trackAppForKeepAlive(appId);
            }
        }
    }

    private void trackAppForKeepAlive(ApplicationId appId) {
        long nextTime = System.currentTimeMillis() + (long)(0.7 * (double)this.tokenRemovalDelayMs + 0.2 * (double)this.tokenRemovalDelayMs * (double)this.keepAliveDelayRandom.nextInt(100) / 100.0);
        this.appTokenKeepAliveMap.put(appId, nextTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendOutofBandHeartBeat() {
        Object object = this.heartbeatMonitor;
        synchronized (object) {
            this.heartbeatMonitor.notify();
        }
    }

    @Override
    public long getRMIdentifier() {
        return this.rmIdentifier;
    }

    protected void startStatusUpdater() {
        this.statusUpdaterRunnable = new Runnable(){

            /*
             * Exception decompiling
             */
            @Override
            public void run() {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [29[CATCHBLOCK]], but top level block is 11[TRYBLOCK]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            private void updateMasterKeys(NodeHeartbeatResponse response) {
                MasterKey updatedMasterKey = response.getContainerTokenMasterKey();
                if (updatedMasterKey != null) {
                    NodeStatusUpdaterImpl.this.context.getContainerTokenSecretManager().setMasterKey(updatedMasterKey);
                }
                if ((updatedMasterKey = response.getNMTokenMasterKey()) != null) {
                    NodeStatusUpdaterImpl.this.context.getNMTokenSecretManager().setMasterKey(updatedMasterKey);
                }
            }
        };
        this.statusUpdater = new Thread(this.statusUpdaterRunnable, "Node Status Updater");
        this.statusUpdater.start();
    }

    static /* synthetic */ boolean access$000(NodeStatusUpdaterImpl x0) {
        return x0.isStopped;
    }

    static /* synthetic */ RecordFactory access$100(NodeStatusUpdaterImpl x0) {
        return x0.recordFactory;
    }

    static /* synthetic */ ResourceTracker access$300(NodeStatusUpdaterImpl x0) {
        return x0.resourceTracker;
    }

    static /* synthetic */ Log access$400() {
        return LOG;
    }

    static /* synthetic */ long access$500(NodeStatusUpdaterImpl x0) {
        return x0.rmConnectWaitMS;
    }

    static /* synthetic */ boolean access$600(NodeStatusUpdaterImpl x0) {
        return x0.waitForEver;
    }

    static /* synthetic */ long access$700(NodeStatusUpdaterImpl x0) {
        return x0.rmConnectionRetryIntervalMS;
    }

    static /* synthetic */ long access$802(NodeStatusUpdaterImpl x0, long x1) {
        x0.nextHeartBeatInterval = x1;
        return x0.nextHeartBeatInterval;
    }

    static /* synthetic */ Dispatcher access$900(NodeStatusUpdaterImpl x0) {
        return x0.dispatcher;
    }

    static /* synthetic */ long access$1002(NodeStatusUpdaterImpl x0, long x1) {
        x0.rmIdentifier = x1;
        return x0.rmIdentifier;
    }

    static /* synthetic */ void access$1100(NodeStatusUpdaterImpl x0, List x1) {
        x0.trackAppsForKeepAlive(x1);
    }

    static /* synthetic */ Object access$1200(NodeStatusUpdaterImpl x0) {
        return x0.heartbeatMonitor;
    }

    static /* synthetic */ long access$800(NodeStatusUpdaterImpl x0) {
        return x0.nextHeartBeatInterval;
    }
}

