/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.security;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.security.ContainerTokenIdentifier;
import org.apache.hadoop.yarn.server.api.records.MasterKey;
import org.apache.hadoop.yarn.server.security.BaseContainerTokenSecretManager;
import org.apache.hadoop.yarn.server.security.MasterKeyData;

public class NMContainerTokenSecretManager
extends BaseContainerTokenSecretManager {
    private static final Log LOG = LogFactory.getLog(NMContainerTokenSecretManager.class);
    private MasterKeyData previousMasterKey;
    private final Map<ApplicationId, ConcurrentMap<ContainerId, MasterKeyData>> oldMasterKeys = new HashMap<ApplicationId, ConcurrentMap<ContainerId, MasterKeyData>>();
    private String nodeHostAddr;

    public NMContainerTokenSecretManager(Configuration conf) {
        super(conf);
    }

    @InterfaceAudience.Private
    public synchronized void setMasterKey(MasterKey masterKeyRecord) {
        LOG.info((Object)("Rolling master-key for container-tokens, got key with id " + masterKeyRecord.getKeyId()));
        if (this.currentMasterKey == null) {
            this.currentMasterKey = new MasterKeyData(masterKeyRecord, NMContainerTokenSecretManager.createSecretKey((byte[])masterKeyRecord.getBytes().array()));
        } else if (this.currentMasterKey.getMasterKey().getKeyId() != masterKeyRecord.getKeyId()) {
            this.previousMasterKey = this.currentMasterKey;
            this.currentMasterKey = new MasterKeyData(masterKeyRecord, NMContainerTokenSecretManager.createSecretKey((byte[])masterKeyRecord.getBytes().array()));
        }
    }

    public synchronized byte[] retrievePassword(ContainerTokenIdentifier identifier) throws SecretManager.InvalidToken {
        int keyId = identifier.getMasterKeyId();
        ContainerId containerId = identifier.getContainerID();
        ApplicationId appId = containerId.getApplicationAttemptId().getApplicationId();
        MasterKeyData masterKeyToUse = null;
        if (this.previousMasterKey != null && keyId == this.previousMasterKey.getMasterKey().getKeyId()) {
            masterKeyToUse = this.previousMasterKey;
        } else if (keyId == this.currentMasterKey.getMasterKey().getKeyId()) {
            masterKeyToUse = this.currentMasterKey;
        } else if (this.oldMasterKeys.containsKey(appId) && this.oldMasterKeys.get(appId).containsKey(containerId)) {
            masterKeyToUse = (MasterKeyData)this.oldMasterKeys.get(appId).get(containerId);
        }
        if (this.nodeHostAddr != null && !identifier.getNmHostAddress().equals(this.nodeHostAddr)) {
            throw new SecretManager.InvalidToken("Given Container " + identifier.getContainerID().toString() + " identifier is not valid for current Node manager. Expected : " + this.nodeHostAddr + " Found : " + identifier.getNmHostAddress());
        }
        if (masterKeyToUse != null) {
            return this.retrievePasswordInternal(identifier, masterKeyToUse);
        }
        throw new SecretManager.InvalidToken("Given Container " + identifier.getContainerID().toString() + " seems to have an illegally generated token.");
    }

    public synchronized void startContainerSuccessful(ContainerTokenIdentifier tokenId) {
        int keyId = tokenId.getMasterKeyId();
        if (this.currentMasterKey.getMasterKey().getKeyId() == keyId) {
            this.addKeyForContainerId(tokenId.getContainerID(), this.currentMasterKey);
        } else if (this.previousMasterKey != null && this.previousMasterKey.getMasterKey().getKeyId() == keyId) {
            this.addKeyForContainerId(tokenId.getContainerID(), this.previousMasterKey);
        }
    }

    public synchronized boolean isValidStartContainerRequest(ContainerId containerID) {
        ApplicationId applicationId = containerID.getApplicationAttemptId().getApplicationId();
        return !this.oldMasterKeys.containsKey(applicationId) || !this.oldMasterKeys.get(applicationId).containsKey(containerID);
    }

    private synchronized void addKeyForContainerId(ContainerId containerId, MasterKeyData masterKeyData) {
        if (containerId != null) {
            ApplicationId appId = containerId.getApplicationAttemptId().getApplicationId();
            if (!this.oldMasterKeys.containsKey(appId)) {
                this.oldMasterKeys.put(appId, new ConcurrentHashMap());
            }
            ConcurrentMap<ContainerId, MasterKeyData> containerIdToKeysMapForThisApp = this.oldMasterKeys.get(appId);
            containerIdToKeysMapForThisApp.put(containerId, masterKeyData);
        } else {
            LOG.warn((Object)"Not adding key for null containerId");
        }
    }

    public synchronized void appFinished(ApplicationId appId) {
        this.oldMasterKeys.remove(appId);
    }

    public synchronized void setNodeId(NodeId nodeId) {
        this.nodeHostAddr = nodeId.toString();
        LOG.info((Object)("Updating node address : " + this.nodeHostAddr));
    }
}

