/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.apache.hadoop.yarn.api.ClientRMProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.GetAllApplicationsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetAllApplicationsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterMetricsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterMetricsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetQueueInfoRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetQueueInfoResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetQueueUserAclsInfoRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetQueueUserAclsInfoResponse;
import org.apache.hadoop.yarn.api.protocolrecords.KillApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.KillApplicationResponse;
import org.apache.hadoop.yarn.api.protocolrecords.SubmitApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.SubmitApplicationResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.NodeReport;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.YarnClusterMetrics;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.exceptions.YarnRemoteException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.ipc.RPCUtil;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.server.resourcemanager.RMAppManager;
import org.apache.hadoop.yarn.server.resourcemanager.RMAppManagerSubmitEvent;
import org.apache.hadoop.yarn.server.resourcemanager.RMAuditLogger;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.resource.Resources;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNodeReport;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.YarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.security.authorize.RMPolicyProvider;
import org.apache.hadoop.yarn.server.security.ApplicationACLsManager;
import org.apache.hadoop.yarn.service.AbstractService;
import org.apache.hadoop.yarn.util.BuilderUtils;

public class ClientRMService
extends AbstractService
implements ClientRMProtocol {
    private static final ArrayList<ApplicationReport> EMPTY_APPS_REPORT = new ArrayList();
    private static final Log LOG = LogFactory.getLog(ClientRMService.class);
    private final AtomicInteger applicationCounter = new AtomicInteger(0);
    private final YarnScheduler scheduler;
    private final RMContext rmContext;
    private final RMAppManager rmAppManager;
    private String clientServiceBindAddress;
    private Server server;
    private final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    InetSocketAddress clientBindAddress;
    private final ApplicationACLsManager applicationsACLsManager;

    public ClientRMService(RMContext rmContext, YarnScheduler scheduler, RMAppManager rmAppManager, ApplicationACLsManager applicationACLsManager) {
        super(ClientRMService.class.getName());
        this.scheduler = scheduler;
        this.rmContext = rmContext;
        this.rmAppManager = rmAppManager;
        this.applicationsACLsManager = applicationACLsManager;
    }

    public void init(Configuration conf) {
        this.clientServiceBindAddress = conf.get("yarn.resourcemanager.address", "0.0.0.0:8040");
        this.clientBindAddress = NetUtils.createSocketAddr((String)this.clientServiceBindAddress, (int)8040, (String)"yarn.resourcemanager.address");
        super.init(conf);
    }

    public void start() {
        Configuration conf = this.getConfig();
        YarnRPC rpc = YarnRPC.create((Configuration)conf);
        this.server = rpc.getServer(ClientRMProtocol.class, (Object)this, this.clientBindAddress, conf, null, conf.getInt("yarn.resourcemanager.client.thread-count", 10));
        if (conf.getBoolean("hadoop.security.authorization", false)) {
            this.refreshServiceAcls(conf, new RMPolicyProvider());
        }
        this.server.start();
        super.start();
    }

    private boolean checkAccess(UserGroupInformation callerUGI, String owner, ApplicationAccessType operationPerformed, ApplicationId applicationId) {
        return this.applicationsACLsManager.checkAccess(callerUGI, operationPerformed, owner, applicationId);
    }

    ApplicationId getNewApplicationId() {
        ApplicationId applicationId = BuilderUtils.newApplicationId((RecordFactory)this.recordFactory, (long)ResourceManager.clusterTimeStamp, (int)this.applicationCounter.incrementAndGet());
        LOG.info((Object)("Allocated new applicationId: " + applicationId.getId()));
        return applicationId;
    }

    public GetNewApplicationResponse getNewApplication(GetNewApplicationRequest request) throws YarnRemoteException {
        GetNewApplicationResponse response = (GetNewApplicationResponse)this.recordFactory.newRecordInstance(GetNewApplicationResponse.class);
        response.setApplicationId(this.getNewApplicationId());
        response.setMinimumResourceCapability(this.scheduler.getMinimumResourceCapability());
        response.setMaximumResourceCapability(this.scheduler.getMaximumResourceCapability());
        return response;
    }

    public GetApplicationReportResponse getApplicationReport(GetApplicationReportRequest request) throws YarnRemoteException {
        UserGroupInformation callerUGI;
        ApplicationId applicationId = request.getApplicationId();
        try {
            callerUGI = UserGroupInformation.getCurrentUser();
        }
        catch (IOException ie) {
            LOG.info((Object)"Error getting UGI ", (Throwable)ie);
            throw RPCUtil.getRemoteException((Throwable)ie);
        }
        RMApp application = (RMApp)this.rmContext.getRMApps().get(applicationId);
        if (application == null) {
            throw RPCUtil.getRemoteException((String)("Trying to get information for an absent application " + applicationId));
        }
        if (!this.checkAccess(callerUGI, application.getUser(), ApplicationAccessType.VIEW_APP, applicationId)) {
            throw RPCUtil.getRemoteException((Throwable)new AccessControlException("User " + callerUGI.getShortUserName() + " cannot perform operation " + ApplicationAccessType.VIEW_APP.name() + " on " + applicationId));
        }
        ApplicationReport report = application.createAndGetApplicationReport();
        GetApplicationReportResponse response = (GetApplicationReportResponse)this.recordFactory.newRecordInstance(GetApplicationReportResponse.class);
        response.setApplicationReport(report);
        return response;
    }

    public SubmitApplicationResponse submitApplication(SubmitApplicationRequest request) throws YarnRemoteException {
        ApplicationSubmissionContext submissionContext = request.getApplicationSubmissionContext();
        ApplicationId applicationId = submissionContext.getApplicationId();
        String user = submissionContext.getUser();
        try {
            user = UserGroupInformation.getCurrentUser().getShortUserName();
            if (this.rmContext.getRMApps().get(applicationId) != null) {
                throw new IOException("Application with id " + applicationId + " is already present! Cannot add a duplicate!");
            }
            submissionContext.setUser(user);
            this.rmAppManager.handle(new RMAppManagerSubmitEvent(submissionContext, System.currentTimeMillis()));
            LOG.info((Object)("Application with id " + applicationId.getId() + " submitted by user " + user + " with " + submissionContext));
            RMAuditLogger.logSuccess(user, "Submit Application Request", "ClientRMService", applicationId);
        }
        catch (IOException ie) {
            LOG.info((Object)"Exception in submitting application", (Throwable)ie);
            RMAuditLogger.logFailure(user, "Submit Application Request", ie.getMessage(), "ClientRMService", "Exception in submitting application", applicationId);
            throw RPCUtil.getRemoteException((Throwable)ie);
        }
        SubmitApplicationResponse response = (SubmitApplicationResponse)this.recordFactory.newRecordInstance(SubmitApplicationResponse.class);
        return response;
    }

    public KillApplicationResponse forceKillApplication(KillApplicationRequest request) throws YarnRemoteException {
        UserGroupInformation callerUGI;
        ApplicationId applicationId = request.getApplicationId();
        try {
            callerUGI = UserGroupInformation.getCurrentUser();
        }
        catch (IOException ie) {
            LOG.info((Object)"Error getting UGI ", (Throwable)ie);
            RMAuditLogger.logFailure("UNKNOWN", "Kill Application Request", "UNKNOWN", "ClientRMService", "Error getting UGI", applicationId);
            throw RPCUtil.getRemoteException((Throwable)ie);
        }
        RMApp application = (RMApp)this.rmContext.getRMApps().get(applicationId);
        if (application == null) {
            RMAuditLogger.logFailure(callerUGI.getUserName(), "Kill Application Request", "UNKNOWN", "ClientRMService", "Trying to kill an absent application", applicationId);
            throw RPCUtil.getRemoteException((String)("Trying to kill an absent application " + applicationId));
        }
        if (!this.checkAccess(callerUGI, application.getUser(), ApplicationAccessType.MODIFY_APP, applicationId)) {
            RMAuditLogger.logFailure(callerUGI.getShortUserName(), "Kill Application Request", "User doesn't have permissions to " + ApplicationAccessType.MODIFY_APP.toString(), "ClientRMService", "Unauthorized user", applicationId);
            throw RPCUtil.getRemoteException((Throwable)new AccessControlException("User " + callerUGI.getShortUserName() + " cannot perform operation " + ApplicationAccessType.MODIFY_APP.name() + " on " + applicationId));
        }
        this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppEvent(applicationId, RMAppEventType.KILL));
        RMAuditLogger.logSuccess(callerUGI.getShortUserName(), "Kill Application Request", "ClientRMService", applicationId);
        KillApplicationResponse response = (KillApplicationResponse)this.recordFactory.newRecordInstance(KillApplicationResponse.class);
        return response;
    }

    public GetClusterMetricsResponse getClusterMetrics(GetClusterMetricsRequest request) throws YarnRemoteException {
        GetClusterMetricsResponse response = (GetClusterMetricsResponse)this.recordFactory.newRecordInstance(GetClusterMetricsResponse.class);
        YarnClusterMetrics ymetrics = (YarnClusterMetrics)this.recordFactory.newRecordInstance(YarnClusterMetrics.class);
        ymetrics.setNumNodeManagers(this.rmContext.getRMNodes().size());
        response.setClusterMetrics(ymetrics);
        return response;
    }

    public GetAllApplicationsResponse getAllApplications(GetAllApplicationsRequest request) throws YarnRemoteException {
        UserGroupInformation callerUGI;
        try {
            callerUGI = UserGroupInformation.getCurrentUser();
        }
        catch (IOException ie) {
            LOG.info((Object)"Error getting UGI ", (Throwable)ie);
            throw RPCUtil.getRemoteException((Throwable)ie);
        }
        ArrayList<ApplicationReport> reports = new ArrayList<ApplicationReport>();
        for (RMApp application : this.rmContext.getRMApps().values()) {
            if (!this.checkAccess(callerUGI, application.getUser(), ApplicationAccessType.VIEW_APP, application.getApplicationId())) continue;
            reports.add(application.createAndGetApplicationReport());
        }
        GetAllApplicationsResponse response = (GetAllApplicationsResponse)this.recordFactory.newRecordInstance(GetAllApplicationsResponse.class);
        response.setApplicationList(reports);
        return response;
    }

    public GetClusterNodesResponse getClusterNodes(GetClusterNodesRequest request) throws YarnRemoteException {
        GetClusterNodesResponse response = (GetClusterNodesResponse)this.recordFactory.newRecordInstance(GetClusterNodesResponse.class);
        Collection nodes = this.rmContext.getRMNodes().values();
        ArrayList<NodeReport> nodeReports = new ArrayList<NodeReport>(nodes.size());
        for (RMNode nodeInfo : nodes) {
            nodeReports.add(this.createNodeReports(nodeInfo));
        }
        response.setNodeReports(nodeReports);
        return response;
    }

    public GetQueueInfoResponse getQueueInfo(GetQueueInfoRequest request) throws YarnRemoteException {
        GetQueueInfoResponse response = (GetQueueInfoResponse)this.recordFactory.newRecordInstance(GetQueueInfoResponse.class);
        try {
            QueueInfo queueInfo = this.scheduler.getQueueInfo(request.getQueueName(), request.getIncludeChildQueues(), request.getRecursive());
            ArrayList<Object> appReports = EMPTY_APPS_REPORT;
            if (request.getIncludeApplications()) {
                Collection apps = this.rmContext.getRMApps().values();
                appReports = new ArrayList(apps.size());
                for (RMApp app : apps) {
                    appReports.add(app.createAndGetApplicationReport());
                }
            }
            queueInfo.setApplications(appReports);
            response.setQueueInfo(queueInfo);
        }
        catch (IOException ioe) {
            LOG.info((Object)("Failed to getQueueInfo for " + request.getQueueName()), (Throwable)ioe);
            throw RPCUtil.getRemoteException((Throwable)ioe);
        }
        return response;
    }

    private NodeReport createNodeReports(RMNode rmNode) {
        NodeReport report = (NodeReport)this.recordFactory.newRecordInstance(NodeReport.class);
        report.setNodeId(rmNode.getNodeID());
        report.setRackName(rmNode.getRackName());
        report.setCapability(rmNode.getTotalCapability());
        report.setNodeHealthStatus(rmNode.getNodeHealthStatus());
        SchedulerNodeReport schedulerNodeReport = this.scheduler.getNodeReport(rmNode.getNodeID());
        Resource used = Resources.none();
        int numContainers = 0;
        if (schedulerNodeReport != null) {
            used = schedulerNodeReport.getUsedResource();
            numContainers = schedulerNodeReport.getNumContainers();
        }
        report.setUsed(used);
        report.setNumContainers(numContainers);
        return report;
    }

    public GetQueueUserAclsInfoResponse getQueueUserAcls(GetQueueUserAclsInfoRequest request) throws YarnRemoteException {
        GetQueueUserAclsInfoResponse response = (GetQueueUserAclsInfoResponse)this.recordFactory.newRecordInstance(GetQueueUserAclsInfoResponse.class);
        response.setUserAclsInfoList(this.scheduler.getQueueUserAclInfo());
        return response;
    }

    void refreshServiceAcls(Configuration configuration, PolicyProvider policyProvider) {
        this.server.refreshServiceAcl(configuration, policyProvider);
    }

    public void stop() {
        if (this.server != null) {
            this.server.stop();
        }
        super.stop();
    }
}

