/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.YarnException;
import org.apache.hadoop.yarn.api.ClientRMProtocol;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.AsyncDispatcher;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.security.ApplicationTokenSecretManager;
import org.apache.hadoop.yarn.security.client.ClientToAMSecretManager;
import org.apache.hadoop.yarn.server.resourcemanager.AdminService;
import org.apache.hadoop.yarn.server.resourcemanager.ApplicationMasterService;
import org.apache.hadoop.yarn.server.resourcemanager.ClientRMService;
import org.apache.hadoop.yarn.server.resourcemanager.NMLivelinessMonitor;
import org.apache.hadoop.yarn.server.resourcemanager.NodesListManager;
import org.apache.hadoop.yarn.server.resourcemanager.RMAppManager;
import org.apache.hadoop.yarn.server.resourcemanager.RMAppManagerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMContextImpl;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceTrackerService;
import org.apache.hadoop.yarn.server.resourcemanager.amlauncher.AMLauncherEventType;
import org.apache.hadoop.yarn.server.resourcemanager.amlauncher.ApplicationMasterLauncher;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.Recoverable;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.Store;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.StoreFactory;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.AMLivelinessMonitor;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.ContainerAllocationExpirer;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeEventType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fifo.FifoScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.security.DelegationTokenRenewer;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RMWebApp;
import org.apache.hadoop.yarn.server.security.ApplicationACLsManager;
import org.apache.hadoop.yarn.server.security.ContainerTokenSecretManager;
import org.apache.hadoop.yarn.server.webproxy.AppReportFetcher;
import org.apache.hadoop.yarn.server.webproxy.WebAppProxyServlet;
import org.apache.hadoop.yarn.service.AbstractService;
import org.apache.hadoop.yarn.service.CompositeService;
import org.apache.hadoop.yarn.service.Service;
import org.apache.hadoop.yarn.webapp.WebApp;
import org.apache.hadoop.yarn.webapp.WebApps;

public class ResourceManager
extends CompositeService
implements Recoverable {
    private static final Log LOG = LogFactory.getLog(ResourceManager.class);
    public static final long clusterTimeStamp = System.currentTimeMillis();
    protected ClientToAMSecretManager clientToAMSecretManager = new ClientToAMSecretManager();
    protected ContainerTokenSecretManager containerTokenSecretManager = new ContainerTokenSecretManager();
    protected ApplicationTokenSecretManager appTokenSecretManager = new ApplicationTokenSecretManager();
    private Dispatcher rmDispatcher;
    protected ResourceScheduler scheduler;
    private ClientRMService clientRM;
    protected ApplicationMasterService masterService;
    private ApplicationMasterLauncher applicationMasterLauncher;
    private AdminService adminService;
    private ContainerAllocationExpirer containerAllocationExpirer;
    protected NMLivelinessMonitor nmLivelinessMonitor;
    protected NodesListManager nodesListManager;
    private EventHandler<SchedulerEvent> schedulerDispatcher;
    protected RMAppManager rmAppManager;
    protected ApplicationACLsManager applicationACLsManager;
    private WebApp webApp;
    private RMContext rmContext;
    private final Store store;
    protected ResourceTrackerService resourceTracker;
    private Configuration conf;

    public ResourceManager(Store store) {
        super("ResourceManager");
        this.store = store;
        this.nodesListManager = new NodesListManager();
    }

    public RMContext getRMContext() {
        return this.rmContext;
    }

    public synchronized void init(Configuration conf) {
        this.conf = conf;
        this.rmDispatcher = this.createDispatcher();
        this.addIfService(this.rmDispatcher);
        this.containerAllocationExpirer = new ContainerAllocationExpirer(this.rmDispatcher);
        this.addService((Service)this.containerAllocationExpirer);
        AMLivelinessMonitor amLivelinessMonitor = this.createAMLivelinessMonitor();
        this.addService((Service)amLivelinessMonitor);
        DelegationTokenRenewer tokenRenewer = this.createDelegationTokenRenewer();
        this.addService((Service)tokenRenewer);
        this.rmContext = new RMContextImpl(this.store, this.rmDispatcher, this.containerAllocationExpirer, amLivelinessMonitor, tokenRenewer);
        this.addService((Service)this.nodesListManager);
        this.scheduler = this.createScheduler();
        this.schedulerDispatcher = this.createSchedulerEventDispatcher();
        this.addIfService(this.schedulerDispatcher);
        this.rmDispatcher.register(SchedulerEventType.class, this.schedulerDispatcher);
        this.rmDispatcher.register(RMAppEventType.class, (EventHandler)new ApplicationEventDispatcher(this.rmContext));
        this.rmDispatcher.register(RMAppAttemptEventType.class, (EventHandler)new ApplicationAttemptEventDispatcher(this.rmContext));
        this.rmDispatcher.register(RMNodeEventType.class, (EventHandler)new NodeEventDispatcher(this.rmContext));
        this.appTokenSecretManager.setMasterKey(ApplicationTokenSecretManager.createSecretKey((byte[])"Dummy".getBytes()));
        this.nmLivelinessMonitor = this.createNMLivelinessMonitor();
        this.addService((Service)this.nmLivelinessMonitor);
        this.resourceTracker = this.createResourceTrackerService();
        this.addService((Service)this.resourceTracker);
        try {
            this.scheduler.reinitialize(conf, this.containerTokenSecretManager, this.rmContext);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Failed to initialize scheduler", ioe);
        }
        this.masterService = this.createApplicationMasterService();
        this.addService((Service)this.masterService);
        this.applicationACLsManager = new ApplicationACLsManager(conf);
        this.rmAppManager = this.createRMAppManager();
        this.rmDispatcher.register(RMAppManagerEventType.class, (EventHandler)this.rmAppManager);
        this.clientRM = this.createClientRMService();
        this.addService((Service)this.clientRM);
        this.adminService = this.createAdminService(this.clientRM, this.masterService, this.resourceTracker);
        this.addService((Service)this.adminService);
        this.applicationMasterLauncher = this.createAMLauncher();
        this.rmDispatcher.register(AMLauncherEventType.class, (EventHandler)this.applicationMasterLauncher);
        this.addService((Service)this.applicationMasterLauncher);
        super.init(conf);
    }

    protected EventHandler<SchedulerEvent> createSchedulerEventDispatcher() {
        return new SchedulerEventDispatcher(this.scheduler);
    }

    protected Dispatcher createDispatcher() {
        return new AsyncDispatcher();
    }

    protected void addIfService(Object object) {
        if (object instanceof Service) {
            this.addService((Service)object);
        }
    }

    protected ResourceScheduler createScheduler() {
        return (ResourceScheduler)ReflectionUtils.newInstance((Class)this.conf.getClass("yarn.resourcemanager.scheduler.class", FifoScheduler.class, ResourceScheduler.class), (Configuration)this.conf);
    }

    protected ApplicationMasterLauncher createAMLauncher() {
        return new ApplicationMasterLauncher(this.appTokenSecretManager, this.clientToAMSecretManager, this.rmContext);
    }

    private NMLivelinessMonitor createNMLivelinessMonitor() {
        return new NMLivelinessMonitor(this.rmContext.getDispatcher());
    }

    protected AMLivelinessMonitor createAMLivelinessMonitor() {
        return new AMLivelinessMonitor(this.rmDispatcher);
    }

    protected DelegationTokenRenewer createDelegationTokenRenewer() {
        return new DelegationTokenRenewer();
    }

    protected RMAppManager createRMAppManager() {
        return new RMAppManager(this.rmContext, this.clientToAMSecretManager, this.scheduler, this.masterService, this.applicationACLsManager, this.conf);
    }

    protected void startWepApp() {
        WebApps.Builder builder = WebApps.$for((String)"cluster", (Object)((Object)this.masterService)).at(this.conf.get("yarn.resourcemanager.webapp.address", "0.0.0.0:8088"));
        if (YarnConfiguration.getRMWebAppHostAndPort((Configuration)this.conf).equals(YarnConfiguration.getProxyHostAndPort((Configuration)this.conf))) {
            AppReportFetcher fetcher = new AppReportFetcher(this.conf, (ClientRMProtocol)this.getClientRMService());
            builder.withServlet("proxy", "/proxy/*", WebAppProxyServlet.class);
            builder.withAttribute("AppUrlFetcher", (Object)fetcher);
        }
        this.webApp = builder.start((WebApp)new RMWebApp(this));
    }

    public void start() {
        try {
            this.doSecureLogin();
        }
        catch (IOException ie) {
            throw new YarnException("Failed to login", (Throwable)ie);
        }
        this.startWepApp();
        DefaultMetricsSystem.initialize((String)"ResourceManager");
        super.start();
    }

    protected void doSecureLogin() throws IOException {
        SecurityUtil.login((Configuration)this.conf, (String)"yarn.resourcemanager.keytab", (String)"yarn.resourcemanager.principal");
    }

    public void stop() {
        if (this.webApp != null) {
            this.webApp.stop();
        }
        DefaultMetricsSystem.shutdown();
        super.stop();
    }

    protected ResourceTrackerService createResourceTrackerService() {
        return new ResourceTrackerService(this.rmContext, this.nodesListManager, this.nmLivelinessMonitor, this.containerTokenSecretManager);
    }

    protected ClientRMService createClientRMService() {
        return new ClientRMService(this.rmContext, this.scheduler, this.rmAppManager, this.applicationACLsManager);
    }

    protected ApplicationMasterService createApplicationMasterService() {
        return new ApplicationMasterService(this.rmContext, this.appTokenSecretManager, this.scheduler);
    }

    protected AdminService createAdminService(ClientRMService clientRMService, ApplicationMasterService applicationMasterService, ResourceTrackerService resourceTrackerService) {
        return new AdminService(this.conf, this.scheduler, this.rmContext, this.nodesListManager, clientRMService, applicationMasterService, resourceTrackerService);
    }

    @InterfaceAudience.Private
    public ClientRMService getClientRMService() {
        return this.clientRM;
    }

    @InterfaceAudience.Private
    public ResourceScheduler getResourceScheduler() {
        return this.scheduler;
    }

    @InterfaceAudience.Private
    public ResourceTrackerService getResourceTrackerService() {
        return this.resourceTracker;
    }

    @InterfaceAudience.Private
    public ApplicationMasterService getApplicationMasterService() {
        return this.masterService;
    }

    @InterfaceAudience.Private
    public ApplicationACLsManager getApplicationACLsManager() {
        return this.applicationACLsManager;
    }

    @Override
    public void recover(Store.RMState state) throws Exception {
        this.resourceTracker.recover(state);
        this.scheduler.recover(state);
    }

    public static void main(String[] argv) {
        StringUtils.startupShutdownMessage(ResourceManager.class, (String[])argv, (Log)LOG);
        try {
            YarnConfiguration conf = new YarnConfiguration();
            Store store = StoreFactory.getStore((Configuration)conf);
            ResourceManager resourceManager = new ResourceManager(store);
            Runtime.getRuntime().addShutdownHook((Thread)new CompositeService.CompositeServiceShutdownHook((CompositeService)resourceManager));
            resourceManager.init((Configuration)conf);
            resourceManager.start();
        }
        catch (Throwable t) {
            LOG.fatal((Object)"Error starting ResourceManager", t);
            System.exit(-1);
        }
    }

    @InterfaceAudience.Private
    public static final class NodeEventDispatcher
    implements EventHandler<RMNodeEvent> {
        private final RMContext rmContext;

        public NodeEventDispatcher(RMContext rmContext) {
            this.rmContext = rmContext;
        }

        public void handle(RMNodeEvent event) {
            NodeId nodeId = event.getNodeId();
            RMNode node = (RMNode)this.rmContext.getRMNodes().get(nodeId);
            if (node != null) {
                try {
                    ((EventHandler)node).handle((Event)event);
                }
                catch (Throwable t) {
                    LOG.error((Object)("Error in handling event type " + event.getType() + " for node " + nodeId), t);
                }
            }
        }
    }

    @InterfaceAudience.Private
    public static final class ApplicationAttemptEventDispatcher
    implements EventHandler<RMAppAttemptEvent> {
        private final RMContext rmContext;

        public ApplicationAttemptEventDispatcher(RMContext rmContext) {
            this.rmContext = rmContext;
        }

        public void handle(RMAppAttemptEvent event) {
            RMAppAttempt rmAppAttempt;
            ApplicationAttemptId appAttemptID = event.getApplicationAttemptId();
            ApplicationId appAttemptId = appAttemptID.getApplicationId();
            RMApp rmApp = (RMApp)this.rmContext.getRMApps().get(appAttemptId);
            if (rmApp != null && (rmAppAttempt = rmApp.getRMAppAttempt(appAttemptID)) != null) {
                try {
                    rmAppAttempt.handle((Event)event);
                }
                catch (Throwable t) {
                    LOG.error((Object)("Error in handling event type " + event.getType() + " for applicationAttempt " + appAttemptId), t);
                }
            }
        }
    }

    @InterfaceAudience.Private
    public static final class ApplicationEventDispatcher
    implements EventHandler<RMAppEvent> {
        private final RMContext rmContext;

        public ApplicationEventDispatcher(RMContext rmContext) {
            this.rmContext = rmContext;
        }

        public void handle(RMAppEvent event) {
            ApplicationId appID = event.getApplicationId();
            RMApp rmApp = (RMApp)this.rmContext.getRMApps().get(appID);
            if (rmApp != null) {
                try {
                    rmApp.handle((Event)event);
                }
                catch (Throwable t) {
                    LOG.error((Object)("Error in handling event type " + event.getType() + " for application " + appID), t);
                }
            }
        }
    }

    @InterfaceAudience.Private
    public static final class SchedulerEventDispatcher
    extends AbstractService
    implements EventHandler<SchedulerEvent> {
        private final ResourceScheduler scheduler;
        private final BlockingQueue<SchedulerEvent> eventQueue = new LinkedBlockingQueue<SchedulerEvent>();
        private final Thread eventProcessor;

        public SchedulerEventDispatcher(ResourceScheduler scheduler) {
            super(SchedulerEventDispatcher.class.getName());
            this.scheduler = scheduler;
            this.eventProcessor = new Thread(new EventProcessor());
            this.eventProcessor.setName("ResourceManager Event Processor");
        }

        public synchronized void start() {
            this.eventProcessor.start();
            super.start();
        }

        public synchronized void stop() {
            this.eventProcessor.interrupt();
            try {
                this.eventProcessor.join();
            }
            catch (InterruptedException e) {
                throw new YarnException((Throwable)e);
            }
            super.stop();
        }

        public void handle(SchedulerEvent event) {
            try {
                int remCapacity;
                int qSize = this.eventQueue.size();
                if (qSize != 0 && qSize % 1000 == 0) {
                    LOG.info((Object)("Size of scheduler event-queue is " + qSize));
                }
                if ((remCapacity = this.eventQueue.remainingCapacity()) < 1000) {
                    LOG.info((Object)("Very low remaining capacity on scheduler event queue: " + remCapacity));
                }
                this.eventQueue.put(event);
            }
            catch (InterruptedException e) {
                throw new YarnException((Throwable)e);
            }
        }

        private final class EventProcessor
        implements Runnable {
            private EventProcessor() {
            }

            @Override
            public void run() {
                while (!Thread.currentThread().isInterrupted()) {
                    SchedulerEvent event;
                    try {
                        event = (SchedulerEvent)((Object)SchedulerEventDispatcher.this.eventQueue.take());
                    }
                    catch (InterruptedException e) {
                        LOG.error((Object)("Returning, interrupted : " + e));
                        return;
                    }
                    try {
                        SchedulerEventDispatcher.this.scheduler.handle((Event)event);
                    }
                    catch (Throwable t) {
                        LOG.error((Object)("Error in handling event type " + event.getType() + " to the scheduler"), t);
                        return;
                    }
                }
            }
        }
    }
}

