/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.amlauncher;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.security.ApplicationTokenSecretManager;
import org.apache.hadoop.yarn.security.client.ClientToAMSecretManager;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.amlauncher.AMLauncher;
import org.apache.hadoop.yarn.server.resourcemanager.amlauncher.AMLauncherEvent;
import org.apache.hadoop.yarn.server.resourcemanager.amlauncher.AMLauncherEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.service.AbstractService;

public class ApplicationMasterLauncher
extends AbstractService
implements EventHandler<AMLauncherEvent> {
    private static final Log LOG = LogFactory.getLog(ApplicationMasterLauncher.class);
    private final ThreadPoolExecutor launcherPool;
    private LauncherThread launcherHandlingThread;
    private final BlockingQueue<Runnable> masterEvents = new LinkedBlockingQueue<Runnable>();
    protected ApplicationTokenSecretManager applicationTokenSecretManager;
    private ClientToAMSecretManager clientToAMSecretManager;
    protected final RMContext context;

    public ApplicationMasterLauncher(ApplicationTokenSecretManager applicationTokenSecretManager, ClientToAMSecretManager clientToAMSecretManager, RMContext context) {
        super(ApplicationMasterLauncher.class.getName());
        this.context = context;
        this.launcherPool = new ThreadPoolExecutor(1, 10, 1L, TimeUnit.HOURS, new LinkedBlockingQueue<Runnable>());
        this.launcherHandlingThread = new LauncherThread();
        this.applicationTokenSecretManager = applicationTokenSecretManager;
        this.clientToAMSecretManager = clientToAMSecretManager;
    }

    public void start() {
        this.launcherHandlingThread.start();
        super.start();
    }

    protected Runnable createRunnableLauncher(RMAppAttempt application, AMLauncherEventType event) {
        AMLauncher launcher = new AMLauncher(this.context, application, event, this.applicationTokenSecretManager, this.clientToAMSecretManager, this.getConfig());
        return launcher;
    }

    private void launch(RMAppAttempt application) {
        Runnable launcher = this.createRunnableLauncher(application, AMLauncherEventType.LAUNCH);
        this.masterEvents.add(launcher);
    }

    public void stop() {
        this.launcherHandlingThread.interrupt();
        try {
            this.launcherHandlingThread.join();
        }
        catch (InterruptedException ie) {
            LOG.info((Object)(this.launcherHandlingThread.getName() + " interrupted during join "), (Throwable)ie);
        }
        this.launcherPool.shutdown();
        super.stop();
    }

    private void cleanup(RMAppAttempt application) {
        Runnable launcher = this.createRunnableLauncher(application, AMLauncherEventType.CLEANUP);
        this.masterEvents.add(launcher);
    }

    public synchronized void handle(AMLauncherEvent appEvent) {
        AMLauncherEventType event = (AMLauncherEventType)appEvent.getType();
        RMAppAttempt application = appEvent.getAppAttempt();
        switch (event) {
            case LAUNCH: {
                this.launch(application);
                break;
            }
            case CLEANUP: {
                this.cleanup(application);
            }
        }
    }

    private class LauncherThread
    extends Thread {
        public LauncherThread() {
            super("ApplicationMaster Launcher");
        }

        @Override
        public void run() {
            while (!this.isInterrupted()) {
                try {
                    Runnable toLaunch = (Runnable)ApplicationMasterLauncher.this.masterEvents.take();
                    ApplicationMasterLauncher.this.launcherPool.execute(toLaunch);
                }
                catch (InterruptedException e) {
                    LOG.warn((Object)(this.getClass().getName() + " interrupted. Returning."));
                    return;
                }
            }
        }
    }
}

