/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.rmapp;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.YarnException;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationResourceUsageReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.server.resourcemanager.ApplicationMasterService;
import org.apache.hadoop.yarn.server.resourcemanager.RMAppManagerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.RMAppManagerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.ApplicationsStore;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppFailedAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppRejectedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeCleanAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.YarnScheduler;
import org.apache.hadoop.yarn.state.InvalidStateTransitonException;
import org.apache.hadoop.yarn.state.MultipleArcTransition;
import org.apache.hadoop.yarn.state.SingleArcTransition;
import org.apache.hadoop.yarn.state.StateMachine;
import org.apache.hadoop.yarn.state.StateMachineFactory;
import org.apache.hadoop.yarn.util.BuilderUtils;
import org.apache.hadoop.yarn.util.Records;

public class RMAppImpl
implements RMApp {
    private static final Log LOG = LogFactory.getLog(RMAppImpl.class);
    private final ApplicationId applicationId;
    private final RMContext rmContext;
    private final Configuration conf;
    private final String user;
    private final String queue;
    private final String name;
    private final ApplicationSubmissionContext submissionContext;
    private final String clientTokenStr;
    private final ApplicationsStore.ApplicationStore appStore;
    private final Dispatcher dispatcher;
    private final YarnScheduler scheduler;
    private final ApplicationMasterService masterService;
    private final StringBuilder diagnostics = new StringBuilder();
    private final int maxRetries;
    private final ReentrantReadWriteLock.ReadLock readLock;
    private final ReentrantReadWriteLock.WriteLock writeLock;
    private final Map<ApplicationAttemptId, RMAppAttempt> attempts = new LinkedHashMap<ApplicationAttemptId, RMAppAttempt>();
    private final long submitTime;
    private long startTime;
    private long finishTime;
    private RMAppAttempt currentAttempt;
    private EventHandler handler;
    private static final FinalTransition FINAL_TRANSITION = new FinalTransition();
    private static final StateMachineFactory<RMAppImpl, RMAppState, RMAppEventType, RMAppEvent> stateMachineFactory = new StateMachineFactory((Enum)RMAppState.NEW).addTransition((Enum)RMAppState.NEW, (Enum)RMAppState.SUBMITTED, (Enum)RMAppEventType.START, (SingleArcTransition)new StartAppAttemptTransition()).addTransition((Enum)RMAppState.NEW, (Enum)RMAppState.KILLED, (Enum)RMAppEventType.KILL, (SingleArcTransition)new AppKilledTransition()).addTransition((Enum)RMAppState.NEW, (Enum)RMAppState.FAILED, (Enum)RMAppEventType.APP_REJECTED, (SingleArcTransition)new AppRejectedTransition()).addTransition((Enum)RMAppState.SUBMITTED, (Enum)RMAppState.FAILED, (Enum)RMAppEventType.APP_REJECTED, (SingleArcTransition)new AppRejectedTransition()).addTransition((Enum)RMAppState.SUBMITTED, (Enum)RMAppState.ACCEPTED, (Enum)RMAppEventType.APP_ACCEPTED).addTransition((Enum)RMAppState.SUBMITTED, (Enum)RMAppState.KILLED, (Enum)RMAppEventType.KILL, (SingleArcTransition)new KillAppAndAttemptTransition()).addTransition((Enum)RMAppState.ACCEPTED, (Enum)RMAppState.RUNNING, (Enum)RMAppEventType.ATTEMPT_REGISTERED).addTransition((Enum)RMAppState.ACCEPTED, EnumSet.of(RMAppState.SUBMITTED, RMAppState.FAILED), (Enum)RMAppEventType.ATTEMPT_FAILED, (MultipleArcTransition)new AttemptFailedTransition(RMAppState.SUBMITTED)).addTransition((Enum)RMAppState.ACCEPTED, (Enum)RMAppState.KILLED, (Enum)RMAppEventType.KILL, (SingleArcTransition)new KillAppAndAttemptTransition()).addTransition((Enum)RMAppState.RUNNING, (Enum)RMAppState.FINISHED, (Enum)RMAppEventType.ATTEMPT_FINISHED, (SingleArcTransition)FINAL_TRANSITION).addTransition((Enum)RMAppState.RUNNING, EnumSet.of(RMAppState.SUBMITTED, RMAppState.FAILED), (Enum)RMAppEventType.ATTEMPT_FAILED, (MultipleArcTransition)new AttemptFailedTransition(RMAppState.SUBMITTED)).addTransition((Enum)RMAppState.RUNNING, (Enum)RMAppState.KILLED, (Enum)RMAppEventType.KILL, (SingleArcTransition)new KillAppAndAttemptTransition()).addTransition((Enum)RMAppState.FINISHED, (Enum)RMAppState.FINISHED, (Enum)RMAppEventType.KILL).addTransition((Enum)RMAppState.FAILED, (Enum)RMAppState.FAILED, (Enum)RMAppEventType.KILL).addTransition((Enum)RMAppState.KILLED, (Enum)RMAppState.KILLED, EnumSet.of(RMAppEventType.APP_ACCEPTED, new RMAppEventType[]{RMAppEventType.APP_REJECTED, RMAppEventType.KILL, RMAppEventType.ATTEMPT_FINISHED, RMAppEventType.ATTEMPT_FAILED, RMAppEventType.ATTEMPT_KILLED})).installTopology();
    private final StateMachine<RMAppState, RMAppEventType, RMAppEvent> stateMachine;

    public RMAppImpl(ApplicationId applicationId, RMContext rmContext, Configuration config, String name, String user, String queue, ApplicationSubmissionContext submissionContext, String clientTokenStr, ApplicationsStore.ApplicationStore appStore, YarnScheduler scheduler, ApplicationMasterService masterService, long submitTime) {
        this.applicationId = applicationId;
        this.name = name;
        this.rmContext = rmContext;
        this.dispatcher = rmContext.getDispatcher();
        this.handler = this.dispatcher.getEventHandler();
        this.conf = config;
        this.user = user;
        this.queue = queue;
        this.submissionContext = submissionContext;
        this.clientTokenStr = clientTokenStr;
        this.appStore = appStore;
        this.scheduler = scheduler;
        this.masterService = masterService;
        this.submitTime = submitTime;
        this.startTime = System.currentTimeMillis();
        this.maxRetries = this.conf.getInt("yarn.resourcemanager.am.max-retries", 1);
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
        this.stateMachine = stateMachineFactory.make((Object)this);
    }

    @Override
    public ApplicationId getApplicationId() {
        return this.applicationId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FinalApplicationStatus getFinalApplicationStatus() {
        this.readLock.lock();
        try {
            if (this.currentAttempt != null && this.currentAttempt.getFinalApplicationStatus() != null) {
                FinalApplicationStatus finalApplicationStatus = this.currentAttempt.getFinalApplicationStatus();
                return finalApplicationStatus;
            }
            FinalApplicationStatus finalApplicationStatus = this.createFinalApplicationStatus((RMAppState)this.stateMachine.getCurrentState());
            return finalApplicationStatus;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RMAppState getState() {
        this.readLock.lock();
        try {
            RMAppState rMAppState = (RMAppState)this.stateMachine.getCurrentState();
            return rMAppState;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public String getUser() {
        return this.user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getProgress() {
        this.readLock.lock();
        try {
            if (this.currentAttempt != null) {
                float f = this.currentAttempt.getProgress();
                return f;
            }
            float f = 0.0f;
            return f;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RMAppAttempt getRMAppAttempt(ApplicationAttemptId appAttemptId) {
        this.readLock.lock();
        try {
            RMAppAttempt rMAppAttempt = this.attempts.get(appAttemptId);
            return rMAppAttempt;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public String getQueue() {
        return this.queue;
    }

    @Override
    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RMAppAttempt getCurrentAppAttempt() {
        this.readLock.lock();
        try {
            RMAppAttempt rMAppAttempt = this.currentAttempt;
            return rMAppAttempt;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public ApplicationsStore.ApplicationStore getApplicationStore() {
        return this.appStore;
    }

    private YarnApplicationState createApplicationState(RMAppState rmAppState) {
        switch (rmAppState) {
            case NEW: {
                return YarnApplicationState.NEW;
            }
            case SUBMITTED: 
            case ACCEPTED: {
                return YarnApplicationState.SUBMITTED;
            }
            case RUNNING: {
                return YarnApplicationState.RUNNING;
            }
            case FINISHED: {
                return YarnApplicationState.FINISHED;
            }
            case KILLED: {
                return YarnApplicationState.KILLED;
            }
            case FAILED: {
                return YarnApplicationState.FAILED;
            }
        }
        throw new YarnException("Unknown state passed!");
    }

    private FinalApplicationStatus createFinalApplicationStatus(RMAppState state) {
        switch (state) {
            case NEW: 
            case SUBMITTED: 
            case ACCEPTED: 
            case RUNNING: {
                return FinalApplicationStatus.UNDEFINED;
            }
            case FINISHED: 
            case FAILED: {
                return FinalApplicationStatus.FAILED;
            }
            case KILLED: {
                return FinalApplicationStatus.KILLED;
            }
        }
        throw new YarnException("Unknown state passed!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApplicationReport createAndGetApplicationReport() {
        this.readLock.lock();
        try {
            String clientToken = "N/A";
            String trackingUrl = "N/A";
            String host = "N/A";
            String origTrackingUrl = "N/A";
            int rpcPort = -1;
            ApplicationResourceUsageReport appUsageReport = null;
            FinalApplicationStatus finishState = this.getFinalApplicationStatus();
            if (this.currentAttempt != null) {
                trackingUrl = this.currentAttempt.getTrackingUrl();
                origTrackingUrl = this.currentAttempt.getOriginalTrackingUrl();
                clientToken = this.currentAttempt.getClientToken();
                host = this.currentAttempt.getHost();
                rpcPort = this.currentAttempt.getRpcPort();
                appUsageReport = this.currentAttempt.getApplicationResourceUsageReport();
            }
            ApplicationReport applicationReport = BuilderUtils.newApplicationReport((ApplicationId)this.applicationId, (String)this.user, (String)this.queue, (String)this.name, (String)host, (int)rpcPort, (String)clientToken, (YarnApplicationState)this.createApplicationState((RMAppState)this.stateMachine.getCurrentState()), (String)this.diagnostics.toString(), (String)trackingUrl, (long)this.startTime, (long)this.finishTime, (FinalApplicationStatus)finishState, (ApplicationResourceUsageReport)appUsageReport, (String)origTrackingUrl);
            return applicationReport;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getFinishTime() {
        this.readLock.lock();
        try {
            long l = this.finishTime;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getStartTime() {
        this.readLock.lock();
        try {
            long l = this.startTime;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public long getSubmitTime() {
        return this.submitTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getTrackingUrl() {
        this.readLock.lock();
        try {
            if (this.currentAttempt != null) {
                String string = this.currentAttempt.getTrackingUrl();
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StringBuilder getDiagnostics() {
        this.readLock.lock();
        try {
            StringBuilder stringBuilder = this.diagnostics;
            return stringBuilder;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(RMAppEvent event) {
        this.writeLock.lock();
        try {
            ApplicationId appID = event.getApplicationId();
            LOG.info((Object)("Processing event for " + appID + " of type " + event.getType()));
            RMAppState oldState = this.getState();
            try {
                this.stateMachine.doTransition(event.getType(), (Object)event);
            }
            catch (InvalidStateTransitonException e) {
                LOG.error((Object)"Can't handle this event at current state", (Throwable)e);
            }
            if (oldState != this.getState()) {
                LOG.info((Object)(appID + " State change from " + (Object)((Object)oldState) + " to " + (Object)((Object)this.getState())));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void createNewAttempt() {
        ApplicationAttemptId appAttemptId = (ApplicationAttemptId)Records.newRecord(ApplicationAttemptId.class);
        appAttemptId.setApplicationId(this.applicationId);
        appAttemptId.setAttemptId(this.attempts.size() + 1);
        RMAppAttemptImpl attempt = new RMAppAttemptImpl(appAttemptId, this.clientTokenStr, this.rmContext, this.scheduler, this.masterService, this.submissionContext, YarnConfiguration.getProxyHostAndPort((Configuration)this.conf));
        this.attempts.put(appAttemptId, attempt);
        this.currentAttempt = attempt;
        this.handler.handle((Event)new RMAppAttemptEvent(appAttemptId, RMAppAttemptEventType.START));
    }

    private static final class AttemptFailedTransition
    implements MultipleArcTransition<RMAppImpl, RMAppEvent, RMAppState> {
        private final RMAppState initialState;

        public AttemptFailedTransition(RMAppState initialState) {
            this.initialState = initialState;
        }

        public RMAppState transition(RMAppImpl app, RMAppEvent event) {
            RMAppFailedAttemptEvent failedEvent = (RMAppFailedAttemptEvent)event;
            if (app.attempts.size() == app.maxRetries) {
                String msg = "Application " + app.getApplicationId() + " failed " + app.maxRetries + " times due to " + failedEvent.getDiagnostics() + ". Failing the application.";
                LOG.info((Object)msg);
                app.diagnostics.append(msg);
                FINAL_TRANSITION.transition(app, event);
                return RMAppState.FAILED;
            }
            app.createNewAttempt();
            return this.initialState;
        }
    }

    private static class FinalTransition
    extends RMAppTransition {
        private FinalTransition() {
        }

        private Set<NodeId> getNodesOnWhichAttemptRan(RMAppImpl app) {
            HashSet<NodeId> nodes = new HashSet<NodeId>();
            for (RMAppAttempt attempt : app.attempts.values()) {
                nodes.addAll(attempt.getRanNodes());
            }
            return nodes;
        }

        @Override
        public void transition(RMAppImpl app, RMAppEvent event) {
            Set<NodeId> nodes = this.getNodesOnWhichAttemptRan(app);
            for (NodeId nodeId : nodes) {
                app.handler.handle((Event)new RMNodeCleanAppEvent(nodeId, app.applicationId));
            }
            app.finishTime = System.currentTimeMillis();
            app.handler.handle((Event)new RMAppManagerEvent(app.applicationId, RMAppManagerEventType.APP_COMPLETED));
        }
    }

    private static final class AppRejectedTransition
    extends FinalTransition {
        private AppRejectedTransition() {
        }

        @Override
        public void transition(RMAppImpl app, RMAppEvent event) {
            RMAppRejectedEvent rejectedEvent = (RMAppRejectedEvent)event;
            app.diagnostics.append(rejectedEvent.getMessage());
            super.transition(app, event);
        }
    }

    private static class KillAppAndAttemptTransition
    extends AppKilledTransition {
        private KillAppAndAttemptTransition() {
        }

        @Override
        public void transition(RMAppImpl app, RMAppEvent event) {
            app.handler.handle((Event)new RMAppAttemptEvent(app.currentAttempt.getAppAttemptId(), RMAppAttemptEventType.KILL));
            super.transition(app, event);
        }
    }

    private static class AppKilledTransition
    extends FinalTransition {
        private AppKilledTransition() {
        }

        @Override
        public void transition(RMAppImpl app, RMAppEvent event) {
            app.diagnostics.append("Application killed by user.");
            super.transition(app, event);
        }
    }

    private static final class StartAppAttemptTransition
    extends RMAppTransition {
        private StartAppAttemptTransition() {
        }

        @Override
        public void transition(RMAppImpl app, RMAppEvent event) {
            app.createNewAttempt();
        }
    }

    private static class RMAppTransition
    implements SingleArcTransition<RMAppImpl, RMAppEvent> {
        private RMAppTransition() {
        }

        public void transition(RMAppImpl app, RMAppEvent event) {
        }
    }
}

