/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.Clock;
import org.apache.hadoop.yarn.SystemClock;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEventType;
import org.apache.hadoop.yarn.util.AbstractLivelinessMonitor;

public class AMLivelinessMonitor
extends AbstractLivelinessMonitor<ApplicationAttemptId> {
    private EventHandler dispatcher;

    public AMLivelinessMonitor(Dispatcher d) {
        super("AMLivelinessMonitor", (Clock)new SystemClock());
        this.dispatcher = d.getEventHandler();
    }

    public void init(Configuration conf) {
        super.init(conf);
        int expireIntvl = conf.getInt("yarn.resourcemanager.am.liveness-monitor.expiry-interval-ms", 600000);
        this.setExpireInterval(expireIntvl);
        this.setMonitorInterval(expireIntvl / 3);
    }

    protected void expire(ApplicationAttemptId id) {
        this.dispatcher.handle((Event)new RMAppAttemptEvent(id, RMAppAttemptEventType.EXPIRE));
    }
}

