/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.server.resourcemanager.RMAuditLogger;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.ApplicationsStore;
import org.apache.hadoop.yarn.server.resourcemanager.resource.Resources;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerFinishedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerReservedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AppSchedulingInfo;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.NodeType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Queue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;

public class SchedulerApp {
    private static final Log LOG = LogFactory.getLog(SchedulerApp.class);
    private final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    private final AppSchedulingInfo appSchedulingInfo;
    private final Queue queue;
    private final Resource currentConsumption = (Resource)this.recordFactory.newRecordInstance(Resource.class);
    private Resource resourceLimit = (Resource)this.recordFactory.newRecordInstance(Resource.class);
    private Map<ContainerId, RMContainer> liveContainers = new HashMap<ContainerId, RMContainer>();
    private List<RMContainer> newlyAllocatedContainers = new ArrayList<RMContainer>();
    final Map<Priority, Map<NodeId, RMContainer>> reservedContainers = new HashMap<Priority, Map<NodeId, RMContainer>>();
    Map<Priority, Integer> schedulingOpportunities = new HashMap<Priority, Integer>();
    Map<Priority, Integer> reReservations = new HashMap<Priority, Integer>();
    Resource currentReservation = (Resource)this.recordFactory.newRecordInstance(Resource.class);
    private final RMContext rmContext;

    public SchedulerApp(ApplicationAttemptId applicationAttemptId, String user, Queue queue, RMContext rmContext, ApplicationsStore.ApplicationStore store) {
        this.rmContext = rmContext;
        this.appSchedulingInfo = new AppSchedulingInfo(applicationAttemptId, user, queue, store);
        this.queue = queue;
    }

    public ApplicationId getApplicationId() {
        return this.appSchedulingInfo.getApplicationId();
    }

    public ApplicationAttemptId getApplicationAttemptId() {
        return this.appSchedulingInfo.getApplicationAttemptId();
    }

    public String getUser() {
        return this.appSchedulingInfo.getUser();
    }

    public synchronized void updateResourceRequests(List<ResourceRequest> requests) {
        this.appSchedulingInfo.updateResourceRequests(requests);
    }

    public Map<String, ResourceRequest> getResourceRequests(Priority priority) {
        return this.appSchedulingInfo.getResourceRequests(priority);
    }

    public int getNewContainerId() {
        return this.appSchedulingInfo.getNewContainerId();
    }

    public Collection<Priority> getPriorities() {
        return this.appSchedulingInfo.getPriorities();
    }

    public ResourceRequest getResourceRequest(Priority priority, String nodeAddress) {
        return this.appSchedulingInfo.getResourceRequest(priority, nodeAddress);
    }

    public synchronized int getTotalRequiredResources(Priority priority) {
        return this.getResourceRequest(priority, "*").getNumContainers();
    }

    public Resource getResource(Priority priority) {
        return this.appSchedulingInfo.getResource(priority);
    }

    public boolean isPending() {
        return this.appSchedulingInfo.isPending();
    }

    public String getQueueName() {
        return this.appSchedulingInfo.getQueueName();
    }

    public synchronized Collection<RMContainer> getLiveContainers() {
        return new ArrayList<RMContainer>(this.liveContainers.values());
    }

    public synchronized void stop(RMAppAttemptState rmAppAttemptFinalState) {
        this.appSchedulingInfo.stop(rmAppAttemptFinalState);
    }

    public synchronized void containerLaunchedOnNode(ContainerId containerId) {
        RMContainer rmContainer = this.getRMContainer(containerId);
        rmContainer.handle((Event)new RMContainerEvent(containerId, RMContainerEventType.LAUNCHED));
    }

    public synchronized void containerCompleted(RMContainer rmContainer, ContainerStatus containerStatus, RMContainerEventType event) {
        Container container = rmContainer.getContainer();
        ContainerId containerId = container.getId();
        rmContainer.handle((Event)new RMContainerFinishedEvent(containerId, containerStatus, event));
        LOG.info((Object)("Completed container: " + rmContainer.getContainerId() + " in state: " + (Object)((Object)rmContainer.getState()) + " event:" + (Object)((Object)event)));
        this.liveContainers.remove(rmContainer.getContainerId());
        RMAuditLogger.logSuccess(this.getUser(), "AM Released Container", "SchedulerApp", this.getApplicationId(), containerId);
        Resource containerResource = rmContainer.getContainer().getResource();
        this.queue.getMetrics().releaseResources(this.getUser(), 1, containerResource);
        Resources.subtractFrom(this.currentConsumption, containerResource);
    }

    public synchronized RMContainer allocate(NodeType type, SchedulerNode node, Priority priority, ResourceRequest request, Container container) {
        if (this.getTotalRequiredResources(priority) <= 0) {
            return null;
        }
        RMContainerImpl rmContainer = new RMContainerImpl(container, this.getApplicationAttemptId(), node.getNodeID(), this.rmContext.getDispatcher().getEventHandler(), this.rmContext.getContainerAllocationExpirer());
        this.newlyAllocatedContainers.add(rmContainer);
        this.liveContainers.put(container.getId(), rmContainer);
        this.appSchedulingInfo.allocate(type, node, priority, request, container);
        Resources.addTo(this.currentConsumption, container.getResource());
        rmContainer.handle((Event)new RMContainerEvent(container.getId(), RMContainerEventType.START));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("allocate: applicationAttemptId=" + container.getId().getApplicationAttemptId() + " container=" + container.getId() + " host=" + container.getNodeId().getHost() + " type=" + (Object)((Object)type)));
        }
        RMAuditLogger.logSuccess(this.getUser(), "AM Allocated Container", "SchedulerApp", this.getApplicationId(), container.getId());
        return rmContainer;
    }

    public synchronized List<Container> pullNewlyAllocatedContainers() {
        ArrayList<Container> returnContainerList = new ArrayList<Container>(this.newlyAllocatedContainers.size());
        for (RMContainer rmContainer : this.newlyAllocatedContainers) {
            rmContainer.handle((Event)new RMContainerEvent(rmContainer.getContainerId(), RMContainerEventType.ACQUIRED));
            returnContainerList.add(rmContainer.getContainer());
        }
        this.newlyAllocatedContainers.clear();
        return returnContainerList;
    }

    public Resource getCurrentConsumption() {
        return this.currentConsumption;
    }

    public synchronized void showRequests() {
        if (LOG.isDebugEnabled()) {
            for (Priority priority : this.getPriorities()) {
                Map<String, ResourceRequest> requests = this.getResourceRequests(priority);
                if (requests == null) continue;
                LOG.debug((Object)("showRequests: application=" + this.getApplicationId() + " headRoom=" + this.getHeadroom() + " currentConsumption=" + this.currentConsumption.getMemory()));
                for (ResourceRequest request : requests.values()) {
                    LOG.debug((Object)("showRequests: application=" + this.getApplicationId() + " request=" + request));
                }
            }
        }
    }

    public synchronized void setAvailableResourceLimit(Resource globalLimit) {
        this.resourceLimit = globalLimit;
    }

    public synchronized RMContainer getRMContainer(ContainerId id) {
        return this.liveContainers.get(id);
    }

    public synchronized void resetSchedulingOpportunities(Priority priority) {
        this.schedulingOpportunities.put(priority, 0);
    }

    public synchronized void addSchedulingOpportunity(Priority priority) {
        Integer schedulingOpportunities = this.schedulingOpportunities.get(priority);
        if (schedulingOpportunities == null) {
            schedulingOpportunities = 0;
        }
        schedulingOpportunities = schedulingOpportunities + 1;
        this.schedulingOpportunities.put(priority, schedulingOpportunities);
    }

    public synchronized int getSchedulingOpportunities(Priority priority) {
        Integer schedulingOpportunities = this.schedulingOpportunities.get(priority);
        if (schedulingOpportunities == null) {
            schedulingOpportunities = 0;
            this.schedulingOpportunities.put(priority, schedulingOpportunities);
        }
        return schedulingOpportunities;
    }

    synchronized void resetReReservations(Priority priority) {
        this.reReservations.put(priority, 0);
    }

    synchronized void addReReservation(Priority priority) {
        Integer reReservations = this.reReservations.get(priority);
        if (reReservations == null) {
            reReservations = 0;
        }
        reReservations = reReservations + 1;
        this.reReservations.put(priority, reReservations);
    }

    public synchronized int getReReservations(Priority priority) {
        Integer reReservations = this.reReservations.get(priority);
        if (reReservations == null) {
            reReservations = 0;
            this.reReservations.put(priority, reReservations);
        }
        return reReservations;
    }

    public synchronized int getNumReservedContainers(Priority priority) {
        Map<NodeId, RMContainer> reservedContainers = this.reservedContainers.get(priority);
        return reservedContainers == null ? 0 : reservedContainers.size();
    }

    @InterfaceStability.Stable
    @InterfaceAudience.Private
    public synchronized Resource getCurrentReservation() {
        return this.currentReservation;
    }

    public synchronized RMContainer reserve(SchedulerNode node, Priority priority, RMContainer rmContainer, Container container) {
        if (rmContainer == null) {
            rmContainer = new RMContainerImpl(container, this.getApplicationAttemptId(), node.getNodeID(), this.rmContext.getDispatcher().getEventHandler(), this.rmContext.getContainerAllocationExpirer());
            Resources.addTo(this.currentReservation, container.getResource());
            this.resetReReservations(priority);
        } else {
            this.addReReservation(priority);
        }
        rmContainer.handle((Event)new RMContainerReservedEvent(container.getId(), container.getResource(), node.getNodeID(), priority));
        Map<NodeId, RMContainer> reservedContainers = this.reservedContainers.get(priority);
        if (reservedContainers == null) {
            reservedContainers = new HashMap<NodeId, RMContainer>();
            this.reservedContainers.put(priority, reservedContainers);
        }
        reservedContainers.put(node.getNodeID(), rmContainer);
        LOG.info((Object)("Application " + this.getApplicationId() + " reserved container " + rmContainer + " on node " + node + ", currently has " + reservedContainers.size() + " at priority " + priority + "; currentReservation " + this.currentReservation.getMemory()));
        return rmContainer;
    }

    public synchronized void unreserve(SchedulerNode node, Priority priority) {
        Map<NodeId, RMContainer> reservedContainers = this.reservedContainers.get(priority);
        RMContainer reservedContainer = reservedContainers.remove(node.getNodeID());
        if (reservedContainers.isEmpty()) {
            this.reservedContainers.remove(priority);
        }
        this.resetReReservations(priority);
        Resource resource = reservedContainer.getContainer().getResource();
        Resources.subtractFrom(this.currentReservation, resource);
        LOG.info((Object)("Application " + this.getApplicationId() + " unreserved " + " on node " + node + ", currently has " + reservedContainers.size() + " at priority " + priority + "; currentReservation " + this.currentReservation));
    }

    public synchronized boolean isReserved(SchedulerNode node, Priority priority) {
        Map<NodeId, RMContainer> reservedContainers = this.reservedContainers.get(priority);
        if (reservedContainers != null) {
            return reservedContainers.containsKey(node.getNodeID());
        }
        return false;
    }

    public synchronized float getLocalityWaitFactor(Priority priority, int clusterNodes) {
        int requiredResources = Math.max(this.getResourceRequests(priority).size() - 1, 0);
        return Math.min((float)requiredResources / (float)clusterNodes, 1.0f);
    }

    public synchronized List<RMContainer> getReservedContainers() {
        ArrayList<RMContainer> reservedContainers = new ArrayList<RMContainer>();
        for (Map.Entry<Priority, Map<NodeId, RMContainer>> e : this.reservedContainers.entrySet()) {
            reservedContainers.addAll(e.getValue().values());
        }
        return reservedContainers;
    }

    public synchronized Resource getHeadroom() {
        Resource limit = Resources.subtract(this.resourceLimit, this.currentConsumption);
        Resources.subtractFrom(limit, this.currentReservation);
        if (limit.getMemory() < 0) {
            limit.setMemory(0);
        }
        return limit;
    }

    public Queue getQueue() {
        return this.queue;
    }
}

