/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.QueueState;
import org.apache.hadoop.yarn.api.records.QueueUserACLInfo;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.server.resourcemanager.resource.Resources;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerContext;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class ParentQueue
implements CSQueue {
    private static final Log LOG = LogFactory.getLog(ParentQueue.class);
    private final CSQueue parent;
    private final String queueName;
    private float capacity;
    private float maximumCapacity;
    private float absoluteCapacity;
    private float absoluteMaxCapacity;
    private float usedCapacity = 0.0f;
    private float utilization = 0.0f;
    private final Set<CSQueue> childQueues;
    private final Comparator<CSQueue> queueComparator;
    private Resource usedResources = Resources.createResource(0);
    private final boolean rootQueue;
    private final Resource minimumAllocation;
    private volatile int numApplications;
    private volatile int numContainers;
    private QueueState state;
    private final QueueMetrics metrics;
    private QueueInfo queueInfo;
    private Map<QueueACL, AccessControlList> acls = new HashMap<QueueACL, AccessControlList>();
    private final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    private static float PRECISION = 0.005f;

    public ParentQueue(CapacitySchedulerContext cs, String queueName, Comparator<CSQueue> comparator, CSQueue parent, CSQueue old) {
        this.minimumAllocation = cs.getMinimumResourceCapability();
        this.parent = parent;
        this.queueName = queueName;
        this.rootQueue = parent == null;
        this.metrics = old != null ? old.getMetrics() : QueueMetrics.forQueue(this.getQueuePath(), parent, cs.getConfiguration().getEnableUserMetrics());
        int rawCapacity = cs.getConfiguration().getCapacity(this.getQueuePath());
        if (this.rootQueue && rawCapacity != 100) {
            throw new IllegalArgumentException("Illegal capacity of " + rawCapacity + " for queue " + queueName + ". Must be " + 100);
        }
        float capacity = (float)rawCapacity / 100.0f;
        float parentAbsoluteCapacity = parent == null ? 1.0f : parent.getAbsoluteCapacity();
        float absoluteCapacity = parentAbsoluteCapacity * capacity;
        float maximumCapacity = cs.getConfiguration().getMaximumCapacity(this.getQueuePath());
        float absoluteMaxCapacity = maximumCapacity == -1.0f ? 1.0E9f : parentAbsoluteCapacity * maximumCapacity / 100.0f;
        QueueState state = cs.getConfiguration().getState(this.getQueuePath());
        Map<QueueACL, AccessControlList> acls = cs.getConfiguration().getAcls(this.getQueuePath());
        this.queueInfo = (QueueInfo)this.recordFactory.newRecordInstance(QueueInfo.class);
        this.queueInfo.setQueueName(queueName);
        this.queueInfo.setChildQueues(new ArrayList());
        this.setupQueueConfigs(capacity, absoluteCapacity, maximumCapacity, absoluteMaxCapacity, state, acls);
        this.queueComparator = comparator;
        this.childQueues = new TreeSet<CSQueue>(this.queueComparator);
        LOG.info((Object)("Initialized parent-queue " + queueName + " name=" + queueName + ", fullname=" + this.getQueuePath()));
    }

    private synchronized void setupQueueConfigs(float capacity, float absoluteCapacity, float maximumCapacity, float absoluteMaxCapacity, QueueState state, Map<QueueACL, AccessControlList> acls) {
        this.capacity = capacity;
        this.absoluteCapacity = absoluteCapacity;
        this.maximumCapacity = maximumCapacity;
        this.absoluteMaxCapacity = absoluteMaxCapacity;
        this.state = state;
        this.acls = acls;
        this.queueInfo.setCapacity(capacity);
        this.queueInfo.setMaximumCapacity(maximumCapacity);
        this.queueInfo.setQueueState(state);
        StringBuilder aclsString = new StringBuilder();
        for (Map.Entry<QueueACL, AccessControlList> e : acls.entrySet()) {
            aclsString.append(e.getKey() + ":" + e.getValue().getAclString());
        }
        LOG.info((Object)(this.queueName + ", capacity=" + capacity + ", asboluteCapacity=" + absoluteCapacity + ", maxCapacity=" + maximumCapacity + ", asboluteMaxCapacity=" + absoluteMaxCapacity + ", state=" + state + ", acls=" + aclsString));
    }

    void setChildQueues(Collection<CSQueue> childQueues) {
        float childCapacities = 0.0f;
        for (CSQueue queue : childQueues) {
            childCapacities += queue.getCapacity();
        }
        float delta = Math.abs(1.0f - childCapacities);
        if (delta > PRECISION) {
            throw new IllegalArgumentException("Illegal capacity of " + childCapacities + " for children of queue " + this.queueName);
        }
        this.childQueues.clear();
        this.childQueues.addAll(childQueues);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("setChildQueues: " + this.getChildQueuesToPrint()));
        }
    }

    @Override
    public CSQueue getParent() {
        return this.parent;
    }

    @Override
    public String getQueueName() {
        return this.queueName;
    }

    @Override
    public String getQueuePath() {
        String parentPath = this.parent == null ? "" : this.parent.getQueuePath() + ".";
        return parentPath + this.getQueueName();
    }

    @Override
    public synchronized float getCapacity() {
        return this.capacity;
    }

    @Override
    public synchronized float getAbsoluteCapacity() {
        return this.absoluteCapacity;
    }

    @Override
    public float getAbsoluteMaximumCapacity() {
        return 0.0f;
    }

    @Override
    public float getMaximumCapacity() {
        return 0.0f;
    }

    @Override
    public synchronized float getUsedCapacity() {
        return this.usedCapacity;
    }

    @Override
    public synchronized Resource getUsedResources() {
        return this.usedResources;
    }

    @Override
    public synchronized float getUtilization() {
        return this.utilization;
    }

    @Override
    public synchronized List<CSQueue> getChildQueues() {
        return new ArrayList<CSQueue>(this.childQueues);
    }

    public synchronized int getNumContainers() {
        return this.numContainers;
    }

    @Override
    public synchronized int getNumApplications() {
        return this.numApplications;
    }

    @Override
    public synchronized QueueState getState() {
        return this.state;
    }

    @Override
    public synchronized Map<QueueACL, AccessControlList> getQueueAcls() {
        return new HashMap<QueueACL, AccessControlList>(this.acls);
    }

    @Override
    public synchronized QueueInfo getQueueInfo(boolean includeChildQueues, boolean recursive) {
        this.queueInfo.setCurrentCapacity(this.usedCapacity);
        ArrayList<QueueInfo> childQueuesInfo = new ArrayList<QueueInfo>();
        if (includeChildQueues) {
            for (CSQueue child : this.childQueues) {
                childQueuesInfo.add(child.getQueueInfo(recursive, recursive));
            }
        }
        this.queueInfo.setChildQueues(childQueuesInfo);
        return this.queueInfo;
    }

    private synchronized QueueUserACLInfo getUserAclInfo(UserGroupInformation user) {
        QueueUserACLInfo userAclInfo = (QueueUserACLInfo)this.recordFactory.newRecordInstance(QueueUserACLInfo.class);
        ArrayList<QueueACL> operations = new ArrayList<QueueACL>();
        for (Map.Entry<QueueACL, AccessControlList> e : this.acls.entrySet()) {
            QueueACL operation = e.getKey();
            AccessControlList acl = e.getValue();
            if (!acl.isUserAllowed(user)) continue;
            operations.add(operation);
        }
        userAclInfo.setQueueName(this.getQueueName());
        userAclInfo.setUserAcls(operations);
        return userAclInfo;
    }

    @Override
    public synchronized List<QueueUserACLInfo> getQueueUserAclInfo(UserGroupInformation user) {
        ArrayList<QueueUserACLInfo> userAcls = new ArrayList<QueueUserACLInfo>();
        userAcls.add(this.getUserAclInfo(user));
        for (CSQueue child : this.childQueues) {
            userAcls.addAll(child.getQueueUserAclInfo(user));
        }
        return userAcls;
    }

    public String toString() {
        return this.queueName + ":" + this.capacity + ":" + this.absoluteCapacity + ":" + this.getUsedCapacity() + ":" + this.getUtilization() + ":" + this.getNumApplications() + ":" + this.getNumContainers() + ":" + this.childQueues.size() + " child-queues";
    }

    @Override
    public synchronized void reinitialize(CSQueue queue, Resource clusterResource) throws IOException {
        if (!(queue instanceof ParentQueue) || !queue.getQueuePath().equals(this.getQueuePath())) {
            throw new IOException("Trying to reinitialize " + this.getQueuePath() + " from " + queue.getQueuePath());
        }
        ParentQueue parentQueue = (ParentQueue)queue;
        Map<String, CSQueue> currentChildQueues = this.getQueues(this.childQueues);
        Map<String, CSQueue> newChildQueues = this.getQueues(parentQueue.childQueues);
        for (Map.Entry<String, CSQueue> e : newChildQueues.entrySet()) {
            String newChildQueueName = e.getKey();
            CSQueue newChildQueue = e.getValue();
            CSQueue childQueue = currentChildQueues.get(newChildQueueName);
            if (childQueue != null) {
                childQueue.reinitialize(newChildQueue, clusterResource);
                LOG.info((Object)(this.getQueueName() + ": re-configured queue: " + childQueue));
                continue;
            }
            currentChildQueues.put(newChildQueueName, newChildQueue);
            LOG.info((Object)(this.getQueueName() + ": added new child queue: " + newChildQueue));
        }
        this.childQueues.clear();
        this.childQueues.addAll(currentChildQueues.values());
        this.setupQueueConfigs(parentQueue.capacity, parentQueue.absoluteCapacity, parentQueue.maximumCapacity, parentQueue.absoluteMaxCapacity, parentQueue.state, parentQueue.acls);
        this.updateResource(clusterResource);
    }

    Map<String, CSQueue> getQueues(Set<CSQueue> queues) {
        HashMap<String, CSQueue> queuesMap = new HashMap<String, CSQueue>();
        for (CSQueue queue : queues) {
            queuesMap.put(queue.getQueueName(), queue);
        }
        return queuesMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasAccess(QueueACL acl, UserGroupInformation user) {
        ParentQueue parentQueue = this;
        synchronized (parentQueue) {
            if (this.acls.get(acl).isUserAllowed(user)) {
                return true;
            }
        }
        if (this.parent != null) {
            return this.parent.hasAccess(acl, user);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void submitApplication(SchedulerApp application, String user, String queue) throws AccessControlException {
        ParentQueue parentQueue = this;
        synchronized (parentQueue) {
            if (queue.equals(this.queueName)) {
                throw new AccessControlException("Cannot submit application to non-leaf queue: " + this.queueName);
            }
            if (this.state != QueueState.RUNNING) {
                throw new AccessControlException("Queue " + this.getQueuePath() + " is STOPPED. Cannot accept submission of application: " + application.getApplicationId());
            }
            this.addApplication(application, user);
        }
        if (this.parent != null) {
            try {
                this.parent.submitApplication(application, user, queue);
            }
            catch (AccessControlException ace) {
                LOG.info((Object)("Failed to submit application to parent-queue: " + this.parent.getQueuePath()), (Throwable)ace);
                this.removeApplication(application, user);
                throw ace;
            }
        }
    }

    private synchronized void addApplication(SchedulerApp application, String user) {
        ++this.numApplications;
        LOG.info((Object)("Application added - appId: " + application.getApplicationId() + " user: " + user + " leaf-queue of parent: " + this.getQueueName() + " #applications: " + this.getNumApplications()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finishApplication(SchedulerApp application, String queue) {
        ParentQueue parentQueue = this;
        synchronized (parentQueue) {
            this.removeApplication(application, application.getUser());
        }
        if (this.parent != null) {
            this.parent.finishApplication(application, queue);
        }
    }

    public synchronized void removeApplication(SchedulerApp application, String user) {
        --this.numApplications;
        LOG.info((Object)("Application removed - appId: " + application.getApplicationId() + " user: " + user + " leaf-queue of parent: " + this.getQueueName() + " #applications: " + this.getNumApplications()));
    }

    synchronized void setUsedCapacity(float usedCapacity) {
        this.usedCapacity = usedCapacity;
    }

    synchronized void setUtilization(float utilization) {
        this.utilization = utilization;
    }

    synchronized void setMaxCapacity(float maximumCapacity) {
        this.maximumCapacity = maximumCapacity;
        float parentAbsoluteCapacity = this.rootQueue ? 100.0f : this.parent.getAbsoluteCapacity();
        this.absoluteMaxCapacity = maximumCapacity == -1.0f ? Float.MAX_VALUE : parentAbsoluteCapacity * maximumCapacity;
    }

    @Override
    public synchronized Resource assignContainers(Resource clusterResource, SchedulerNode node) {
        Resource assigned = Resources.createResource(0);
        while (this.canAssign(node)) {
            Resource assignedToChild;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Trying to assign containers to child-queue of " + this.getQueueName()));
            }
            if (!this.assignToQueue(clusterResource) || !Resources.greaterThan(assignedToChild = this.assignContainersToChildQueues(clusterResource, node), Resources.none())) break;
            this.allocateResource(clusterResource, assignedToChild);
            Resources.addTo(assigned, assignedToChild);
            LOG.info((Object)("assignedContainer queue=" + this.getQueueName() + " util=" + this.getUtilization() + " used=" + this.usedResources + " cluster=" + clusterResource));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("ParentQ=" + this.getQueueName() + " assignedSoFarInThisIteration=" + assigned + " utilization=" + this.getUtilization()));
            }
            if (this.rootQueue) continue;
            break;
        }
        return assigned;
    }

    private synchronized boolean assignToQueue(Resource clusterResource) {
        float currentCapacity = (float)this.usedResources.getMemory() / (float)clusterResource.getMemory();
        if (currentCapacity >= this.absoluteMaxCapacity) {
            LOG.info((Object)(this.getQueueName() + " used=" + this.usedResources.getMemory() + " current-capacity (" + currentCapacity + ") " + " >= max-capacity (" + this.absoluteMaxCapacity + ")"));
            return false;
        }
        return true;
    }

    private boolean canAssign(SchedulerNode node) {
        return node.getReservedContainer() == null && Resources.greaterThanOrEqual(node.getAvailableResource(), this.minimumAllocation);
    }

    synchronized Resource assignContainersToChildQueues(Resource cluster, SchedulerNode node) {
        Resource assigned = Resources.createResource(0);
        this.printChildQueues();
        Iterator<CSQueue> iter = this.childQueues.iterator();
        while (iter.hasNext()) {
            CSQueue childQueue = iter.next();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Trying to assign to queue: " + childQueue.getQueuePath() + " stats: " + childQueue));
            }
            assigned = childQueue.assignContainers(cluster, node);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Assignedto queue: " + childQueue.getQueuePath() + " stats: " + childQueue + " --> " + assigned.getMemory()));
            }
            if (!Resources.greaterThan(assigned, Resources.none())) continue;
            iter.remove();
            LOG.info((Object)("Re-sorting queues since queue: " + childQueue.getQueuePath() + " stats: " + childQueue));
            this.childQueues.add(childQueue);
            this.printChildQueues();
            break;
        }
        return assigned;
    }

    String getChildQueuesToPrint() {
        StringBuilder sb = new StringBuilder();
        for (CSQueue q : this.childQueues) {
            sb.append(q.getQueuePath() + "(" + q.getUtilization() + "), ");
        }
        return sb.toString();
    }

    void printChildQueues() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("printChildQueues - queue: " + this.getQueuePath() + " child-queues: " + this.getChildQueuesToPrint()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void completedContainer(Resource clusterResource, SchedulerApp application, SchedulerNode node, RMContainer rmContainer, ContainerStatus containerStatus, RMContainerEventType event) {
        if (application != null) {
            ParentQueue parentQueue = this;
            synchronized (parentQueue) {
                this.releaseResource(clusterResource, rmContainer.getContainer().getResource());
                LOG.info((Object)("completedContainer queue=" + this.getQueueName() + " util=" + this.getUtilization() + " used=" + this.usedResources + " cluster=" + clusterResource));
            }
            if (this.parent != null) {
                this.parent.completedContainer(clusterResource, application, node, rmContainer, null, event);
            }
        }
    }

    synchronized void allocateResource(Resource clusterResource, Resource resource) {
        Resources.addTo(this.usedResources, resource);
        this.updateResource(clusterResource);
        ++this.numContainers;
    }

    synchronized void releaseResource(Resource clusterResource, Resource resource) {
        Resources.subtractFrom(this.usedResources, resource);
        this.updateResource(clusterResource);
        --this.numContainers;
    }

    @Override
    public synchronized void updateClusterResource(Resource clusterResource) {
        for (CSQueue childQueue : this.childQueues) {
            childQueue.updateClusterResource(clusterResource);
        }
    }

    private synchronized void updateResource(Resource clusterResource) {
        float queueLimit = (float)clusterResource.getMemory() * this.absoluteCapacity;
        this.setUtilization((float)this.usedResources.getMemory() / queueLimit);
        this.setUsedCapacity((float)this.usedResources.getMemory() / ((float)clusterResource.getMemory() * this.capacity));
        Resource resourceLimit = Resources.createResource((int)queueLimit);
        this.metrics.setAvailableResourcesToQueue(Resources.subtractFrom(resourceLimit, this.usedResources));
    }

    @Override
    public QueueMetrics getMetrics() {
        return this.metrics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recoverContainer(Resource clusterResource, SchedulerApp application, Container container) {
        ParentQueue parentQueue = this;
        synchronized (parentQueue) {
            this.allocateResource(clusterResource, container.getResource());
        }
        if (this.parent != null) {
            this.parent.recoverContainer(clusterResource, application, container);
        }
    }
}

