/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fifo;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.yarn.Lock;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.ContainerToken;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.QueueState;
import org.apache.hadoop.yarn.api.records.QueueUserACLInfo;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.security.ContainerTokenIdentifier;
import org.apache.hadoop.yarn.server.resourcemanager.RMAuditLogger;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.Store;
import org.apache.hadoop.yarn.server.resourcemanager.resource.Resources;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Allocation;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.NodeType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Queue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerAppReport;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNodeReport;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.ContainerExpiredSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeUpdateSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEventType;
import org.apache.hadoop.yarn.server.security.ContainerTokenSecretManager;
import org.apache.hadoop.yarn.util.BuilderUtils;

@InterfaceAudience.LimitedPrivate(value={"yarn"})
@InterfaceStability.Evolving
public class FifoScheduler
implements ResourceScheduler {
    private static final Log LOG = LogFactory.getLog(FifoScheduler.class);
    private static final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    Configuration conf;
    private ContainerTokenSecretManager containerTokenSecretManager;
    private static final Container[] EMPTY_CONTAINER_ARRAY = new Container[0];
    private static final List<Container> EMPTY_CONTAINER_LIST = Arrays.asList(EMPTY_CONTAINER_ARRAY);
    private RMContext rmContext;
    private Map<NodeId, SchedulerNode> nodes = new ConcurrentHashMap<NodeId, SchedulerNode>();
    private static final int MINIMUM_MEMORY = 1024;
    private static final String FIFO_PREFIX = "yarn.scheduler.fifo.";
    @InterfaceAudience.Private
    public static final String MINIMUM_ALLOCATION = "yarn.scheduler.fifo.minimum-allocation-mb";
    private static final int MAXIMUM_MEMORY = 10240;
    @InterfaceAudience.Private
    public static final String MAXIMUM_ALLOCATION = "yarn.scheduler.fifo.maximum-allocation-mb";
    private boolean initialized;
    private Resource minimumAllocation;
    private Resource maximumAllocation;
    private Map<ApplicationAttemptId, SchedulerApp> applications = new TreeMap<ApplicationAttemptId, SchedulerApp>();
    private static final String DEFAULT_QUEUE_NAME = "default";
    private final QueueMetrics metrics = QueueMetrics.forQueue("default", null, false);
    private final Queue DEFAULT_QUEUE = new Queue(){

        @Override
        public String getQueueName() {
            return FifoScheduler.DEFAULT_QUEUE_NAME;
        }

        @Override
        public QueueMetrics getMetrics() {
            return FifoScheduler.this.metrics;
        }

        @Override
        public QueueInfo getQueueInfo(boolean includeChildQueues, boolean recursive) {
            QueueInfo queueInfo = (QueueInfo)recordFactory.newRecordInstance(QueueInfo.class);
            queueInfo.setQueueName(FifoScheduler.this.DEFAULT_QUEUE.getQueueName());
            queueInfo.setCapacity(100.0f);
            queueInfo.setMaximumCapacity(100.0f);
            queueInfo.setChildQueues(new ArrayList());
            queueInfo.setQueueState(QueueState.RUNNING);
            return queueInfo;
        }

        @Override
        public Map<QueueACL, AccessControlList> getQueueAcls() {
            HashMap<QueueACL, AccessControlList> acls = new HashMap<QueueACL, AccessControlList>();
            for (QueueACL acl : QueueACL.values()) {
                acls.put(acl, new AccessControlList("*"));
            }
            return acls;
        }

        @Override
        public List<QueueUserACLInfo> getQueueUserAclInfo(UserGroupInformation unused) {
            QueueUserACLInfo queueUserAclInfo = (QueueUserACLInfo)recordFactory.newRecordInstance(QueueUserACLInfo.class);
            queueUserAclInfo.setQueueName(FifoScheduler.DEFAULT_QUEUE_NAME);
            queueUserAclInfo.setUserAcls(Arrays.asList(QueueACL.values()));
            return Collections.singletonList(queueUserAclInfo);
        }
    };
    private static final Allocation EMPTY_ALLOCATION = new Allocation(EMPTY_CONTAINER_LIST, Resources.createResource(0));
    private Resource clusterResource = (Resource)recordFactory.newRecordInstance(Resource.class);
    private Resource usedResource = (Resource)recordFactory.newRecordInstance(Resource.class);

    @Override
    public Resource getMinimumResourceCapability() {
        return this.minimumAllocation;
    }

    @Override
    public Resource getMaximumResourceCapability() {
        return this.maximumAllocation;
    }

    @Override
    public synchronized void reinitialize(Configuration conf, ContainerTokenSecretManager containerTokenSecretManager, RMContext rmContext) throws IOException {
        if (!this.initialized) {
            this.conf = conf;
            this.containerTokenSecretManager = containerTokenSecretManager;
            this.rmContext = rmContext;
            this.minimumAllocation = Resources.createResource(conf.getInt(MINIMUM_ALLOCATION, 1024));
            this.maximumAllocation = Resources.createResource(conf.getInt(MAXIMUM_ALLOCATION, 10240));
            this.initialized = true;
        } else {
            this.conf = conf;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Allocation allocate(ApplicationAttemptId applicationAttemptId, List<ResourceRequest> ask, List<ContainerId> release) {
        SchedulerApp application = this.getApplication(applicationAttemptId);
        if (application == null) {
            LOG.error((Object)("Calling allocate on removed or non existant application " + applicationAttemptId));
            return EMPTY_ALLOCATION;
        }
        SchedulerUtils.normalizeRequests(ask, 1024);
        for (ContainerId releasedContainer : release) {
            RMContainer rmContainer = this.getRMContainer(releasedContainer);
            if (rmContainer == null) {
                RMAuditLogger.logFailure(application.getUser(), "AM Released Container", "Unauthorized access or invalid container", "FifoScheduler", "Trying to release container not owned by app or with invalid id", application.getApplicationId(), releasedContainer);
            }
            this.containerCompleted(rmContainer, SchedulerUtils.createAbnormalContainerStatus(releasedContainer, "Container released by application"), RMContainerEventType.RELEASED);
        }
        SchedulerApp schedulerApp = application;
        synchronized (schedulerApp) {
            if (!ask.isEmpty()) {
                LOG.debug((Object)("allocate: pre-update applicationId=" + applicationAttemptId + " application=" + application));
                application.showRequests();
                application.updateResourceRequests(ask);
                LOG.debug((Object)("allocate: post-update applicationId=" + applicationAttemptId + " application=" + application));
                application.showRequests();
                LOG.debug((Object)("allocate: applicationId=" + applicationAttemptId + " #ask=" + ask.size()));
            }
            return new Allocation(application.pullNewlyAllocatedContainers(), application.getHeadroom());
        }
    }

    private SchedulerApp getApplication(ApplicationAttemptId applicationAttemptId) {
        return this.applications.get(applicationAttemptId);
    }

    @Override
    public SchedulerAppReport getSchedulerAppInfo(ApplicationAttemptId applicationAttemptId) {
        SchedulerApp app = this.getApplication(applicationAttemptId);
        return app == null ? null : new SchedulerAppReport(app);
    }

    private SchedulerNode getNode(NodeId nodeId) {
        return this.nodes.get(nodeId);
    }

    private synchronized void addApplication(ApplicationAttemptId appAttemptId, String user) {
        SchedulerApp schedulerApp = new SchedulerApp(appAttemptId, user, this.DEFAULT_QUEUE, this.rmContext, null);
        this.applications.put(appAttemptId, schedulerApp);
        this.metrics.submitApp(user);
        LOG.info((Object)("Application Submission: " + appAttemptId.getApplicationId() + " from " + user + ", currently active: " + this.applications.size()));
        this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppAttemptEvent(appAttemptId, RMAppAttemptEventType.APP_ACCEPTED));
    }

    private synchronized void doneApplication(ApplicationAttemptId applicationAttemptId, RMAppAttemptState rmAppAttemptFinalState) throws IOException {
        SchedulerApp application = this.getApplication(applicationAttemptId);
        if (application == null) {
            throw new IOException("Unknown application " + applicationAttemptId + " has completed!");
        }
        for (RMContainer container : application.getLiveContainers()) {
            this.containerCompleted(container, SchedulerUtils.createAbnormalContainerStatus(container.getContainerId(), "Container of a completed application"), RMContainerEventType.KILL);
        }
        application.stop(rmAppAttemptFinalState);
        this.applications.remove(applicationAttemptId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assignContainers(SchedulerNode node) {
        LOG.debug((Object)("assignContainers: node=" + node.getRMNode().getNodeAddress() + " #applications=" + this.applications.size()));
        for (Map.Entry<ApplicationAttemptId, SchedulerApp> e : this.applications.entrySet()) {
            SchedulerApp application = e.getValue();
            LOG.debug((Object)"pre-assignContainers");
            application.showRequests();
            SchedulerApp schedulerApp = application;
            synchronized (schedulerApp) {
                int assignedContainers;
                Priority priority;
                int maxContainers;
                Iterator<Priority> i$ = application.getPriorities().iterator();
                while (i$.hasNext() && ((maxContainers = this.getMaxAllocatableContainers(application, priority = i$.next(), node, NodeType.OFF_SWITCH)) <= 0 || (assignedContainers = this.assignContainersOnNode(node, application, priority)) != 0)) {
                }
            }
            application.setAvailableResourceLimit(this.clusterResource);
            LOG.debug((Object)"post-assignContainers");
            application.showRequests();
            if (!Resources.lessThan(node.getAvailableResource(), this.minimumAllocation)) continue;
            return;
        }
    }

    private int getMaxAllocatableContainers(SchedulerApp application, Priority priority, SchedulerNode node, NodeType type) {
        ResourceRequest nodeLocalRequest;
        ResourceRequest offSwitchRequest = application.getResourceRequest(priority, "*");
        int maxContainers = offSwitchRequest.getNumContainers();
        if (type == NodeType.OFF_SWITCH) {
            return maxContainers;
        }
        if (type == NodeType.RACK_LOCAL) {
            ResourceRequest rackLocalRequest = application.getResourceRequest(priority, node.getRMNode().getRackName());
            if (rackLocalRequest == null) {
                return maxContainers;
            }
            maxContainers = Math.min(maxContainers, rackLocalRequest.getNumContainers());
        }
        if (type == NodeType.NODE_LOCAL && (nodeLocalRequest = application.getResourceRequest(priority, node.getRMNode().getNodeAddress())) != null) {
            maxContainers = Math.min(maxContainers, nodeLocalRequest.getNumContainers());
        }
        return maxContainers;
    }

    private int assignContainersOnNode(SchedulerNode node, SchedulerApp application, Priority priority) {
        int nodeLocalContainers = this.assignNodeLocalContainers(node, application, priority);
        int rackLocalContainers = this.assignRackLocalContainers(node, application, priority);
        int offSwitchContainers = this.assignOffSwitchContainers(node, application, priority);
        LOG.debug((Object)("assignContainersOnNode: node=" + node.getRMNode().getNodeAddress() + " application=" + application.getApplicationId().getId() + " priority=" + priority.getPriority() + " #assigned=" + (nodeLocalContainers + rackLocalContainers + offSwitchContainers)));
        return nodeLocalContainers + rackLocalContainers + offSwitchContainers;
    }

    private int assignNodeLocalContainers(SchedulerNode node, SchedulerApp application, Priority priority) {
        int assignedContainers = 0;
        ResourceRequest request = application.getResourceRequest(priority, node.getRMNode().getNodeAddress());
        if (request != null) {
            ResourceRequest rackRequest = application.getResourceRequest(priority, node.getRMNode().getRackName());
            if (rackRequest == null || rackRequest.getNumContainers() <= 0) {
                return 0;
            }
            int assignableContainers = Math.min(this.getMaxAllocatableContainers(application, priority, node, NodeType.NODE_LOCAL), request.getNumContainers());
            assignedContainers = this.assignContainer(node, application, priority, assignableContainers, request, NodeType.NODE_LOCAL);
        }
        return assignedContainers;
    }

    private int assignRackLocalContainers(SchedulerNode node, SchedulerApp application, Priority priority) {
        int assignedContainers = 0;
        ResourceRequest request = application.getResourceRequest(priority, node.getRMNode().getRackName());
        if (request != null) {
            ResourceRequest offSwitchRequest = application.getResourceRequest(priority, "*");
            if (offSwitchRequest.getNumContainers() <= 0) {
                return 0;
            }
            int assignableContainers = Math.min(this.getMaxAllocatableContainers(application, priority, node, NodeType.RACK_LOCAL), request.getNumContainers());
            assignedContainers = this.assignContainer(node, application, priority, assignableContainers, request, NodeType.RACK_LOCAL);
        }
        return assignedContainers;
    }

    private int assignOffSwitchContainers(SchedulerNode node, SchedulerApp application, Priority priority) {
        int assignedContainers = 0;
        ResourceRequest request = application.getResourceRequest(priority, "*");
        if (request != null) {
            assignedContainers = this.assignContainer(node, application, priority, request.getNumContainers(), request, NodeType.OFF_SWITCH);
        }
        return assignedContainers;
    }

    private int assignContainer(SchedulerNode node, SchedulerApp application, Priority priority, int assignableContainers, ResourceRequest request, NodeType type) {
        LOG.debug((Object)("assignContainers: node=" + node.getRMNode().getNodeAddress() + " application=" + application.getApplicationId().getId() + " priority=" + priority.getPriority() + " assignableContainers=" + assignableContainers + " request=" + request + " type=" + (Object)((Object)type)));
        Resource capability = request.getCapability();
        int availableContainers = node.getAvailableResource().getMemory() / capability.getMemory();
        int assignedContainers = Math.min(assignableContainers, availableContainers);
        if (assignedContainers > 0) {
            for (int i = 0; i < assignedContainers; ++i) {
                NodeId nodeId = node.getRMNode().getNodeID();
                ContainerId containerId = BuilderUtils.newContainerId((ApplicationAttemptId)application.getApplicationAttemptId(), (int)application.getNewContainerId());
                ContainerToken containerToken = null;
                if (UserGroupInformation.isSecurityEnabled()) {
                    ContainerTokenIdentifier tokenIdentifier = new ContainerTokenIdentifier(containerId, nodeId.toString(), capability);
                    containerToken = BuilderUtils.newContainerToken((NodeId)nodeId, (ByteBuffer)ByteBuffer.wrap(this.containerTokenSecretManager.createPassword(tokenIdentifier)), (ContainerTokenIdentifier)tokenIdentifier);
                }
                Container container = BuilderUtils.newContainer((ContainerId)containerId, (NodeId)nodeId, (String)node.getRMNode().getHttpAddress(), (Resource)capability, (Priority)priority, containerToken);
                RMContainer rmContainer = application.allocate(type, node, priority, request, container);
                node.allocateContainer(application.getApplicationId(), rmContainer);
            }
            Resources.addTo(this.usedResource, Resources.multiply(capability, assignedContainers));
        }
        return assignedContainers;
    }

    private synchronized void nodeUpdate(RMNode rmNode, List<ContainerStatus> newlyLaunchedContainers, List<ContainerStatus> completedContainers) {
        SchedulerNode node = this.getNode(rmNode.getNodeID());
        for (ContainerStatus launchedContainer : newlyLaunchedContainers) {
            this.containerLaunchedOnNode(launchedContainer.getContainerId(), node);
        }
        for (ContainerStatus completedContainer : completedContainers) {
            ContainerId containerId = completedContainer.getContainerId();
            LOG.debug((Object)("Container FINISHED: " + containerId));
            this.containerCompleted(this.getRMContainer(containerId), completedContainer, RMContainerEventType.FINISHED);
        }
        if (Resources.greaterThanOrEqual(node.getAvailableResource(), this.minimumAllocation)) {
            LOG.info((Object)("Node heartbeat " + rmNode.getNodeID() + " available resource = " + node.getAvailableResource()));
            this.assignContainers(node);
            LOG.info((Object)("Node after allocation " + rmNode.getNodeID() + " resource = " + node.getAvailableResource()));
        }
        this.metrics.setAvailableResourcesToQueue(Resources.subtract(this.clusterResource, this.usedResource));
    }

    public void handle(SchedulerEvent event) {
        switch ((SchedulerEventType)event.getType()) {
            case NODE_ADDED: {
                NodeAddedSchedulerEvent nodeAddedEvent = (NodeAddedSchedulerEvent)event;
                this.addNode(nodeAddedEvent.getAddedRMNode());
                break;
            }
            case NODE_REMOVED: {
                NodeRemovedSchedulerEvent nodeRemovedEvent = (NodeRemovedSchedulerEvent)event;
                this.removeNode(nodeRemovedEvent.getRemovedRMNode());
                break;
            }
            case NODE_UPDATE: {
                NodeUpdateSchedulerEvent nodeUpdatedEvent = (NodeUpdateSchedulerEvent)event;
                this.nodeUpdate(nodeUpdatedEvent.getRMNode(), nodeUpdatedEvent.getNewlyLaunchedContainers(), nodeUpdatedEvent.getCompletedContainers());
                break;
            }
            case APP_ADDED: {
                AppAddedSchedulerEvent appAddedEvent = (AppAddedSchedulerEvent)event;
                this.addApplication(appAddedEvent.getApplicationAttemptId(), appAddedEvent.getUser());
                break;
            }
            case APP_REMOVED: {
                AppRemovedSchedulerEvent appRemovedEvent = (AppRemovedSchedulerEvent)event;
                try {
                    this.doneApplication(appRemovedEvent.getApplicationAttemptID(), appRemovedEvent.getFinalAttemptState());
                }
                catch (IOException ie) {
                    LOG.error((Object)("Unable to remove application " + appRemovedEvent.getApplicationAttemptID()), (Throwable)ie);
                }
                break;
            }
            case CONTAINER_EXPIRED: {
                ContainerExpiredSchedulerEvent containerExpiredEvent = (ContainerExpiredSchedulerEvent)event;
                ContainerId containerid = containerExpiredEvent.getContainerId();
                this.containerCompleted(this.getRMContainer(containerid), SchedulerUtils.createAbnormalContainerStatus(containerid, "Container expired since it was unused"), RMContainerEventType.EXPIRE);
                break;
            }
            default: {
                LOG.error((Object)("Invalid eventtype " + event.getType() + ". Ignoring!"));
            }
        }
    }

    private void containerLaunchedOnNode(ContainerId containerId, SchedulerNode node) {
        ApplicationAttemptId applicationAttemptId = containerId.getApplicationAttemptId();
        SchedulerApp application = this.getApplication(applicationAttemptId);
        if (application == null) {
            LOG.info((Object)("Unknown application: " + applicationAttemptId + " launched container " + containerId + " on node: " + node));
            return;
        }
        application.containerLaunchedOnNode(containerId);
    }

    @Lock(value={FifoScheduler.class})
    private synchronized void containerCompleted(RMContainer rmContainer, ContainerStatus containerStatus, RMContainerEventType event) {
        if (rmContainer == null) {
            LOG.info((Object)"Null container completed...");
            return;
        }
        Container container = rmContainer.getContainer();
        ApplicationAttemptId applicationAttemptId = container.getId().getApplicationAttemptId();
        SchedulerApp application = this.getApplication(applicationAttemptId);
        SchedulerNode node = this.getNode(container.getNodeId());
        if (application == null) {
            LOG.info((Object)("Unknown application: " + applicationAttemptId + " released container " + container.getId() + " on node: " + node + " with event: " + (Object)((Object)event)));
            return;
        }
        application.containerCompleted(rmContainer, containerStatus, event);
        node.releaseContainer(container);
        Resources.subtractFrom(this.usedResource, container.getResource());
        LOG.info((Object)("Application " + applicationAttemptId + " released container " + container.getId() + " on node: " + node + " with event: " + (Object)((Object)event)));
    }

    private synchronized void removeNode(RMNode nodeInfo) {
        SchedulerNode node = this.getNode(nodeInfo.getNodeID());
        for (RMContainer container : node.getRunningContainers()) {
            this.containerCompleted(container, SchedulerUtils.createAbnormalContainerStatus(container.getContainerId(), "Container released on a *lost* node"), RMContainerEventType.KILL);
        }
        this.nodes.remove(nodeInfo.getNodeID());
        Resources.subtractFrom(this.clusterResource, nodeInfo.getTotalCapability());
    }

    @Override
    public QueueInfo getQueueInfo(String queueName, boolean includeChildQueues, boolean recursive) {
        return this.DEFAULT_QUEUE.getQueueInfo(false, false);
    }

    @Override
    public List<QueueUserACLInfo> getQueueUserAclInfo() {
        return this.DEFAULT_QUEUE.getQueueUserAclInfo(null);
    }

    private synchronized void addNode(RMNode nodeManager) {
        this.nodes.put(nodeManager.getNodeID(), new SchedulerNode(nodeManager));
        Resources.addTo(this.clusterResource, nodeManager.getTotalCapability());
    }

    @Override
    public void recover(Store.RMState state) {
    }

    @Override
    public synchronized SchedulerNodeReport getNodeReport(NodeId nodeId) {
        SchedulerNode node = this.getNode(nodeId);
        return node == null ? null : new SchedulerNodeReport(node);
    }

    private RMContainer getRMContainer(ContainerId containerId) {
        SchedulerApp application = this.getApplication(containerId.getApplicationAttemptId());
        return application == null ? null : application.getRMContainer(containerId);
    }

    @Override
    public QueueMetrics getRootQueueMetrics() {
        return this.DEFAULT_QUEUE.getMetrics();
    }
}

