/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RmController;
import org.apache.hadoop.yarn.server.security.ApplicationACLsManager;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.webapp.WebApp;

public class RMWebApp
extends WebApp {
    static final String APP_ID = "app.id";
    static final String QUEUE_NAME = "queue.name";
    static final String NODE_STATE = "node.state";
    private final ResourceManager rm;

    public RMWebApp(ResourceManager rm) {
        this.rm = rm;
    }

    public void setup() {
        if (this.rm != null) {
            this.bind(ResourceManager.class).toInstance((Object)this.rm);
            this.bind(RMContext.class).toInstance((Object)this.rm.getRMContext());
            this.bind(ApplicationACLsManager.class).toInstance((Object)this.rm.getApplicationACLsManager());
        }
        this.route("/", RmController.class);
        this.route(StringHelper.pajoin((Object[])new Object[]{"/nodes", NODE_STATE}), RmController.class, "nodes");
        this.route("/apps", RmController.class);
        this.route("/cluster", RmController.class, "about");
        this.route(StringHelper.pajoin((Object[])new Object[]{"/app", APP_ID}), RmController.class, "app");
        this.route("/scheduler", RmController.class, "scheduler");
        this.route(StringHelper.pajoin((Object[])new Object[]{"/queue", QUEUE_NAME}), RmController.class, "queue");
    }
}

