/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.api.impl.pb.client;

import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.yarn.exceptions.YarnRemoteException;
import org.apache.hadoop.yarn.exceptions.impl.pb.YarnRemoteExceptionPBImpl;
import org.apache.hadoop.yarn.proto.YarnServerResourceManagerServiceProtos;
import org.apache.hadoop.yarn.server.resourcemanager.api.RMAdminProtocol;
import org.apache.hadoop.yarn.server.resourcemanager.api.RMAdminProtocolPB;
import org.apache.hadoop.yarn.server.resourcemanager.api.protocolrecords.RefreshAdminAclsRequest;
import org.apache.hadoop.yarn.server.resourcemanager.api.protocolrecords.RefreshAdminAclsResponse;
import org.apache.hadoop.yarn.server.resourcemanager.api.protocolrecords.RefreshNodesRequest;
import org.apache.hadoop.yarn.server.resourcemanager.api.protocolrecords.RefreshNodesResponse;
import org.apache.hadoop.yarn.server.resourcemanager.api.protocolrecords.RefreshQueuesRequest;
import org.apache.hadoop.yarn.server.resourcemanager.api.protocolrecords.RefreshQueuesResponse;
import org.apache.hadoop.yarn.server.resourcemanager.api.protocolrecords.RefreshServiceAclsRequest;
import org.apache.hadoop.yarn.server.resourcemanager.api.protocolrecords.RefreshServiceAclsResponse;
import org.apache.hadoop.yarn.server.resourcemanager.api.protocolrecords.RefreshSuperUserGroupsConfigurationRequest;
import org.apache.hadoop.yarn.server.resourcemanager.api.protocolrecords.RefreshSuperUserGroupsConfigurationResponse;
import org.apache.hadoop.yarn.server.resourcemanager.api.protocolrecords.RefreshUserToGroupsMappingsRequest;
import org.apache.hadoop.yarn.server.resourcemanager.api.protocolrecords.RefreshUserToGroupsMappingsResponse;
import org.apache.hadoop.yarn.server.resourcemanager.api.protocolrecords.impl.pb.RefreshAdminAclsRequestPBImpl;
import org.apache.hadoop.yarn.server.resourcemanager.api.protocolrecords.impl.pb.RefreshAdminAclsResponsePBImpl;
import org.apache.hadoop.yarn.server.resourcemanager.api.protocolrecords.impl.pb.RefreshNodesRequestPBImpl;
import org.apache.hadoop.yarn.server.resourcemanager.api.protocolrecords.impl.pb.RefreshNodesResponsePBImpl;
import org.apache.hadoop.yarn.server.resourcemanager.api.protocolrecords.impl.pb.RefreshQueuesRequestPBImpl;
import org.apache.hadoop.yarn.server.resourcemanager.api.protocolrecords.impl.pb.RefreshQueuesResponsePBImpl;
import org.apache.hadoop.yarn.server.resourcemanager.api.protocolrecords.impl.pb.RefreshServiceAclsRequestPBImpl;
import org.apache.hadoop.yarn.server.resourcemanager.api.protocolrecords.impl.pb.RefreshServiceAclsResponsePBImpl;
import org.apache.hadoop.yarn.server.resourcemanager.api.protocolrecords.impl.pb.RefreshSuperUserGroupsConfigurationRequestPBImpl;
import org.apache.hadoop.yarn.server.resourcemanager.api.protocolrecords.impl.pb.RefreshSuperUserGroupsConfigurationResponsePBImpl;
import org.apache.hadoop.yarn.server.resourcemanager.api.protocolrecords.impl.pb.RefreshUserToGroupsMappingsRequestPBImpl;
import org.apache.hadoop.yarn.server.resourcemanager.api.protocolrecords.impl.pb.RefreshUserToGroupsMappingsResponsePBImpl;

public class RMAdminProtocolPBClientImpl
implements RMAdminProtocol {
    private RMAdminProtocolPB proxy;

    public RMAdminProtocolPBClientImpl(long clientVersion, InetSocketAddress addr, Configuration conf) throws IOException {
        RPC.setProtocolEngine((Configuration)conf, RMAdminProtocolPB.class, ProtobufRpcEngine.class);
        this.proxy = (RMAdminProtocolPB)RPC.getProxy(RMAdminProtocolPB.class, (long)clientVersion, (InetSocketAddress)addr, (Configuration)conf);
    }

    @Override
    public RefreshQueuesResponse refreshQueues(RefreshQueuesRequest request) throws YarnRemoteException {
        YarnServerResourceManagerServiceProtos.RefreshQueuesRequestProto requestProto = ((RefreshQueuesRequestPBImpl)request).getProto();
        try {
            return new RefreshQueuesResponsePBImpl(this.proxy.refreshQueues(null, requestProto));
        }
        catch (ServiceException e) {
            throw YarnRemoteExceptionPBImpl.unwrapAndThrowException((ServiceException)e);
        }
    }

    @Override
    public RefreshNodesResponse refreshNodes(RefreshNodesRequest request) throws YarnRemoteException {
        YarnServerResourceManagerServiceProtos.RefreshNodesRequestProto requestProto = ((RefreshNodesRequestPBImpl)request).getProto();
        try {
            return new RefreshNodesResponsePBImpl(this.proxy.refreshNodes(null, requestProto));
        }
        catch (ServiceException e) {
            throw YarnRemoteExceptionPBImpl.unwrapAndThrowException((ServiceException)e);
        }
    }

    @Override
    public RefreshSuperUserGroupsConfigurationResponse refreshSuperUserGroupsConfiguration(RefreshSuperUserGroupsConfigurationRequest request) throws YarnRemoteException {
        YarnServerResourceManagerServiceProtos.RefreshSuperUserGroupsConfigurationRequestProto requestProto = ((RefreshSuperUserGroupsConfigurationRequestPBImpl)request).getProto();
        try {
            return new RefreshSuperUserGroupsConfigurationResponsePBImpl(this.proxy.refreshSuperUserGroupsConfiguration(null, requestProto));
        }
        catch (ServiceException e) {
            throw YarnRemoteExceptionPBImpl.unwrapAndThrowException((ServiceException)e);
        }
    }

    @Override
    public RefreshUserToGroupsMappingsResponse refreshUserToGroupsMappings(RefreshUserToGroupsMappingsRequest request) throws YarnRemoteException {
        YarnServerResourceManagerServiceProtos.RefreshUserToGroupsMappingsRequestProto requestProto = ((RefreshUserToGroupsMappingsRequestPBImpl)request).getProto();
        try {
            return new RefreshUserToGroupsMappingsResponsePBImpl(this.proxy.refreshUserToGroupsMappings(null, requestProto));
        }
        catch (ServiceException e) {
            throw YarnRemoteExceptionPBImpl.unwrapAndThrowException((ServiceException)e);
        }
    }

    @Override
    public RefreshAdminAclsResponse refreshAdminAcls(RefreshAdminAclsRequest request) throws YarnRemoteException {
        YarnServerResourceManagerServiceProtos.RefreshAdminAclsRequestProto requestProto = ((RefreshAdminAclsRequestPBImpl)request).getProto();
        try {
            return new RefreshAdminAclsResponsePBImpl(this.proxy.refreshAdminAcls(null, requestProto));
        }
        catch (ServiceException e) {
            throw YarnRemoteExceptionPBImpl.unwrapAndThrowException((ServiceException)e);
        }
    }

    @Override
    public RefreshServiceAclsResponse refreshServiceAcls(RefreshServiceAclsRequest request) throws YarnRemoteException {
        YarnServerResourceManagerServiceProtos.RefreshServiceAclsRequestProto requestProto = ((RefreshServiceAclsRequestPBImpl)request).getProto();
        try {
            return new RefreshServiceAclsResponsePBImpl(this.proxy.refreshServiceAcls(null, requestProto));
        }
        catch (ServiceException e) {
            throw YarnRemoteExceptionPBImpl.unwrapAndThrowException((ServiceException)e);
        }
    }
}

