/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.recovery;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationMaster;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.ApplicationsStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.Store;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;

public class MemStore
implements Store {
    RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    private NodeId nodeId = (NodeId)this.recordFactory.newRecordInstance(NodeId.class);
    private boolean doneWithRecovery = false;

    public MemStore() {
        this.nodeId.setHost("TODO");
        this.nodeId.setPort(-1);
    }

    @Override
    public void storeNode(RMNode node) throws IOException {
    }

    @Override
    public void removeNode(RMNode node) throws IOException {
    }

    @Override
    public ApplicationsStore.ApplicationStore createApplicationStore(ApplicationId application, ApplicationSubmissionContext context) throws IOException {
        return new ApplicationStoreImpl();
    }

    @Override
    public void removeApplication(ApplicationId application) throws IOException {
    }

    @Override
    public Store.RMState restore() throws IOException {
        MemRMState state = new MemRMState();
        return state;
    }

    @Override
    public synchronized NodeId getNextNodeId() throws IOException {
        return this.nodeId;
    }

    @Override
    public boolean isLoggable() {
        return this.doneWithRecovery;
    }

    @Override
    public void doneWithRecovery() {
        this.doneWithRecovery = true;
    }

    private class MemRMState
    implements Store.RMState {
        public MemRMState() {
            MemStore.this.nodeId = (NodeId)MemStore.this.recordFactory.newRecordInstance(NodeId.class);
        }

        @Override
        public List<RMNode> getStoredNodeManagers() {
            return new ArrayList<RMNode>();
        }

        @Override
        public NodeId getLastLoggedNodeId() {
            return MemStore.this.nodeId;
        }

        @Override
        public Map<ApplicationId, Store.ApplicationInfo> getStoredApplications() {
            return new HashMap<ApplicationId, Store.ApplicationInfo>();
        }
    }

    private class ApplicationStoreImpl
    implements ApplicationsStore.ApplicationStore {
        private ApplicationStoreImpl() {
        }

        @Override
        public void storeContainer(Container container) throws IOException {
        }

        @Override
        public void removeContainer(Container container) throws IOException {
        }

        @Override
        public void storeMasterContainer(Container container) throws IOException {
        }

        @Override
        public void updateApplicationState(ApplicationMaster master) throws IOException {
        }

        @Override
        public boolean isLoggable() {
            return MemStore.this.doneWithRecovery;
        }
    }
}

