/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import org.apache.hadoop.yarn.Lock;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.resource.Resources;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;

class CSQueueUtils {
    static final float EPSILON = 1.0E-4f;

    CSQueueUtils() {
    }

    public static void checkMaxCapacity(String queueName, float capacity, float maximumCapacity) {
        if (maximumCapacity < 0.0f || maximumCapacity > 1.0f) {
            throw new IllegalArgumentException("Illegal value  of maximumCapacity " + maximumCapacity + " used in call to setMaxCapacity for queue " + queueName);
        }
    }

    public static void checkAbsoluteCapacities(String queueName, float absCapacity, float absMaxCapacity) {
        if (absMaxCapacity < absCapacity - 1.0E-4f) {
            throw new IllegalArgumentException("Illegal call to setMaxCapacity. Queue '" + queueName + "' has " + "an absolute capacity (" + absCapacity + ") greater than " + "its absolute maximumCapacity (" + absMaxCapacity + ")");
        }
    }

    public static float computeAbsoluteMaximumCapacity(float maximumCapacity, CSQueue parent) {
        float parentAbsMaxCapacity = parent == null ? 1.0f : parent.getAbsoluteMaximumCapacity();
        return parentAbsMaxCapacity * maximumCapacity;
    }

    public static int computeMaxActiveApplications(Resource clusterResource, Resource minimumAllocation, float maxAMResourcePercent, float absoluteMaxCapacity) {
        return Math.max((int)Math.ceil((float)clusterResource.getMemory() / (float)minimumAllocation.getMemory() * maxAMResourcePercent * absoluteMaxCapacity), 1);
    }

    public static int computeMaxActiveApplicationsPerUser(int maxActiveApplications, int userLimit, float userLimitFactor) {
        return Math.max((int)Math.ceil((float)maxActiveApplications * ((float)userLimit / 100.0f) * userLimitFactor), 1);
    }

    @Lock(value={CSQueue.class})
    public static void updateQueueStatistics(CSQueue childQueue, CSQueue parentQueue, Resource clusterResource, Resource minimumAllocation) {
        int clusterMemory = clusterResource.getMemory();
        int usedMemory = childQueue.getUsedResources().getMemory();
        float queueLimit = 0.0f;
        float absoluteUsedCapacity = 0.0f;
        float usedCapacity = 0.0f;
        if (clusterMemory > 0) {
            queueLimit = (float)clusterMemory * childQueue.getAbsoluteCapacity();
            absoluteUsedCapacity = (float)usedMemory / (float)clusterMemory;
            usedCapacity = (float)usedMemory / queueLimit;
        }
        childQueue.setUsedCapacity(usedCapacity);
        childQueue.setAbsoluteUsedCapacity(absoluteUsedCapacity);
        int available = Math.max(CSQueueUtils.roundUp(minimumAllocation, (int)queueLimit) - usedMemory, 0);
        childQueue.getMetrics().setAvailableResourcesToQueue(Resources.createResource(available));
    }

    public static int roundUp(Resource minimumAllocation, int memory) {
        int minMemory = minimumAllocation.getMemory();
        return LeafQueue.divideAndCeil(memory, minMemory) * minMemory;
    }

    public static int roundDown(Resource minimumAllocation, int memory) {
        int minMemory = minimumAllocation.getMemory();
        return memory / minMemory * minMemory;
    }
}

