/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.QueueState;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.resource.Resources;

public class CapacitySchedulerConfiguration
extends Configuration {
    private static final Log LOG = LogFactory.getLog(CapacitySchedulerConfiguration.class);
    private static final String CS_CONFIGURATION_FILE = "capacity-scheduler.xml";
    @InterfaceAudience.Private
    public static final String PREFIX = "yarn.scheduler.capacity.";
    @InterfaceAudience.Private
    public static final String DOT = ".";
    @InterfaceAudience.Private
    public static final String MAXIMUM_SYSTEM_APPLICATIONS = "yarn.scheduler.capacity.maximum-applications";
    @InterfaceAudience.Private
    public static final String MAXIMUM_APPLICATION_MASTERS_RESOURCE_PERCENT = "yarn.scheduler.capacity.maximum-am-resource-percent";
    @InterfaceAudience.Private
    public static final String QUEUES = "queues";
    @InterfaceAudience.Private
    public static final String CAPACITY = "capacity";
    @InterfaceAudience.Private
    public static final String MAXIMUM_CAPACITY = "maximum-capacity";
    @InterfaceAudience.Private
    public static final String USER_LIMIT = "minimum-user-limit-percent";
    @InterfaceAudience.Private
    public static final String USER_LIMIT_FACTOR = "user-limit-factor";
    @InterfaceAudience.Private
    public static final String STATE = "state";
    @InterfaceAudience.Private
    public static final int DEFAULT_MAXIMUM_SYSTEM_APPLICATIIONS = 10000;
    @InterfaceAudience.Private
    public static final float DEFAULT_MAXIMUM_APPLICATIONMASTERS_RESOURCE_PERCENT = 0.1f;
    @InterfaceAudience.Private
    public static final int UNDEFINED = -1;
    @InterfaceAudience.Private
    public static final int MINIMUM_CAPACITY_VALUE = 1;
    @InterfaceAudience.Private
    public static final int MAXIMUM_CAPACITY_VALUE = 100;
    @InterfaceAudience.Private
    public static final int DEFAULT_USER_LIMIT = 100;
    @InterfaceAudience.Private
    public static final float DEFAULT_USER_LIMIT_FACTOR = 1.0f;
    @InterfaceAudience.Private
    public static final String ALL_ACL = "*";
    @InterfaceAudience.Private
    public static final String NONE_ACL = " ";
    @InterfaceAudience.Private
    public static final String ENABLE_USER_METRICS = "yarn.scheduler.capacity.user-metrics.enable";
    @InterfaceAudience.Private
    public static final boolean DEFAULT_ENABLE_USER_METRICS = false;
    @InterfaceAudience.Private
    public static final String ROOT = "root";

    public CapacitySchedulerConfiguration() {
        this(new Configuration());
    }

    public CapacitySchedulerConfiguration(Configuration configuration) {
        super(configuration);
        this.addResource(CS_CONFIGURATION_FILE);
    }

    private String getQueuePrefix(String queue) {
        String queueName = PREFIX + queue + DOT;
        return queueName;
    }

    public int getMaximumSystemApplications() {
        int maxApplications = this.getInt(MAXIMUM_SYSTEM_APPLICATIONS, 10000);
        return maxApplications;
    }

    public float getMaximumApplicationMasterResourcePercent() {
        return this.getFloat(MAXIMUM_APPLICATION_MASTERS_RESOURCE_PERCENT, 0.1f);
    }

    public int getCapacity(String queue) {
        int capacity = this.getInt(this.getQueuePrefix(queue) + CAPACITY, -1);
        if (capacity < 1 || capacity > 100) {
            throw new IllegalArgumentException("Illegal capacity of " + capacity + " for queue " + queue);
        }
        LOG.debug((Object)("CSConf - getCapacity: queuePrefix=" + this.getQueuePrefix(queue) + ", capacity=" + capacity));
        return capacity;
    }

    public void setCapacity(String queue, int capacity) {
        this.setInt(this.getQueuePrefix(queue) + CAPACITY, capacity);
        LOG.debug((Object)("CSConf - setCapacity: queuePrefix=" + this.getQueuePrefix(queue) + ", capacity=" + capacity));
    }

    public int getMaximumCapacity(String queue) {
        int maxCapacity = this.getInt(this.getQueuePrefix(queue) + MAXIMUM_CAPACITY, 100);
        return maxCapacity;
    }

    public void setMaximumCapacity(String queue, int maxCapacity) {
        if (maxCapacity > 100) {
            throw new IllegalArgumentException("Illegal maximum-capacity of " + maxCapacity + " for queue " + queue);
        }
        this.setInt(this.getQueuePrefix(queue) + MAXIMUM_CAPACITY, maxCapacity);
        LOG.debug((Object)("CSConf - setMaxCapacity: queuePrefix=" + this.getQueuePrefix(queue) + ", maxCapacity=" + maxCapacity));
    }

    public int getUserLimit(String queue) {
        int userLimit = this.getInt(this.getQueuePrefix(queue) + USER_LIMIT, 100);
        return userLimit;
    }

    public void setUserLimit(String queue, int userLimit) {
        this.setInt(this.getQueuePrefix(queue) + USER_LIMIT, userLimit);
        LOG.debug((Object)("here setUserLimit: queuePrefix=" + this.getQueuePrefix(queue) + ", userLimit=" + this.getUserLimit(queue)));
    }

    public float getUserLimitFactor(String queue) {
        float userLimitFactor = this.getFloat(this.getQueuePrefix(queue) + USER_LIMIT_FACTOR, 1.0f);
        return userLimitFactor;
    }

    public void setUserLimitFactor(String queue, float userLimitFactor) {
        this.setFloat(this.getQueuePrefix(queue) + USER_LIMIT_FACTOR, userLimitFactor);
    }

    public QueueState getState(String queue) {
        String state = this.get(this.getQueuePrefix(queue) + STATE);
        return state != null ? QueueState.valueOf((String)state.toUpperCase()) : QueueState.RUNNING;
    }

    private static String getAclKey(QueueACL acl) {
        return "acl_" + acl.toString().toLowerCase();
    }

    public AccessControlList getAcl(String queue, QueueACL acl) {
        String queuePrefix = this.getQueuePrefix(queue);
        String defaultAcl = queue.equals(ROOT) ? ALL_ACL : NONE_ACL;
        String aclString = this.get(queuePrefix + CapacitySchedulerConfiguration.getAclKey(acl), defaultAcl);
        return new AccessControlList(aclString);
    }

    public void setAcl(String queue, QueueACL acl, String aclString) {
        String queuePrefix = this.getQueuePrefix(queue);
        this.set(queuePrefix + CapacitySchedulerConfiguration.getAclKey(acl), aclString);
    }

    public Map<QueueACL, AccessControlList> getAcls(String queue) {
        HashMap<QueueACL, AccessControlList> acls = new HashMap<QueueACL, AccessControlList>();
        for (QueueACL acl : QueueACL.values()) {
            acls.put(acl, this.getAcl(queue, acl));
        }
        return acls;
    }

    public void setAcls(String queue, Map<QueueACL, AccessControlList> acls) {
        for (Map.Entry<QueueACL, AccessControlList> e : acls.entrySet()) {
            this.setAcl(queue, e.getKey(), e.getValue().getAclString());
        }
    }

    public String[] getQueues(String queue) {
        LOG.debug((Object)("CSConf - getQueues called for: queuePrefix=" + this.getQueuePrefix(queue)));
        String[] queues = this.getStrings(this.getQueuePrefix(queue) + QUEUES);
        LOG.debug((Object)("CSConf - getQueues: queuePrefix=" + this.getQueuePrefix(queue) + ", queues=" + (queues == null ? "" : StringUtils.arrayToString((String[])queues))));
        return queues;
    }

    public void setQueues(String queue, String[] subQueues) {
        this.set(this.getQueuePrefix(queue) + QUEUES, StringUtils.arrayToString((String[])subQueues));
        LOG.debug((Object)("CSConf - setQueues: qPrefix=" + this.getQueuePrefix(queue) + ", queues=" + StringUtils.arrayToString((String[])subQueues)));
    }

    public Resource getMinimumAllocation() {
        int minimumMemory = this.getInt("yarn.scheduler.minimum-allocation-mb", 128);
        return Resources.createResource(minimumMemory);
    }

    public Resource getMaximumAllocation() {
        int maximumMemory = this.getInt("yarn.scheduler.maximum-allocation-mb", 10240);
        return Resources.createResource(maximumMemory);
    }

    public boolean getEnableUserMetrics() {
        return this.getBoolean(ENABLE_USER_METRICS, false);
    }
}

