/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import com.google.inject.Inject;
import java.util.HashSet;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.AppsList;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppInfo;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.util.Times;
import org.apache.hadoop.yarn.webapp.View;
import org.apache.hadoop.yarn.webapp.hamlet.Hamlet;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.apache.hadoop.yarn.webapp.view.JQueryUI;

class AppsBlock
extends HtmlBlock {
    final AppsList list;

    @Inject
    AppsBlock(AppsList list, View.ViewContext ctx) {
        super(ctx);
        this.list = list;
    }

    public void render(HtmlBlock.Block html) {
        Hamlet.TBODY tbody = ((Hamlet.TABLE)((Hamlet.THEAD)html.table("#apps").thead().tr().th(".id", "ID").th(".user", "User").th(".name", "Name").th(".queue", "Queue").th(".starttime", "StartTime").th(".finishtime", "FinishTime").th(".state", "State").th(".finalstatus", "FinalStatus").th(".progress", "Progress").th(".ui", "Tracking UI")._())._()).tbody();
        int i = 0;
        HashSet<RMAppState> reqAppStates = null;
        String reqStateString = this.$("app.state");
        if (reqStateString != null && !reqStateString.isEmpty()) {
            String[] appStateStrings = reqStateString.split(",");
            reqAppStates = new HashSet<RMAppState>(appStateStrings.length);
            for (String stateString : appStateStrings) {
                reqAppStates.add(RMAppState.valueOf(stateString));
            }
        }
        for (RMApp app : this.list.apps.values()) {
            if (reqAppStates != null && !reqAppStates.contains((Object)app.getState())) continue;
            AppInfo appInfo = new AppInfo(app, true);
            String percent = String.format("%.1f", Float.valueOf(appInfo.getProgress()));
            String startTime = Times.format((long)appInfo.getStartTime());
            String finishTime = Times.format((long)appInfo.getFinishTime());
            ((Hamlet.TR)((Hamlet.TR)((Hamlet.TD)((Hamlet.DIV)((Hamlet.TD)((Hamlet.TR)((Hamlet.TD)((Hamlet.TR)((Hamlet.TD)((Hamlet.TR)((Hamlet.TD)tbody.tr().td().br().$title(appInfo.getAppIdNum())._()).a(this.url(new String[]{"app", appInfo.getAppId()}), appInfo.getAppId())._()).td(appInfo.getUser()).td(appInfo.getName()).td(appInfo.getQueue()).td().br().$title(startTime)._())._(new Object[]{startTime})._()).td().br().$title(finishTime)._())._(new Object[]{finishTime})._()).td(appInfo.getState()).td(appInfo.getFinalStatus()).td().br().$title(percent)._()).div(".ui-progressbar.ui-widget.ui-widget-content.ui-corner-all").$title(StringHelper.join((Object[])new Object[]{percent, Character.valueOf('%')})).div(".ui-progressbar-value.ui-widget-header.ui-corner-left").$style(StringHelper.join((Object[])new Object[]{"width:", percent, Character.valueOf('%')}))._())._())._()).td().a(!appInfo.isTrackingUrlReady() ? "#" : appInfo.getTrackingUrlPretty(), appInfo.getTrackingUI())._())._();
            if (this.list.rendering == JQueryUI.Render.HTML || ++i < 20) continue;
            break;
        }
        ((Hamlet.TABLE)tbody._())._();
        if (this.list.rendering == JQueryUI.Render.JS_ARRAY) {
            this.echo(new Object[]{"<script type='text/javascript'>\n", "var appsData="});
            this.list.toDataTableArrays(reqAppStates, this.writer());
            this.echo(new Object[]{"\n</script>\n"});
        }
    }
}

