/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import com.google.inject.Inject;
import com.google.inject.servlet.RequestScoped;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppInfo;
import org.apache.hadoop.yarn.util.Times;
import org.apache.hadoop.yarn.webapp.Controller;
import org.apache.hadoop.yarn.webapp.ToJSON;
import org.apache.hadoop.yarn.webapp.view.JQueryUI;
import org.apache.hadoop.yarn.webapp.view.Jsons;

@RequestScoped
class AppsList
implements ToJSON {
    final Controller.RequestContext rc;
    final ConcurrentMap<ApplicationId, RMApp> apps;
    JQueryUI.Render rendering;

    @Inject
    AppsList(Controller.RequestContext ctx, RMContext rmContext) {
        this.rc = ctx;
        this.apps = rmContext.getRMApps();
    }

    void toDataTableArrays(Collection<RMAppState> requiredAppStates, PrintWriter out) {
        out.append('[');
        boolean first = true;
        for (RMApp app : this.apps.values()) {
            if (requiredAppStates != null && !requiredAppStates.contains((Object)app.getState())) continue;
            AppInfo appInfo = new AppInfo(app, true);
            String startTime = Times.format((long)appInfo.getStartTime());
            String finishTime = Times.format((long)appInfo.getFinishTime());
            if (first) {
                first = false;
            } else {
                out.append(",\n");
            }
            out.append("[\"");
            Jsons.appendSortable((PrintWriter)out, (Object)appInfo.getAppIdNum());
            Jsons.appendLink((PrintWriter)out, (Object)appInfo.getAppId(), (String)this.rc.prefix(), (String[])new String[]{"app", appInfo.getAppId()}).append("\",\"").append(StringEscapeUtils.escapeHtml((String)appInfo.getUser())).append("\",\"").append(StringEscapeUtils.escapeJavaScript((String)StringEscapeUtils.escapeHtml((String)appInfo.getName()))).append("\",\"").append(StringEscapeUtils.escapeHtml((String)appInfo.getQueue())).append("\",\"");
            Jsons.appendSortable((PrintWriter)out, (Object)startTime).append(startTime).append("\",\"");
            Jsons.appendSortable((PrintWriter)out, (Object)finishTime).append(finishTime).append("\",\"").append(appInfo.getState()).append("\",\"").append(appInfo.getFinalStatus()).append("\",\"");
            Jsons.appendProgressBar((PrintWriter)out, (float)appInfo.getProgress()).append("\",\"");
            Jsons.appendLink((PrintWriter)out, (Object)appInfo.getTrackingUI(), (String)this.rc.prefix(), (String[])new String[]{!appInfo.isTrackingUrlReady() ? "#" : appInfo.getTrackingUrlPretty()}).append("\"]");
        }
        out.append(']');
    }

    public void toJSON(PrintWriter out) {
        out.print("{\"aaData\":");
        this.toDataTableArrays(null, out);
        out.print("}\n");
    }
}

