/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import com.google.inject.Inject;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.AboutPage;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.AppPage;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.AppsList;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.CapacitySchedulerPage;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.DefaultSchedulerPage;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.NodesPage;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppInfo;
import org.apache.hadoop.yarn.server.security.ApplicationACLsManager;
import org.apache.hadoop.yarn.util.Apps;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.util.Times;
import org.apache.hadoop.yarn.webapp.Controller;
import org.apache.hadoop.yarn.webapp.ResponseInfo;

public class RmController
extends Controller {
    private ApplicationACLsManager aclsManager;

    @Inject
    RmController(Controller.RequestContext ctx, ApplicationACLsManager aclsManager) {
        super(ctx);
        this.aclsManager = aclsManager;
    }

    public void index() {
        this.setTitle("Applications");
    }

    public void about() {
        this.setTitle("About the Cluster");
        this.render(AboutPage.class);
    }

    public void app() {
        String aid = this.$("app.id");
        if (aid.isEmpty()) {
            this.setStatus(400);
            this.setTitle("Bad request: requires application ID");
            return;
        }
        ApplicationId appID = Apps.toAppID((String)aid);
        RMContext context = (RMContext)this.getInstance(RMContext.class);
        RMApp rmApp = (RMApp)context.getRMApps().get(appID);
        if (rmApp == null) {
            this.setStatus(404);
            this.setTitle("Application not found: " + aid);
            return;
        }
        AppInfo app = new AppInfo(rmApp, true);
        String remoteUser = this.request().getRemoteUser();
        UserGroupInformation callerUGI = null;
        if (remoteUser != null) {
            callerUGI = UserGroupInformation.createRemoteUser((String)remoteUser);
        }
        if (callerUGI != null && !this.aclsManager.checkAccess(callerUGI, ApplicationAccessType.VIEW_APP, app.getUser(), appID)) {
            this.setStatus(401);
            this.setTitle("Unauthorized request for viewing application " + appID);
            this.renderText("You (User " + remoteUser + ") are not authorized to view the logs for application " + appID);
            return;
        }
        this.setTitle(StringHelper.join((Object[])new Object[]{"Application ", aid}));
        ResponseInfo info = this.info("Application Overview")._("User:", (Object)app.getUser())._("Name:", (Object)app.getName())._("State:", (Object)app.getState())._("FinalStatus:", (Object)app.getFinalStatus())._("Started:", (Object)Times.format((long)app.getStartTime()))._("Elapsed:", (Object)StringUtils.formatTime((long)Times.elapsed((long)app.getStartTime(), (long)app.getFinishTime())))._("Tracking URL:", !app.isTrackingUrlReady() ? "#" : app.getTrackingUrlPretty(), (Object)app.getTrackingUI())._("Diagnostics:", (Object)app.getNote());
        if (app.amContainerLogsExist()) {
            info._("AM container logs:", app.getAMContainerLogs(), (Object)app.getAMContainerLogs());
        } else {
            info._("AM container logs:", (Object)"");
        }
        this.render(AppPage.class);
    }

    public void nodes() {
        this.render(NodesPage.class);
    }

    public void scheduler() {
        this.set("app.state", StringHelper.cjoin((Object[])new Object[]{RMAppState.NEW.toString(), RMAppState.SUBMITTED.toString(), RMAppState.ACCEPTED.toString(), RMAppState.RUNNING.toString()}));
        ResourceManager rm = (ResourceManager)this.getInstance(ResourceManager.class);
        ResourceScheduler rs = rm.getResourceScheduler();
        if (rs == null || rs instanceof CapacityScheduler) {
            this.setTitle("Capacity Scheduler");
            this.render(CapacitySchedulerPage.class);
            return;
        }
        this.setTitle("Default Scheduler");
        this.render(DefaultSchedulerPage.class);
    }

    public void queue() {
        this.setTitle(StringHelper.join((Object[])new Object[]{"Queue ", this.get("queue.name", "unknown")}));
    }

    public void submit() {
        this.setTitle("Application Submission Not Allowed");
    }

    public void json() {
        this.renderJSON(AppsList.class);
    }
}

