/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.source.JvmMetrics;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.ShutdownHookManager;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.YarnException;
import org.apache.hadoop.yarn.YarnUncaughtExceptionHandler;
import org.apache.hadoop.yarn.api.ClientRMProtocol;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.AsyncDispatcher;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.server.RMDelegationTokenSecretManager;
import org.apache.hadoop.yarn.server.resourcemanager.AdminService;
import org.apache.hadoop.yarn.server.resourcemanager.ApplicationMasterService;
import org.apache.hadoop.yarn.server.resourcemanager.ClientRMService;
import org.apache.hadoop.yarn.server.resourcemanager.NMLivelinessMonitor;
import org.apache.hadoop.yarn.server.resourcemanager.NodesListManager;
import org.apache.hadoop.yarn.server.resourcemanager.NodesListManagerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.RMAppManager;
import org.apache.hadoop.yarn.server.resourcemanager.RMAppManagerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMContextImpl;
import org.apache.hadoop.yarn.server.resourcemanager.RMNMInfo;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceTrackerService;
import org.apache.hadoop.yarn.server.resourcemanager.amlauncher.AMLauncherEventType;
import org.apache.hadoop.yarn.server.resourcemanager.amlauncher.ApplicationMasterLauncher;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.NullRMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStoreFactory;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.Recoverable;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.AMLivelinessMonitor;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.ContainerAllocationExpirer;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeEventType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.security.ApplicationTokenSecretManager;
import org.apache.hadoop.yarn.server.resourcemanager.security.ClientToAMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.server.resourcemanager.security.DelegationTokenRenewer;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMContainerTokenSecretManager;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RMWebApp;
import org.apache.hadoop.yarn.server.security.ApplicationACLsManager;
import org.apache.hadoop.yarn.server.webproxy.AppReportFetcher;
import org.apache.hadoop.yarn.server.webproxy.WebAppProxyServlet;
import org.apache.hadoop.yarn.service.AbstractService;
import org.apache.hadoop.yarn.service.CompositeService;
import org.apache.hadoop.yarn.service.Service;
import org.apache.hadoop.yarn.webapp.WebApp;
import org.apache.hadoop.yarn.webapp.WebApps;

public class ResourceManager
extends CompositeService
implements Recoverable {
    public static final int SHUTDOWN_HOOK_PRIORITY = 30;
    private static final Log LOG = LogFactory.getLog(ResourceManager.class);
    public static final long clusterTimeStamp = System.currentTimeMillis();
    protected ClientToAMTokenSecretManagerInRM clientToAMSecretManager = new ClientToAMTokenSecretManagerInRM();
    protected RMContainerTokenSecretManager containerTokenSecretManager;
    protected ApplicationTokenSecretManager appTokenSecretManager;
    private Dispatcher rmDispatcher;
    protected ResourceScheduler scheduler;
    private ClientRMService clientRM;
    protected ApplicationMasterService masterService;
    private ApplicationMasterLauncher applicationMasterLauncher;
    private AdminService adminService;
    private ContainerAllocationExpirer containerAllocationExpirer;
    protected NMLivelinessMonitor nmLivelinessMonitor;
    protected NodesListManager nodesListManager;
    private EventHandler<SchedulerEvent> schedulerDispatcher;
    protected RMAppManager rmAppManager;
    protected ApplicationACLsManager applicationACLsManager;
    protected RMDelegationTokenSecretManager rmDTSecretManager;
    private WebApp webApp;
    protected RMContext rmContext;
    protected ResourceTrackerService resourceTracker;
    private boolean recoveryEnabled;
    private Configuration conf;

    public ResourceManager() {
        super("ResourceManager");
    }

    public RMContext getRMContext() {
        return this.rmContext;
    }

    public synchronized void init(Configuration conf) {
        this.conf = conf;
        this.conf.setBoolean("yarn.dispatcher.exit-on-error", true);
        this.rmDispatcher = this.createDispatcher();
        this.addIfService(this.rmDispatcher);
        this.appTokenSecretManager = this.createApplicationTokenSecretManager(conf);
        this.containerAllocationExpirer = new ContainerAllocationExpirer(this.rmDispatcher);
        this.addService((Service)this.containerAllocationExpirer);
        AMLivelinessMonitor amLivelinessMonitor = this.createAMLivelinessMonitor();
        this.addService((Service)amLivelinessMonitor);
        AMLivelinessMonitor amFinishingMonitor = this.createAMLivelinessMonitor();
        this.addService((Service)amFinishingMonitor);
        DelegationTokenRenewer tokenRenewer = this.createDelegationTokenRenewer();
        this.addService((Service)tokenRenewer);
        this.containerTokenSecretManager = this.createContainerTokenSecretManager(conf);
        boolean isRecoveryEnabled = conf.getBoolean("yarn.resourcemanager.recovery.enabled", false);
        RMStateStore rmStore = null;
        if (isRecoveryEnabled) {
            this.recoveryEnabled = true;
            rmStore = RMStateStoreFactory.getStore(conf);
        } else {
            this.recoveryEnabled = false;
            rmStore = new NullRMStateStore();
        }
        try {
            rmStore.init(conf);
            rmStore.setDispatcher(this.rmDispatcher);
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to init state store", (Throwable)e);
            ExitUtil.terminate((int)1, (Throwable)e);
        }
        this.rmContext = new RMContextImpl(this.rmDispatcher, rmStore, this.containerAllocationExpirer, amLivelinessMonitor, amFinishingMonitor, tokenRenewer, this.appTokenSecretManager, this.containerTokenSecretManager, this.clientToAMSecretManager);
        this.nodesListManager = new NodesListManager(this.rmContext);
        this.rmDispatcher.register(NodesListManagerEventType.class, (EventHandler)this.nodesListManager);
        this.addService((Service)this.nodesListManager);
        this.scheduler = this.createScheduler();
        this.schedulerDispatcher = this.createSchedulerEventDispatcher();
        this.addIfService(this.schedulerDispatcher);
        this.rmDispatcher.register(SchedulerEventType.class, this.schedulerDispatcher);
        this.rmDispatcher.register(RMAppEventType.class, (EventHandler)new ApplicationEventDispatcher(this.rmContext));
        this.rmDispatcher.register(RMAppAttemptEventType.class, (EventHandler)new ApplicationAttemptEventDispatcher(this.rmContext));
        this.rmDispatcher.register(RMNodeEventType.class, (EventHandler)new NodeEventDispatcher(this.rmContext));
        this.nmLivelinessMonitor = this.createNMLivelinessMonitor();
        this.addService((Service)this.nmLivelinessMonitor);
        this.resourceTracker = this.createResourceTrackerService();
        this.addService((Service)this.resourceTracker);
        try {
            this.scheduler.reinitialize(conf, this.rmContext);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Failed to initialize scheduler", ioe);
        }
        this.masterService = this.createApplicationMasterService();
        this.addService((Service)this.masterService);
        this.applicationACLsManager = new ApplicationACLsManager(conf);
        this.rmAppManager = this.createRMAppManager();
        this.rmDispatcher.register(RMAppManagerEventType.class, (EventHandler)this.rmAppManager);
        this.rmDTSecretManager = this.createRMDelegationTokenSecretManager();
        this.clientRM = this.createClientRMService();
        this.addService((Service)this.clientRM);
        this.adminService = this.createAdminService(this.clientRM, this.masterService, this.resourceTracker);
        this.addService((Service)this.adminService);
        this.applicationMasterLauncher = this.createAMLauncher();
        this.rmDispatcher.register(AMLauncherEventType.class, (EventHandler)this.applicationMasterLauncher);
        this.addService((Service)this.applicationMasterLauncher);
        new RMNMInfo(this.rmContext, this.scheduler);
        super.init(conf);
    }

    @VisibleForTesting
    protected void setRMStateStore(RMStateStore rmStore) {
        rmStore.setDispatcher(this.rmDispatcher);
        ((RMContextImpl)this.rmContext).setStateStore(rmStore);
    }

    protected RMContainerTokenSecretManager createContainerTokenSecretManager(Configuration conf) {
        return new RMContainerTokenSecretManager(conf);
    }

    protected EventHandler<SchedulerEvent> createSchedulerEventDispatcher() {
        return new SchedulerEventDispatcher(this.scheduler);
    }

    protected Dispatcher createDispatcher() {
        return new AsyncDispatcher();
    }

    protected void addIfService(Object object) {
        if (object instanceof Service) {
            this.addService((Service)object);
        }
    }

    protected ApplicationTokenSecretManager createApplicationTokenSecretManager(Configuration conf) {
        return new ApplicationTokenSecretManager(conf);
    }

    protected ResourceScheduler createScheduler() {
        String schedulerClassName = this.conf.get("yarn.resourcemanager.scheduler.class", "org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler");
        LOG.info((Object)("Using Scheduler: " + schedulerClassName));
        try {
            Class<?> schedulerClazz = Class.forName(schedulerClassName);
            if (ResourceScheduler.class.isAssignableFrom(schedulerClazz)) {
                return (ResourceScheduler)ReflectionUtils.newInstance(schedulerClazz, (Configuration)this.conf);
            }
            throw new YarnException("Class: " + schedulerClassName + " not instance of " + ResourceScheduler.class.getCanonicalName());
        }
        catch (ClassNotFoundException e) {
            throw new YarnException("Could not instantiate Scheduler: " + schedulerClassName, (Throwable)e);
        }
    }

    protected ApplicationMasterLauncher createAMLauncher() {
        return new ApplicationMasterLauncher(this.rmContext);
    }

    private NMLivelinessMonitor createNMLivelinessMonitor() {
        return new NMLivelinessMonitor(this.rmContext.getDispatcher());
    }

    protected AMLivelinessMonitor createAMLivelinessMonitor() {
        return new AMLivelinessMonitor(this.rmDispatcher);
    }

    protected DelegationTokenRenewer createDelegationTokenRenewer() {
        return new DelegationTokenRenewer();
    }

    protected RMAppManager createRMAppManager() {
        return new RMAppManager(this.rmContext, this.scheduler, this.masterService, this.applicationACLsManager, this.conf);
    }

    protected void startWepApp() {
        WebApps.Builder builder = WebApps.$for((String)"cluster", ApplicationMasterService.class, (Object)((Object)this.masterService), (String)"ws").at(this.conf.get("yarn.resourcemanager.webapp.address", "0.0.0.0:8088"));
        String proxyHostAndPort = YarnConfiguration.getProxyHostAndPort((Configuration)this.conf);
        if (YarnConfiguration.getRMWebAppHostAndPort((Configuration)this.conf).equals(proxyHostAndPort)) {
            AppReportFetcher fetcher = new AppReportFetcher(this.conf, (ClientRMProtocol)this.getClientRMService());
            builder.withServlet("proxy", "/proxy/*", WebAppProxyServlet.class);
            builder.withAttribute("AppUrlFetcher", (Object)fetcher);
            String[] proxyParts = proxyHostAndPort.split(":");
            builder.withAttribute("proxyHost", (Object)proxyParts[0]);
        }
        this.webApp = builder.start((WebApp)new RMWebApp(this));
    }

    public void start() {
        try {
            this.doSecureLogin();
        }
        catch (IOException ie) {
            throw new YarnException("Failed to login", (Throwable)ie);
        }
        this.appTokenSecretManager.start();
        this.containerTokenSecretManager.start();
        if (this.recoveryEnabled) {
            try {
                RMStateStore rmStore = this.rmContext.getStateStore();
                RMStateStore.RMState state = rmStore.loadState();
                this.recover(state);
            }
            catch (Exception e) {
                LOG.error((Object)"Failed to load/recover state", (Throwable)e);
                ExitUtil.terminate((int)1, (Throwable)e);
            }
        }
        this.startWepApp();
        DefaultMetricsSystem.initialize((String)"ResourceManager");
        JvmMetrics.initSingleton((String)"ResourceManager", null);
        try {
            this.rmDTSecretManager.startThreads();
        }
        catch (IOException ie) {
            throw new YarnException("Failed to start secret manager threads", (Throwable)ie);
        }
        if (this.getConfig().getBoolean("yarn.is.minicluster", false)) {
            String hostname = this.getConfig().get("yarn.resourcemanager.webapp.address", "0.0.0.0:8088");
            hostname = hostname.contains(":") ? hostname.substring(0, hostname.indexOf(":")) : hostname;
            int port = this.webApp.port();
            String resolvedAddress = hostname + ":" + port;
            this.conf.set("yarn.resourcemanager.webapp.address", resolvedAddress);
        }
        super.start();
    }

    protected void doSecureLogin() throws IOException {
        SecurityUtil.login((Configuration)this.conf, (String)"yarn.resourcemanager.keytab", (String)"yarn.resourcemanager.principal");
    }

    public void stop() {
        if (this.webApp != null) {
            this.webApp.stop();
        }
        this.rmDTSecretManager.stopThreads();
        this.appTokenSecretManager.stop();
        this.containerTokenSecretManager.stop();
        DefaultMetricsSystem.shutdown();
        RMStateStore store = this.rmContext.getStateStore();
        try {
            store.close();
        }
        catch (Exception e) {
            LOG.error((Object)"Error closing store.", (Throwable)e);
        }
        super.stop();
    }

    protected ResourceTrackerService createResourceTrackerService() {
        return new ResourceTrackerService(this.rmContext, this.nodesListManager, this.nmLivelinessMonitor, this.containerTokenSecretManager);
    }

    protected RMDelegationTokenSecretManager createRMDelegationTokenSecretManager() {
        long secretKeyInterval = this.conf.getLong("yarn.resourcemanager.delegation.key.update-interval", 86400000L);
        long tokenMaxLifetime = this.conf.getLong("yarn.resourcemanager.delegation.token.max-lifetime", 604800000L);
        long tokenRenewInterval = this.conf.getLong("yarn.resourcemanager.delegation.token.renew-interval", 86400000L);
        return new RMDelegationTokenSecretManager(secretKeyInterval, tokenMaxLifetime, tokenRenewInterval, 3600000L);
    }

    protected ClientRMService createClientRMService() {
        return new ClientRMService(this.rmContext, this.scheduler, this.rmAppManager, this.applicationACLsManager, this.rmDTSecretManager);
    }

    protected ApplicationMasterService createApplicationMasterService() {
        return new ApplicationMasterService(this.rmContext, this.scheduler);
    }

    protected AdminService createAdminService(ClientRMService clientRMService, ApplicationMasterService applicationMasterService, ResourceTrackerService resourceTrackerService) {
        return new AdminService(this.conf, this.scheduler, this.rmContext, this.nodesListManager, clientRMService, applicationMasterService, resourceTrackerService);
    }

    @InterfaceAudience.Private
    public ClientRMService getClientRMService() {
        return this.clientRM;
    }

    @InterfaceAudience.Private
    public ResourceScheduler getResourceScheduler() {
        return this.scheduler;
    }

    @InterfaceAudience.Private
    public ResourceTrackerService getResourceTrackerService() {
        return this.resourceTracker;
    }

    @InterfaceAudience.Private
    public ApplicationMasterService getApplicationMasterService() {
        return this.masterService;
    }

    @InterfaceAudience.Private
    public ApplicationACLsManager getApplicationACLsManager() {
        return this.applicationACLsManager;
    }

    @InterfaceAudience.Private
    public RMContainerTokenSecretManager getRMContainerTokenSecretManager() {
        return this.containerTokenSecretManager;
    }

    @InterfaceAudience.Private
    public ApplicationTokenSecretManager getApplicationTokenSecretManager() {
        return this.appTokenSecretManager;
    }

    @Override
    public void recover(RMStateStore.RMState state) throws Exception {
        this.rmAppManager.recover(state);
    }

    public static void main(String[] argv) {
        Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new YarnUncaughtExceptionHandler());
        StringUtils.startupShutdownMessage(ResourceManager.class, (String[])argv, (Log)LOG);
        try {
            YarnConfiguration conf = new YarnConfiguration();
            ResourceManager resourceManager = new ResourceManager();
            ShutdownHookManager.get().addShutdownHook((Runnable)new CompositeService.CompositeServiceShutdownHook((CompositeService)resourceManager), 30);
            resourceManager.init((Configuration)conf);
            resourceManager.start();
        }
        catch (Throwable t) {
            LOG.fatal((Object)"Error starting ResourceManager", t);
            System.exit(-1);
        }
    }

    @InterfaceAudience.Private
    public static final class NodeEventDispatcher
    implements EventHandler<RMNodeEvent> {
        private final RMContext rmContext;

        public NodeEventDispatcher(RMContext rmContext) {
            this.rmContext = rmContext;
        }

        public void handle(RMNodeEvent event) {
            NodeId nodeId = event.getNodeId();
            RMNode node = (RMNode)this.rmContext.getRMNodes().get(nodeId);
            if (node != null) {
                try {
                    ((EventHandler)node).handle((Event)event);
                }
                catch (Throwable t) {
                    LOG.error((Object)("Error in handling event type " + event.getType() + " for node " + nodeId), t);
                }
            }
        }
    }

    @InterfaceAudience.Private
    public static final class ApplicationAttemptEventDispatcher
    implements EventHandler<RMAppAttemptEvent> {
        private final RMContext rmContext;

        public ApplicationAttemptEventDispatcher(RMContext rmContext) {
            this.rmContext = rmContext;
        }

        public void handle(RMAppAttemptEvent event) {
            RMAppAttempt rmAppAttempt;
            ApplicationAttemptId appAttemptID = event.getApplicationAttemptId();
            ApplicationId appAttemptId = appAttemptID.getApplicationId();
            RMApp rmApp = (RMApp)this.rmContext.getRMApps().get(appAttemptId);
            if (rmApp != null && (rmAppAttempt = rmApp.getRMAppAttempt(appAttemptID)) != null) {
                try {
                    rmAppAttempt.handle((Event)event);
                }
                catch (Throwable t) {
                    LOG.error((Object)("Error in handling event type " + event.getType() + " for applicationAttempt " + appAttemptId), t);
                }
            }
        }
    }

    @InterfaceAudience.Private
    public static final class ApplicationEventDispatcher
    implements EventHandler<RMAppEvent> {
        private final RMContext rmContext;

        public ApplicationEventDispatcher(RMContext rmContext) {
            this.rmContext = rmContext;
        }

        public void handle(RMAppEvent event) {
            ApplicationId appID = event.getApplicationId();
            RMApp rmApp = (RMApp)this.rmContext.getRMApps().get(appID);
            if (rmApp != null) {
                try {
                    rmApp.handle((Event)event);
                }
                catch (Throwable t) {
                    LOG.error((Object)("Error in handling event type " + event.getType() + " for application " + appID), t);
                }
            }
        }
    }

    @InterfaceAudience.Private
    public static class SchedulerEventDispatcher
    extends AbstractService
    implements EventHandler<SchedulerEvent> {
        private final ResourceScheduler scheduler;
        private final BlockingQueue<SchedulerEvent> eventQueue = new LinkedBlockingQueue<SchedulerEvent>();
        private final Thread eventProcessor;
        private volatile boolean stopped = false;
        private boolean shouldExitOnError = false;

        public SchedulerEventDispatcher(ResourceScheduler scheduler) {
            super(SchedulerEventDispatcher.class.getName());
            this.scheduler = scheduler;
            this.eventProcessor = new Thread(new EventProcessor());
            this.eventProcessor.setName("ResourceManager Event Processor");
        }

        public synchronized void init(Configuration conf) {
            this.shouldExitOnError = conf.getBoolean("yarn.dispatcher.exit-on-error", false);
            super.init(conf);
        }

        public synchronized void start() {
            this.eventProcessor.start();
            super.start();
        }

        public synchronized void stop() {
            this.stopped = true;
            this.eventProcessor.interrupt();
            try {
                this.eventProcessor.join();
            }
            catch (InterruptedException e) {
                throw new YarnException((Throwable)e);
            }
            super.stop();
        }

        public void handle(SchedulerEvent event) {
            try {
                int remCapacity;
                int qSize = this.eventQueue.size();
                if (qSize != 0 && qSize % 1000 == 0) {
                    LOG.info((Object)("Size of scheduler event-queue is " + qSize));
                }
                if ((remCapacity = this.eventQueue.remainingCapacity()) < 1000) {
                    LOG.info((Object)("Very low remaining capacity on scheduler event queue: " + remCapacity));
                }
                this.eventQueue.put(event);
            }
            catch (InterruptedException e) {
                throw new YarnException((Throwable)e);
            }
        }

        private final class EventProcessor
        implements Runnable {
            private EventProcessor() {
            }

            @Override
            public void run() {
                while (!SchedulerEventDispatcher.this.stopped && !Thread.currentThread().isInterrupted()) {
                    SchedulerEvent event;
                    try {
                        event = (SchedulerEvent)((Object)SchedulerEventDispatcher.this.eventQueue.take());
                    }
                    catch (InterruptedException e) {
                        LOG.error((Object)("Returning, interrupted : " + e));
                        return;
                    }
                    try {
                        SchedulerEventDispatcher.this.scheduler.handle((Event)event);
                    }
                    catch (Throwable t) {
                        if (SchedulerEventDispatcher.this.stopped) {
                            LOG.warn((Object)"Exception during shutdown: ", t);
                            break;
                        }
                        LOG.fatal((Object)("Error in handling event type " + event.getType() + " to the scheduler"), t);
                        if (!SchedulerEventDispatcher.this.shouldExitOnError || ShutdownHookManager.get().isShutdownInProgress()) continue;
                        LOG.info((Object)"Exiting, bbye..");
                        System.exit(-1);
                    }
                }
            }
        }
    }
}

