/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.recovery;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.impl.pb.ApplicationAttemptStateDataPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ApplicationStateDataPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ApplicationSubmissionContextPBImpl;
import org.apache.hadoop.yarn.event.AsyncDispatcher;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStoreAppAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStoreEvent;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStoreEventType;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStoreRemoveAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.event.RMAppAttemptStoredEvent;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public abstract class RMStateStore {
    public static final Log LOG = LogFactory.getLog(RMStateStore.class);
    private Dispatcher rmDispatcher;
    AsyncDispatcher dispatcher;

    public void setDispatcher(Dispatcher dispatcher) {
        this.rmDispatcher = dispatcher;
    }

    public synchronized void init(Configuration conf) throws Exception {
        this.dispatcher = new AsyncDispatcher();
        this.dispatcher.init(conf);
        this.dispatcher.register(RMStateStoreEventType.class, (EventHandler)new ForwardingEventHandler());
        this.dispatcher.start();
        this.initInternal(conf);
    }

    protected abstract void initInternal(Configuration var1) throws Exception;

    public synchronized void close() throws Exception {
        this.closeInternal();
        this.dispatcher.stop();
    }

    protected abstract void closeInternal() throws Exception;

    public abstract RMState loadState() throws Exception;

    public synchronized void storeApplication(RMApp app) throws Exception {
        ApplicationSubmissionContext context = app.getApplicationSubmissionContext();
        assert (context instanceof ApplicationSubmissionContextPBImpl);
        ApplicationStateDataPBImpl appStateData = new ApplicationStateDataPBImpl();
        appStateData.setSubmitTime(app.getSubmitTime());
        appStateData.setApplicationSubmissionContext(context);
        LOG.info((Object)("Storing info for app: " + context.getApplicationId()));
        this.storeApplicationState(app.getApplicationId().toString(), appStateData);
    }

    protected abstract void storeApplicationState(String var1, ApplicationStateDataPBImpl var2) throws Exception;

    public synchronized void storeApplicationAttempt(RMAppAttempt appAttempt) {
        ApplicationAttemptState attemptState = new ApplicationAttemptState(appAttempt.getAppAttemptId(), appAttempt.getMasterContainer());
        this.dispatcher.getEventHandler().handle((Event)new RMStateStoreAppAttemptEvent(attemptState));
    }

    protected abstract void storeApplicationAttemptState(String var1, ApplicationAttemptStateDataPBImpl var2) throws Exception;

    public synchronized void removeApplication(RMApp app) {
        ApplicationState appState = new ApplicationState(app.getSubmitTime(), app.getApplicationSubmissionContext());
        for (RMAppAttempt appAttempt : app.getAppAttempts().values()) {
            ApplicationAttemptState attemptState = new ApplicationAttemptState(appAttempt.getAppAttemptId(), appAttempt.getMasterContainer());
            appState.attempts.put(attemptState.getAttemptId(), attemptState);
        }
        this.removeApplication(appState);
    }

    public synchronized void removeApplication(ApplicationState appState) {
        this.dispatcher.getEventHandler().handle((Event)new RMStateStoreRemoveAppEvent(appState));
    }

    protected abstract void removeApplicationState(ApplicationState var1) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void handleStoreEvent(RMStateStoreEvent event) {
        switch ((RMStateStoreEventType)event.getType()) {
            case STORE_APP_ATTEMPT: {
                ApplicationAttemptState attemptState = ((RMStateStoreAppAttemptEvent)event).getAppAttemptState();
                Exception storedException = null;
                ApplicationAttemptStateDataPBImpl attemptStateData = new ApplicationAttemptStateDataPBImpl();
                attemptStateData.setAttemptId(attemptState.getAttemptId());
                attemptStateData.setMasterContainer(attemptState.getMasterContainer());
                LOG.info((Object)("Storing info for attempt: " + attemptState.getAttemptId()));
                try {
                    this.storeApplicationAttemptState(attemptState.getAttemptId().toString(), attemptStateData);
                    this.notifyDoneStoringApplicationAttempt(attemptState.getAttemptId(), storedException);
                    break;
                }
                catch (Exception e) {
                    try {
                        LOG.error((Object)("Error storing appAttempt: " + attemptState.getAttemptId()), (Throwable)e);
                        storedException = e;
                        this.notifyDoneStoringApplicationAttempt(attemptState.getAttemptId(), storedException);
                        break;
                    }
                    catch (Throwable throwable) {
                        this.notifyDoneStoringApplicationAttempt(attemptState.getAttemptId(), storedException);
                        throw throwable;
                    }
                }
            }
            case REMOVE_APP: {
                ApplicationState appState = ((RMStateStoreRemoveAppEvent)event).getAppState();
                ApplicationId appId = appState.getAppId();
                LOG.info((Object)("Removing info for app: " + appId));
                try {
                    this.removeApplicationState(appState);
                }
                catch (Exception e) {
                    LOG.error((Object)("Error removing app: " + appId), (Throwable)e);
                }
                break;
            }
            default: {
                LOG.error((Object)("Unknown RMStateStoreEvent type: " + event.getType()));
            }
        }
    }

    private void notifyDoneStoringApplicationAttempt(ApplicationAttemptId attemptId, Exception storedException) {
        this.rmDispatcher.getEventHandler().handle((Event)new RMAppAttemptStoredEvent(attemptId, storedException));
    }

    private final class ForwardingEventHandler
    implements EventHandler<RMStateStoreEvent> {
        private ForwardingEventHandler() {
        }

        public void handle(RMStateStoreEvent event) {
            RMStateStore.this.handleStoreEvent(event);
        }
    }

    public static class RMState {
        Map<ApplicationId, ApplicationState> appState = new HashMap<ApplicationId, ApplicationState>();

        public Map<ApplicationId, ApplicationState> getApplicationState() {
            return this.appState;
        }
    }

    public static class ApplicationState {
        final ApplicationSubmissionContext context;
        final long submitTime;
        Map<ApplicationAttemptId, ApplicationAttemptState> attempts = new HashMap<ApplicationAttemptId, ApplicationAttemptState>();

        ApplicationState(long submitTime, ApplicationSubmissionContext context) {
            this.submitTime = submitTime;
            this.context = context;
        }

        public ApplicationId getAppId() {
            return this.context.getApplicationId();
        }

        public long getSubmitTime() {
            return this.submitTime;
        }

        public int getAttemptCount() {
            return this.attempts.size();
        }

        public ApplicationSubmissionContext getApplicationSubmissionContext() {
            return this.context;
        }

        public ApplicationAttemptState getAttempt(ApplicationAttemptId attemptId) {
            return this.attempts.get(attemptId);
        }
    }

    public static class ApplicationAttemptState {
        final ApplicationAttemptId attemptId;
        final Container masterContainer;

        public ApplicationAttemptState(ApplicationAttemptId attemptId, Container masterContainer) {
            this.attemptId = attemptId;
            this.masterContainer = masterContainer;
        }

        public Container getMasterContainer() {
            return this.masterContainer;
        }

        public ApplicationAttemptId getAttemptId() {
            return this.attemptId;
        }
    }
}

