/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.server.resourcemanager.resource.Priority;
import org.apache.hadoop.yarn.server.resourcemanager.resource.Resources;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ActiveUsersManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.NodeType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Queue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class AppSchedulingInfo {
    private static final Log LOG = LogFactory.getLog(AppSchedulingInfo.class);
    private final ApplicationAttemptId applicationAttemptId;
    final ApplicationId applicationId;
    private final String queueName;
    Queue queue;
    final String user;
    private final AtomicInteger containerIdCounter = new AtomicInteger(0);
    final Set<Priority> priorities = new TreeSet<Priority>(new Priority.Comparator());
    final Map<Priority, Map<String, ResourceRequest>> requests = new HashMap<Priority, Map<String, ResourceRequest>>();
    private final ActiveUsersManager activeUsersManager;
    boolean pending = true;

    public AppSchedulingInfo(ApplicationAttemptId appAttemptId, String user, Queue queue, ActiveUsersManager activeUsersManager) {
        this.applicationAttemptId = appAttemptId;
        this.applicationId = appAttemptId.getApplicationId();
        this.queue = queue;
        this.queueName = queue.getQueueName();
        this.user = user;
        this.activeUsersManager = activeUsersManager;
    }

    public ApplicationId getApplicationId() {
        return this.applicationId;
    }

    public ApplicationAttemptId getApplicationAttemptId() {
        return this.applicationAttemptId;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public String getUser() {
        return this.user;
    }

    public synchronized boolean isPending() {
        return this.pending;
    }

    private synchronized void clearRequests() {
        this.priorities.clear();
        this.requests.clear();
        LOG.info((Object)("Application " + this.applicationId + " requests cleared"));
    }

    public int getNewContainerId() {
        return this.containerIdCounter.incrementAndGet();
    }

    public synchronized void updateResourceRequests(List<ResourceRequest> requests) {
        QueueMetrics metrics = this.queue.getMetrics();
        for (ResourceRequest request : requests) {
            Map<String, ResourceRequest> asks;
            Priority priority = request.getPriority();
            String hostName = request.getHostName();
            boolean updatePendingResources = false;
            ResourceRequest lastRequest = null;
            if (hostName.equals("*")) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("update: application=" + this.applicationId + " request=" + request));
                }
                updatePendingResources = true;
                if (request.getNumContainers() > 0) {
                    this.activeUsersManager.activateApplication(this.user, this.applicationId);
                }
            }
            if ((asks = this.requests.get(priority)) == null) {
                asks = new HashMap<String, ResourceRequest>();
                this.requests.put(priority, asks);
                this.priorities.add(priority);
            } else if (updatePendingResources) {
                lastRequest = asks.get(hostName);
            }
            asks.put(hostName, request);
            if (!updatePendingResources) continue;
            if (request.getNumContainers() <= 0) {
                LOG.info((Object)"checking for deactivate... ");
                this.checkForDeactivation();
            }
            int lastRequestContainers = lastRequest != null ? lastRequest.getNumContainers() : 0;
            Resource lastRequestCapability = lastRequest != null ? lastRequest.getCapability() : Resources.none();
            metrics.incrPendingResources(this.user, request.getNumContainers() - lastRequestContainers, Resources.subtractFrom(Resources.multiply(request.getCapability(), request.getNumContainers()), Resources.multiply(lastRequestCapability, lastRequestContainers)));
        }
    }

    public synchronized Collection<Priority> getPriorities() {
        return this.priorities;
    }

    public synchronized Map<String, ResourceRequest> getResourceRequests(Priority priority) {
        return this.requests.get(priority);
    }

    public synchronized ResourceRequest getResourceRequest(Priority priority, String nodeAddress) {
        Map<String, ResourceRequest> nodeRequests = this.requests.get(priority);
        return nodeRequests == null ? null : nodeRequests.get(nodeAddress);
    }

    public synchronized Resource getResource(Priority priority) {
        ResourceRequest request = this.getResourceRequest(priority, "*");
        return request.getCapability();
    }

    public synchronized void allocate(NodeType type, SchedulerNode node, Priority priority, ResourceRequest request, Container container) {
        if (type == NodeType.NODE_LOCAL) {
            this.allocateNodeLocal(node, priority, request, container);
        } else if (type == NodeType.RACK_LOCAL) {
            this.allocateRackLocal(node, priority, request, container);
        } else {
            this.allocateOffSwitch(node, priority, request, container);
        }
        QueueMetrics metrics = this.queue.getMetrics();
        if (this.pending) {
            this.pending = false;
            metrics.incrAppsRunning(this, this.user);
        }
        LOG.debug((Object)("allocate: user: " + this.user + ", memory: " + request.getCapability()));
        metrics.allocateResources(this.user, 1, request.getCapability());
    }

    private synchronized void allocateNodeLocal(SchedulerNode node, Priority priority, ResourceRequest nodeLocalRequest, Container container) {
        this.allocate(container);
        nodeLocalRequest.setNumContainers(nodeLocalRequest.getNumContainers() - 1);
        if (nodeLocalRequest.getNumContainers() == 0) {
            this.requests.get(priority).remove(node.getHostName());
        }
        ResourceRequest rackLocalRequest = this.requests.get(priority).get(node.getRackName());
        rackLocalRequest.setNumContainers(rackLocalRequest.getNumContainers() - 1);
        if (rackLocalRequest.getNumContainers() == 0) {
            this.requests.get(priority).remove(node.getRackName());
        }
        this.decrementOutstanding(this.requests.get(priority).get("*"));
    }

    private synchronized void allocateRackLocal(SchedulerNode node, Priority priority, ResourceRequest rackLocalRequest, Container container) {
        this.allocate(container);
        rackLocalRequest.setNumContainers(rackLocalRequest.getNumContainers() - 1);
        if (rackLocalRequest.getNumContainers() == 0) {
            this.requests.get(priority).remove(node.getRackName());
        }
        this.decrementOutstanding(this.requests.get(priority).get("*"));
    }

    private synchronized void allocateOffSwitch(SchedulerNode node, Priority priority, ResourceRequest offSwitchRequest, Container container) {
        this.allocate(container);
        this.decrementOutstanding(offSwitchRequest);
    }

    private synchronized void decrementOutstanding(ResourceRequest offSwitchRequest) {
        int numOffSwitchContainers = offSwitchRequest.getNumContainers() - 1;
        offSwitchRequest.setNumContainers(numOffSwitchContainers);
        if (numOffSwitchContainers == 0) {
            this.checkForDeactivation();
        }
    }

    private synchronized void checkForDeactivation() {
        boolean deactivate = true;
        for (Priority priority : this.getPriorities()) {
            ResourceRequest request = this.getResourceRequest(priority, "*");
            if (request.getNumContainers() <= 0) continue;
            deactivate = false;
            break;
        }
        if (deactivate) {
            this.activeUsersManager.deactivateApplication(this.user, this.applicationId);
        }
    }

    private synchronized void allocate(Container container) {
        LOG.debug((Object)("allocate: applicationId=" + this.applicationId + " container=" + container.getId() + " host=" + container.getNodeId().toString()));
    }

    public synchronized void stop(RMAppAttemptState rmAppAttemptFinalState) {
        QueueMetrics metrics = this.queue.getMetrics();
        for (Map<String, ResourceRequest> asks : this.requests.values()) {
            ResourceRequest request = asks.get("*");
            if (request == null) continue;
            metrics.decrPendingResources(this.user, request.getNumContainers(), Resources.multiply(request.getCapability(), request.getNumContainers()));
        }
        metrics.finishApp(this, rmAppAttemptFinalState);
        this.clearRequests();
    }

    public synchronized void setQueue(Queue queue) {
        this.queue = queue;
    }
}

