/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.QueueState;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Queue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.QueueManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.Schedulable;

public abstract class FSQueue
extends Schedulable
implements Queue {
    private final String name;
    private final QueueManager queueMgr;
    private final FairScheduler scheduler;
    private final QueueMetrics metrics;
    protected final FSParentQueue parent;
    protected final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);

    public FSQueue(String name, QueueManager queueMgr, FairScheduler scheduler, FSParentQueue parent) {
        this.name = name;
        this.queueMgr = queueMgr;
        this.scheduler = scheduler;
        this.metrics = QueueMetrics.forQueue(this.getName(), parent, true, scheduler.getConf());
        this.parent = parent;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getQueueName() {
        return this.name;
    }

    @Override
    public double getWeight() {
        return this.queueMgr.getQueueWeight(this.getName());
    }

    @Override
    public Resource getMinShare() {
        return this.queueMgr.getMinResources(this.getName());
    }

    @Override
    public long getStartTime() {
        return 0L;
    }

    @Override
    public Priority getPriority() {
        Priority p = (Priority)this.recordFactory.newRecordInstance(Priority.class);
        p.setPriority(1);
        return p;
    }

    @Override
    public QueueInfo getQueueInfo(boolean includeChildQueues, boolean recursive) {
        QueueInfo queueInfo = (QueueInfo)this.recordFactory.newRecordInstance(QueueInfo.class);
        queueInfo.setQueueName(this.getQueueName());
        queueInfo.setCapacity((float)this.getFairShare().getMemory() / (float)this.scheduler.getClusterCapacity().getMemory());
        queueInfo.setCapacity((float)this.getResourceUsage().getMemory() / (float)this.scheduler.getClusterCapacity().getMemory());
        ArrayList<QueueInfo> childQueueInfos = new ArrayList<QueueInfo>();
        if (includeChildQueues) {
            Collection<FSQueue> childQueues = this.getChildQueues();
            for (FSQueue child : childQueues) {
                childQueueInfos.add(child.getQueueInfo(recursive, recursive));
            }
        }
        queueInfo.setChildQueues(childQueueInfos);
        queueInfo.setQueueState(QueueState.RUNNING);
        return queueInfo;
    }

    @Override
    public Map<QueueACL, AccessControlList> getQueueAcls() {
        Map<QueueACL, AccessControlList> acls = this.queueMgr.getQueueAcls(this.getName());
        return new HashMap<QueueACL, AccessControlList>(acls);
    }

    @Override
    public QueueMetrics getMetrics() {
        return this.metrics;
    }

    public boolean hasAccess(QueueACL acl, UserGroupInformation user) {
        if (this.queueMgr.getQueueAcls(this.getName()).get(acl).isUserAllowed(user)) {
            return true;
        }
        return this.parent != null && this.parent.hasAccess(acl, user);
    }

    public abstract void recomputeFairShares();

    public abstract Collection<FSQueue> getChildQueues();
}

