/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.util.Records;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class Resources {
    private static final Resource NONE = new Resource(){

        public int getMemory() {
            return 0;
        }

        public void setMemory(int memory) {
            throw new RuntimeException("NONE cannot be modified!");
        }

        public int getVirtualCores() {
            return 0;
        }

        public void setVirtualCores(int cores) {
            throw new RuntimeException("NONE cannot be modified!");
        }

        public int compareTo(Resource o) {
            int diff = 0 - o.getMemory();
            if (diff == 0) {
                diff = 0 - o.getVirtualCores();
            }
            return diff;
        }
    };

    public static Resource createResource(int memory) {
        return Resources.createResource(memory, memory > 0 ? 1 : 0);
    }

    public static Resource createResource(int memory, int cores) {
        Resource resource = (Resource)Records.newRecord(Resource.class);
        resource.setMemory(memory);
        resource.setVirtualCores(cores);
        return resource;
    }

    public static Resource none() {
        return NONE;
    }

    public static Resource clone(Resource res) {
        return Resources.createResource(res.getMemory(), res.getVirtualCores());
    }

    public static Resource addTo(Resource lhs, Resource rhs) {
        lhs.setMemory(lhs.getMemory() + rhs.getMemory());
        return lhs;
    }

    public static Resource add(Resource lhs, Resource rhs) {
        return Resources.addTo(Resources.clone(lhs), rhs);
    }

    public static Resource subtractFrom(Resource lhs, Resource rhs) {
        lhs.setMemory(lhs.getMemory() - rhs.getMemory());
        return lhs;
    }

    public static Resource subtract(Resource lhs, Resource rhs) {
        return Resources.subtractFrom(Resources.clone(lhs), rhs);
    }

    public static Resource negate(Resource resource) {
        return Resources.subtract(NONE, resource);
    }

    public static Resource multiplyTo(Resource lhs, int by) {
        lhs.setMemory(lhs.getMemory() * by);
        return lhs;
    }

    public static Resource multiply(Resource lhs, int by) {
        return Resources.multiplyTo(Resources.clone(lhs), by);
    }

    public static Resource multiply(Resource lhs, double by) {
        Resource out = Resources.clone(lhs);
        out.setMemory((int)((double)lhs.getMemory() * by));
        return out;
    }

    public static boolean equals(Resource lhs, Resource rhs) {
        return lhs.getMemory() == rhs.getMemory();
    }

    public static boolean lessThan(Resource lhs, Resource rhs) {
        return lhs.getMemory() < rhs.getMemory();
    }

    public static boolean lessThanOrEqual(Resource lhs, Resource rhs) {
        return lhs.getMemory() <= rhs.getMemory();
    }

    public static boolean greaterThan(Resource lhs, Resource rhs) {
        return lhs.getMemory() > rhs.getMemory();
    }

    public static boolean greaterThanOrEqual(Resource lhs, Resource rhs) {
        return lhs.getMemory() >= rhs.getMemory();
    }

    public static Resource min(Resource lhs, Resource rhs) {
        return lhs.getMemory() < rhs.getMemory() ? lhs : rhs;
    }

    public static Resource max(Resource lhs, Resource rhs) {
        return lhs.getMemory() > rhs.getMemory() ? lhs : rhs;
    }
}

