/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.Resources;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.Schedulable;

@InterfaceAudience.Private
@InterfaceStability.Unstable
class SchedulingAlgorithms {
    public static final Log LOG = LogFactory.getLog((String)SchedulingAlgorithms.class.getName());
    private static final int COMPUTE_FAIR_SHARES_ITERATIONS = 25;

    SchedulingAlgorithms() {
    }

    public static void computeFairShares(Collection<? extends Schedulable> schedulables, Resource totalResources) {
        Resource totalDemand = Resources.createResource(0);
        for (Schedulable schedulable : schedulables) {
            Resources.addTo(totalDemand, schedulable.getDemand());
        }
        Resource cap = Resources.min(totalDemand, totalResources);
        double d = 1.0;
        while (Resources.lessThan(SchedulingAlgorithms.resUsedWithWeightToResRatio(d, schedulables), cap)) {
            d *= 2.0;
        }
        double left = 0.0;
        double right = d;
        for (int i = 0; i < 25; ++i) {
            double d2 = (left + right) / 2.0;
            if (Resources.lessThan(SchedulingAlgorithms.resUsedWithWeightToResRatio(d2, schedulables), cap)) {
                left = d2;
                continue;
            }
            right = d2;
        }
        for (Schedulable schedulable : schedulables) {
            schedulable.setFairShare(SchedulingAlgorithms.computeShare(schedulable, right));
        }
    }

    private static Resource resUsedWithWeightToResRatio(double w2sRatio, Collection<? extends Schedulable> schedulables) {
        Resource slotsTaken = Resources.createResource(0);
        for (Schedulable schedulable : schedulables) {
            Resource share = SchedulingAlgorithms.computeShare(schedulable, w2sRatio);
            Resources.addTo(slotsTaken, share);
        }
        return slotsTaken;
    }

    private static Resource computeShare(Schedulable sched, double r2sRatio) {
        double share = sched.getWeight() * r2sRatio;
        share = Math.max(share, (double)sched.getMinShare().getMemory());
        share = Math.min(share, (double)sched.getDemand().getMemory());
        return Resources.createResource((int)share);
    }

    public static class FairShareComparator
    implements Comparator<Schedulable>,
    Serializable {
        private static final long serialVersionUID = 5564969375856699313L;

        @Override
        public int compare(Schedulable s1, Schedulable s2) {
            Resource minShare1 = Resources.min(s1.getMinShare(), s1.getDemand());
            Resource minShare2 = Resources.min(s2.getMinShare(), s2.getDemand());
            boolean s1Needy = Resources.lessThan(s1.getResourceUsage(), minShare1);
            boolean s2Needy = Resources.lessThan(s2.getResourceUsage(), minShare2);
            Resource one = Resources.createResource(1);
            double minShareRatio1 = (double)s1.getResourceUsage().getMemory() / (double)Resources.max(minShare1, one).getMemory();
            double minShareRatio2 = (double)s2.getResourceUsage().getMemory() / (double)Resources.max(minShare2, one).getMemory();
            double useToWeightRatio1 = (double)s1.getResourceUsage().getMemory() / s1.getWeight();
            double useToWeightRatio2 = (double)s2.getResourceUsage().getMemory() / s2.getWeight();
            int res = 0;
            res = s1Needy && !s2Needy ? -1 : (s2Needy && !s1Needy ? 1 : (s1Needy && s2Needy ? (int)Math.signum(minShareRatio1 - minShareRatio2) : (int)Math.signum(useToWeightRatio1 - useToWeightRatio2)));
            if (res == 0 && (res = (int)Math.signum(s1.getStartTime() - s2.getStartTime())) == 0) {
                res = s1.getName().compareTo(s2.getName());
            }
            return res;
        }
    }

    public static class FifoComparator
    implements Comparator<Schedulable>,
    Serializable {
        private static final long serialVersionUID = -5905036205491177060L;

        @Override
        public int compare(Schedulable s1, Schedulable s2) {
            int res = s1.getPriority().compareTo(s2.getPriority());
            if (res == 0) {
                res = (int)Math.signum(s1.getStartTime() - s2.getStartTime());
            }
            if (res == 0) {
                res = s1.getName().compareTo(s2.getName());
            }
            return res;
        }
    }
}

