/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.recovery.records.impl.pb;

import java.nio.ByteBuffer;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ProtoBase;
import org.apache.hadoop.yarn.api.records.impl.pb.ApplicationAttemptIdPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ContainerPBImpl;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.proto.YarnServerResourceManagerServiceProtos;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.ApplicationAttemptStateData;

public class ApplicationAttemptStateDataPBImpl
extends ProtoBase<YarnServerResourceManagerServiceProtos.ApplicationAttemptStateDataProto>
implements ApplicationAttemptStateData {
    private static final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    YarnServerResourceManagerServiceProtos.ApplicationAttemptStateDataProto proto = YarnServerResourceManagerServiceProtos.ApplicationAttemptStateDataProto.getDefaultInstance();
    YarnServerResourceManagerServiceProtos.ApplicationAttemptStateDataProto.Builder builder = null;
    boolean viaProto = false;
    private ApplicationAttemptId attemptId = null;
    private Container masterContainer = null;
    private ByteBuffer appAttemptTokens = null;

    public ApplicationAttemptStateDataPBImpl() {
        this.builder = YarnServerResourceManagerServiceProtos.ApplicationAttemptStateDataProto.newBuilder();
    }

    public ApplicationAttemptStateDataPBImpl(YarnServerResourceManagerServiceProtos.ApplicationAttemptStateDataProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    public YarnServerResourceManagerServiceProtos.ApplicationAttemptStateDataProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    private void mergeLocalToBuilder() {
        if (this.attemptId != null) {
            this.builder.setAttemptId(((ApplicationAttemptIdPBImpl)this.attemptId).getProto());
        }
        if (this.masterContainer != null) {
            this.builder.setMasterContainer(((ContainerPBImpl)this.masterContainer).getProto());
        }
        if (this.appAttemptTokens != null) {
            this.builder.setAppAttemptTokens(this.convertToProtoFormat(this.appAttemptTokens));
        }
    }

    private void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnServerResourceManagerServiceProtos.ApplicationAttemptStateDataProto.newBuilder((YarnServerResourceManagerServiceProtos.ApplicationAttemptStateDataProto)this.proto);
        }
        this.viaProto = false;
    }

    @Override
    public ApplicationAttemptId getAttemptId() {
        YarnServerResourceManagerServiceProtos.ApplicationAttemptStateDataProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (this.attemptId != null) {
            return this.attemptId;
        }
        if (!p.hasAttemptId()) {
            return null;
        }
        this.attemptId = new ApplicationAttemptIdPBImpl(p.getAttemptId());
        return this.attemptId;
    }

    @Override
    public void setAttemptId(ApplicationAttemptId attemptId) {
        this.maybeInitBuilder();
        if (attemptId == null) {
            this.builder.clearAttemptId();
        }
        this.attemptId = attemptId;
    }

    @Override
    public Container getMasterContainer() {
        YarnServerResourceManagerServiceProtos.ApplicationAttemptStateDataProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (this.masterContainer != null) {
            return this.masterContainer;
        }
        if (!p.hasMasterContainer()) {
            return null;
        }
        this.masterContainer = new ContainerPBImpl(p.getMasterContainer());
        return this.masterContainer;
    }

    @Override
    public void setMasterContainer(Container container) {
        this.maybeInitBuilder();
        if (container == null) {
            this.builder.clearMasterContainer();
        }
        this.masterContainer = container;
    }

    @Override
    public ByteBuffer getAppAttemptTokens() {
        YarnServerResourceManagerServiceProtos.ApplicationAttemptStateDataProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (this.appAttemptTokens != null) {
            return this.appAttemptTokens;
        }
        if (!p.hasAppAttemptTokens()) {
            return null;
        }
        this.appAttemptTokens = this.convertFromProtoFormat(p.getAppAttemptTokens());
        return this.appAttemptTokens;
    }

    @Override
    public void setAppAttemptTokens(ByteBuffer attemptTokens) {
        this.maybeInitBuilder();
        if (attemptTokens == null) {
            this.builder.clearAppAttemptTokens();
        }
        this.appAttemptTokens = attemptTokens;
    }

    public static ApplicationAttemptStateData newApplicationAttemptStateData(ApplicationAttemptId attemptId, Container container, ByteBuffer attemptTokens) {
        ApplicationAttemptStateData attemptStateData = (ApplicationAttemptStateData)recordFactory.newRecordInstance(ApplicationAttemptStateData.class);
        attemptStateData.setAttemptId(attemptId);
        attemptStateData.setMasterContainer(container);
        attemptStateData.setAppAttemptTokens(attemptTokens);
        return attemptStateData;
    }
}

