/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.Lock;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.QueueUserACLInfo;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.server.resourcemanager.RMAuditLogger;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.resource.ResourceCalculator;
import org.apache.hadoop.yarn.server.resourcemanager.resource.Resources;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.event.RMAppAttemptRejectedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeCleanContainerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.UpdatedContainerInfo;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Allocation;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerAppReport;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNodeReport;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSAssignment;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.ContainerExpiredSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeUpdateSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMContainerTokenSecretManager;

@InterfaceAudience.LimitedPrivate(value={"yarn"})
@InterfaceStability.Evolving
public class CapacityScheduler
implements ResourceScheduler,
CapacitySchedulerContext,
Configurable {
    private static final Log LOG = LogFactory.getLog(CapacityScheduler.class);
    private CSQueue root;
    private static final List<Container> EMPTY_CONTAINER_LIST = new ArrayList<Container>();
    static final Comparator<CSQueue> queueComparator = new Comparator<CSQueue>(){

        @Override
        public int compare(CSQueue q1, CSQueue q2) {
            if (q1.getUsedCapacity() < q2.getUsedCapacity()) {
                return -1;
            }
            if (q1.getUsedCapacity() > q2.getUsedCapacity()) {
                return 1;
            }
            return q1.getQueuePath().compareTo(q2.getQueuePath());
        }
    };
    static final Comparator<FiCaSchedulerApp> applicationComparator = new Comparator<FiCaSchedulerApp>(){

        @Override
        public int compare(FiCaSchedulerApp a1, FiCaSchedulerApp a2) {
            return a1.getApplicationId().compareTo(a2.getApplicationId());
        }
    };
    private CapacitySchedulerConfiguration conf;
    private Configuration yarnConf;
    private RMContext rmContext;
    private Map<String, CSQueue> queues = new ConcurrentHashMap<String, CSQueue>();
    private Map<NodeId, FiCaSchedulerNode> nodes = new ConcurrentHashMap<NodeId, FiCaSchedulerNode>();
    private Resource clusterResource = (Resource)RecordFactoryProvider.getRecordFactory(null).newRecordInstance(Resource.class);
    private int numNodeManagers = 0;
    private Resource minimumAllocation;
    private Resource maximumAllocation;
    private Map<ApplicationAttemptId, FiCaSchedulerApp> applications = new ConcurrentHashMap<ApplicationAttemptId, FiCaSchedulerApp>();
    private boolean initialized = false;
    private ResourceCalculator calculator;
    @InterfaceAudience.Private
    public static final String ROOT_QUEUE = "yarn.scheduler.capacity.root";
    private static final QueueHook noop = new QueueHook();
    private static final Allocation EMPTY_ALLOCATION = new Allocation(EMPTY_CONTAINER_LIST, Resources.createResource(0, 0));

    public void setConf(Configuration conf) {
        this.yarnConf = conf;
    }

    @Override
    public Configuration getConf() {
        return this.yarnConf;
    }

    @Override
    public QueueMetrics getRootQueueMetrics() {
        return this.root.getMetrics();
    }

    public CSQueue getRootQueue() {
        return this.root;
    }

    @Override
    public CapacitySchedulerConfiguration getConfiguration() {
        return this.conf;
    }

    @Override
    public RMContainerTokenSecretManager getContainerTokenSecretManager() {
        return this.rmContext.getContainerTokenSecretManager();
    }

    @Override
    public Resource getMinimumResourceCapability() {
        return this.minimumAllocation;
    }

    @Override
    public Resource getMaximumResourceCapability() {
        return this.maximumAllocation;
    }

    @Override
    public Comparator<FiCaSchedulerApp> getApplicationComparator() {
        return applicationComparator;
    }

    @Override
    public ResourceCalculator getResourceCalculator() {
        return this.calculator;
    }

    @Override
    public Comparator<CSQueue> getQueueComparator() {
        return queueComparator;
    }

    @Override
    public synchronized int getNumClusterNodes() {
        return this.numNodeManagers;
    }

    @Override
    public RMContext getRMContext() {
        return this.rmContext;
    }

    @Override
    public Resource getClusterResources() {
        return this.clusterResource;
    }

    @Override
    public synchronized void reinitialize(Configuration conf, RMContext rmContext) throws IOException {
        if (!this.initialized) {
            this.conf = new CapacitySchedulerConfiguration(conf);
            this.minimumAllocation = this.conf.getMinimumAllocation();
            this.maximumAllocation = this.conf.getMaximumAllocation();
            this.calculator = this.conf.getResourceCalculator();
            this.rmContext = rmContext;
            this.initializeQueues(this.conf);
            this.initialized = true;
            LOG.info((Object)("Initialized CapacityScheduler with calculator=" + this.getResourceCalculator().getClass() + ", " + "minimumAllocation=<" + this.getMinimumResourceCapability() + ">, " + "maximumAllocation=<" + this.getMaximumResourceCapability() + ">"));
        } else {
            CapacitySchedulerConfiguration oldConf = this.conf;
            this.conf = new CapacitySchedulerConfiguration(conf);
            try {
                LOG.info((Object)"Re-initializing queues...");
                this.reinitializeQueues(this.conf);
            }
            catch (Throwable t) {
                this.conf = oldConf;
                throw new IOException("Failed to re-init queues", t);
            }
        }
    }

    @Lock(value={CapacityScheduler.class})
    private void initializeQueues(CapacitySchedulerConfiguration conf) throws IOException {
        this.root = CapacityScheduler.parseQueue(this, conf, null, "root", this.queues, this.queues, noop);
        LOG.info((Object)("Initialized root queue " + this.root));
    }

    @Lock(value={CapacityScheduler.class})
    private void reinitializeQueues(CapacitySchedulerConfiguration conf) throws IOException {
        HashMap<String, CSQueue> newQueues = new HashMap<String, CSQueue>();
        CSQueue newRoot = CapacityScheduler.parseQueue(this, conf, null, "root", newQueues, this.queues, noop);
        this.validateExistingQueues(this.queues, newQueues);
        this.addNewQueues(this.queues, newQueues);
        this.root.reinitialize(newRoot, this.clusterResource);
    }

    @Lock(value={CapacityScheduler.class})
    private void validateExistingQueues(Map<String, CSQueue> queues, Map<String, CSQueue> newQueues) throws IOException {
        for (String queue : queues.keySet()) {
            if (newQueues.containsKey(queue)) continue;
            throw new IOException(queue + " cannot be found during refresh!");
        }
    }

    @Lock(value={CapacityScheduler.class})
    private void addNewQueues(Map<String, CSQueue> queues, Map<String, CSQueue> newQueues) {
        for (Map.Entry<String, CSQueue> e : newQueues.entrySet()) {
            String queueName = e.getKey();
            CSQueue queue = e.getValue();
            if (queues.containsKey(queueName)) continue;
            queues.put(queueName, queue);
        }
    }

    @Lock(value={CapacityScheduler.class})
    static CSQueue parseQueue(CapacitySchedulerContext csContext, CapacitySchedulerConfiguration conf, CSQueue parent, String queueName, Map<String, CSQueue> queues, Map<String, CSQueue> oldQueues, QueueHook hook) throws IOException {
        CSQueue queue;
        String[] childQueueNames = conf.getQueues(parent == null ? queueName : parent.getQueuePath() + "." + queueName);
        if (childQueueNames == null || childQueueNames.length == 0) {
            if (null == parent) {
                throw new IllegalStateException("Queue configuration missing child queue names for " + queueName);
            }
            queue = new LeafQueue(csContext, queueName, parent, oldQueues.get(queueName));
            queue = hook.hook(queue);
        } else {
            ParentQueue parentQueue = new ParentQueue(csContext, queueName, parent, oldQueues.get(queueName));
            queue = hook.hook(parentQueue);
            ArrayList<CSQueue> childQueues = new ArrayList<CSQueue>();
            for (String childQueueName : childQueueNames) {
                CSQueue childQueue = CapacityScheduler.parseQueue(csContext, conf, queue, childQueueName, queues, oldQueues, hook);
                childQueues.add(childQueue);
            }
            parentQueue.setChildQueues(childQueues);
        }
        if (queue instanceof LeafQueue && queues.containsKey(queueName) && queues.get(queueName) instanceof LeafQueue) {
            throw new IOException("Two leaf queues were named " + queueName + ". Leaf queue names must be distinct");
        }
        queues.put(queueName, queue);
        LOG.info((Object)("Initialized queue: " + queue));
        return queue;
    }

    synchronized CSQueue getQueue(String queueName) {
        return this.queues.get(queueName);
    }

    private synchronized void addApplication(ApplicationAttemptId applicationAttemptId, String queueName, String user) {
        CSQueue queue = this.getQueue(queueName);
        if (queue == null) {
            String message = "Application " + applicationAttemptId + " submitted by user " + user + " to unknown queue: " + queueName;
            this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppAttemptRejectedEvent(applicationAttemptId, message));
            return;
        }
        if (!(queue instanceof LeafQueue)) {
            String message = "Application " + applicationAttemptId + " submitted by user " + user + " to non-leaf queue: " + queueName;
            this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppAttemptRejectedEvent(applicationAttemptId, message));
            return;
        }
        FiCaSchedulerApp SchedulerApp = new FiCaSchedulerApp(applicationAttemptId, user, queue, queue.getActiveUsersManager(), this.rmContext);
        try {
            queue.submitApplication(SchedulerApp, user, queueName);
        }
        catch (AccessControlException ace) {
            LOG.info((Object)("Failed to submit application " + applicationAttemptId + " to queue " + queueName + " from user " + user), (Throwable)ace);
            this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppAttemptRejectedEvent(applicationAttemptId, ace.toString()));
            return;
        }
        this.applications.put(applicationAttemptId, SchedulerApp);
        LOG.info((Object)("Application Submission: " + applicationAttemptId + ", user: " + user + " queue: " + queue + ", currently active: " + this.applications.size()));
        this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppAttemptEvent(applicationAttemptId, RMAppAttemptEventType.APP_ACCEPTED));
    }

    private synchronized void doneApplication(ApplicationAttemptId applicationAttemptId, RMAppAttemptState rmAppAttemptFinalState) {
        LOG.info((Object)("Application " + applicationAttemptId + " is done." + " finalState=" + (Object)((Object)rmAppAttemptFinalState)));
        FiCaSchedulerApp application = this.getApplication(applicationAttemptId);
        if (application == null) {
            LOG.info((Object)("Unknown application " + applicationAttemptId + " has completed!"));
            return;
        }
        for (RMContainer rmContainer : application.getLiveContainers()) {
            this.completedContainer(rmContainer, SchedulerUtils.createAbnormalContainerStatus(rmContainer.getContainerId(), "Container of a completed application"), RMContainerEventType.KILL);
        }
        for (RMContainer rmContainer : application.getReservedContainers()) {
            this.completedContainer(rmContainer, SchedulerUtils.createAbnormalContainerStatus(rmContainer.getContainerId(), "Application Complete"), RMContainerEventType.KILL);
        }
        application.stop(rmAppAttemptFinalState);
        String queueName = application.getQueue().getQueueName();
        CSQueue queue = this.queues.get(queueName);
        if (!(queue instanceof LeafQueue)) {
            LOG.error((Object)("Cannot finish application from non-leaf queue: " + queueName));
        } else {
            queue.finishApplication(application, queue.getQueueName());
        }
        this.applications.remove(applicationAttemptId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Lock(value={Lock.NoLock.class})
    public Allocation allocate(ApplicationAttemptId applicationAttemptId, List<ResourceRequest> ask, List<ContainerId> release) {
        FiCaSchedulerApp application = this.getApplication(applicationAttemptId);
        if (application == null) {
            LOG.info((Object)("Calling allocate on removed or non existant application " + applicationAttemptId));
            return EMPTY_ALLOCATION;
        }
        SchedulerUtils.normalizeRequests(ask, this.calculator, this.getClusterResources(), this.minimumAllocation, this.maximumAllocation);
        for (ContainerId releasedContainerId : release) {
            RMContainer rmContainer = this.getRMContainer(releasedContainerId);
            if (rmContainer == null) {
                RMAuditLogger.logFailure(application.getUser(), "AM Released Container", "Unauthorized access or invalid container", "CapacityScheduler", "Trying to release container not owned by app or with invalid id", application.getApplicationId(), releasedContainerId);
            }
            this.completedContainer(rmContainer, SchedulerUtils.createAbnormalContainerStatus(releasedContainerId, "Container released by application"), RMContainerEventType.RELEASED);
        }
        FiCaSchedulerApp fiCaSchedulerApp = application;
        synchronized (fiCaSchedulerApp) {
            if (application.isStopped()) {
                LOG.info((Object)("Calling allocate on a stopped application " + applicationAttemptId));
                return EMPTY_ALLOCATION;
            }
            if (!ask.isEmpty()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("allocate: pre-update applicationAttemptId=" + applicationAttemptId + " application=" + application));
                }
                application.showRequests();
                application.updateResourceRequests(ask);
                LOG.debug((Object)"allocate: post-update");
                application.showRequests();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("allocate: applicationAttemptId=" + applicationAttemptId + " #ask=" + ask.size()));
            }
            return new Allocation(application.pullNewlyAllocatedContainers(), application.getHeadroom());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Lock(value={Lock.NoLock.class})
    public QueueInfo getQueueInfo(String queueName, boolean includeChildQueues, boolean recursive) throws IOException {
        CSQueue queue = null;
        CapacityScheduler capacityScheduler = this;
        synchronized (capacityScheduler) {
            queue = this.queues.get(queueName);
        }
        if (queue == null) {
            throw new IOException("Unknown queue: " + queueName);
        }
        return queue.getQueueInfo(includeChildQueues, recursive);
    }

    @Override
    @Lock(value={Lock.NoLock.class})
    public List<QueueUserACLInfo> getQueueUserAclInfo() {
        UserGroupInformation user = null;
        try {
            user = UserGroupInformation.getCurrentUser();
        }
        catch (IOException ioe) {
            return new ArrayList<QueueUserACLInfo>();
        }
        return this.root.getQueueUserAclInfo(user);
    }

    private synchronized void nodeUpdate(RMNode nm) {
        RMContainer reservedContainer;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("nodeUpdate: " + nm + " clusterResources: " + this.clusterResource));
        }
        FiCaSchedulerNode node = this.getNode(nm.getNodeID());
        List<UpdatedContainerInfo> containerInfoList = nm.pullContainerUpdates();
        ArrayList<ContainerStatus> newlyLaunchedContainers = new ArrayList<ContainerStatus>();
        ArrayList<ContainerStatus> completedContainers = new ArrayList<ContainerStatus>();
        for (UpdatedContainerInfo containerInfo : containerInfoList) {
            newlyLaunchedContainers.addAll(containerInfo.getNewlyLaunchedContainers());
            completedContainers.addAll(containerInfo.getCompletedContainers());
        }
        for (ContainerStatus launchedContainer : newlyLaunchedContainers) {
            this.containerLaunchedOnNode(launchedContainer.getContainerId(), node);
        }
        for (ContainerStatus completedContainer : completedContainers) {
            ContainerId containerId = completedContainer.getContainerId();
            LOG.debug((Object)("Container FINISHED: " + containerId));
            this.completedContainer(this.getRMContainer(containerId), completedContainer, RMContainerEventType.FINISHED);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Node being looked for scheduling " + nm + " availableResource: " + node.getAvailableResource()));
        }
        if ((reservedContainer = node.getReservedContainer()) != null) {
            FiCaSchedulerApp reservedApplication = this.getApplication(reservedContainer.getApplicationAttemptId());
            LOG.info((Object)("Trying to fulfill reservation for application " + reservedApplication.getApplicationId() + " on node: " + nm));
            LeafQueue queue = (LeafQueue)reservedApplication.getQueue();
            CSAssignment assignment = queue.assignContainers(this.clusterResource, node);
            RMContainer excessReservation = assignment.getExcessReservation();
            if (excessReservation != null) {
                Container container = excessReservation.getContainer();
                queue.completedContainer(this.clusterResource, assignment.getApplication(), node, excessReservation, SchedulerUtils.createAbnormalContainerStatus(container.getId(), "Container reservation no longer required."), RMContainerEventType.RELEASED);
            }
        }
        if (node.getReservedContainer() == null) {
            this.root.assignContainers(this.clusterResource, node);
        } else {
            LOG.info((Object)("Skipping scheduling since node " + nm + " is reserved by application " + node.getReservedContainer().getContainerId().getApplicationAttemptId()));
        }
    }

    private void containerLaunchedOnNode(ContainerId containerId, FiCaSchedulerNode node) {
        ApplicationAttemptId applicationAttemptId = containerId.getApplicationAttemptId();
        FiCaSchedulerApp application = this.getApplication(applicationAttemptId);
        if (application == null) {
            LOG.info((Object)("Unknown application: " + applicationAttemptId + " launched container " + containerId + " on node: " + node));
            this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMNodeCleanContainerEvent(node.getNodeID(), containerId));
            return;
        }
        application.containerLaunchedOnNode(containerId, node.getNodeID());
    }

    public void handle(SchedulerEvent event) {
        switch ((SchedulerEventType)event.getType()) {
            case NODE_ADDED: {
                NodeAddedSchedulerEvent nodeAddedEvent = (NodeAddedSchedulerEvent)event;
                this.addNode(nodeAddedEvent.getAddedRMNode());
                break;
            }
            case NODE_REMOVED: {
                NodeRemovedSchedulerEvent nodeRemovedEvent = (NodeRemovedSchedulerEvent)event;
                this.removeNode(nodeRemovedEvent.getRemovedRMNode());
                break;
            }
            case NODE_UPDATE: {
                NodeUpdateSchedulerEvent nodeUpdatedEvent = (NodeUpdateSchedulerEvent)event;
                this.nodeUpdate(nodeUpdatedEvent.getRMNode());
                break;
            }
            case APP_ADDED: {
                AppAddedSchedulerEvent appAddedEvent = (AppAddedSchedulerEvent)event;
                this.addApplication(appAddedEvent.getApplicationAttemptId(), appAddedEvent.getQueue(), appAddedEvent.getUser());
                break;
            }
            case APP_REMOVED: {
                AppRemovedSchedulerEvent appRemovedEvent = (AppRemovedSchedulerEvent)event;
                this.doneApplication(appRemovedEvent.getApplicationAttemptID(), appRemovedEvent.getFinalAttemptState());
                break;
            }
            case CONTAINER_EXPIRED: {
                ContainerExpiredSchedulerEvent containerExpiredEvent = (ContainerExpiredSchedulerEvent)event;
                ContainerId containerId = containerExpiredEvent.getContainerId();
                this.completedContainer(this.getRMContainer(containerId), SchedulerUtils.createAbnormalContainerStatus(containerId, "Container expired since it was unused"), RMContainerEventType.EXPIRE);
                break;
            }
            default: {
                LOG.error((Object)("Invalid eventtype " + event.getType() + ". Ignoring!"));
            }
        }
    }

    private synchronized void addNode(RMNode nodeManager) {
        this.nodes.put(nodeManager.getNodeID(), new FiCaSchedulerNode(nodeManager));
        Resources.addTo(this.clusterResource, nodeManager.getTotalCapability());
        this.root.updateClusterResource(this.clusterResource);
        ++this.numNodeManagers;
        LOG.info((Object)("Added node " + nodeManager.getNodeAddress() + " clusterResource: " + this.clusterResource));
    }

    private synchronized void removeNode(RMNode nodeInfo) {
        FiCaSchedulerNode node = this.nodes.get(nodeInfo.getNodeID());
        if (node == null) {
            return;
        }
        Resources.subtractFrom(this.clusterResource, node.getRMNode().getTotalCapability());
        this.root.updateClusterResource(this.clusterResource);
        --this.numNodeManagers;
        List<RMContainer> runningContainers = node.getRunningContainers();
        for (RMContainer container : runningContainers) {
            this.completedContainer(container, SchedulerUtils.createAbnormalContainerStatus(container.getContainerId(), "Container released on a *lost* node"), RMContainerEventType.KILL);
        }
        RMContainer reservedContainer = node.getReservedContainer();
        if (reservedContainer != null) {
            this.completedContainer(reservedContainer, SchedulerUtils.createAbnormalContainerStatus(reservedContainer.getContainerId(), "Container released on a *lost* node"), RMContainerEventType.KILL);
        }
        this.nodes.remove(nodeInfo.getNodeID());
        LOG.info((Object)("Removed node " + nodeInfo.getNodeAddress() + " clusterResource: " + this.clusterResource));
    }

    @Lock(value={CapacityScheduler.class})
    private synchronized void completedContainer(RMContainer rmContainer, ContainerStatus containerStatus, RMContainerEventType event) {
        if (rmContainer == null) {
            LOG.info((Object)"Null container completed...");
            return;
        }
        Container container = rmContainer.getContainer();
        ApplicationAttemptId applicationAttemptId = container.getId().getApplicationAttemptId();
        FiCaSchedulerApp application = this.getApplication(applicationAttemptId);
        if (application == null) {
            LOG.info((Object)("Container " + container + " of" + " unknown application " + applicationAttemptId + " completed with event " + (Object)((Object)event)));
            return;
        }
        FiCaSchedulerNode node = this.getNode(container.getNodeId());
        LeafQueue queue = (LeafQueue)application.getQueue();
        queue.completedContainer(this.clusterResource, application, node, rmContainer, containerStatus, event);
        LOG.info((Object)("Application " + applicationAttemptId + " released container " + container.getId() + " on node: " + node + " with event: " + (Object)((Object)event)));
    }

    @Lock(value={Lock.NoLock.class})
    FiCaSchedulerApp getApplication(ApplicationAttemptId applicationAttemptId) {
        return this.applications.get(applicationAttemptId);
    }

    @Override
    public SchedulerAppReport getSchedulerAppInfo(ApplicationAttemptId applicationAttemptId) {
        FiCaSchedulerApp app = this.getApplication(applicationAttemptId);
        return app == null ? null : new SchedulerAppReport(app);
    }

    @Lock(value={Lock.NoLock.class})
    FiCaSchedulerNode getNode(NodeId nodeId) {
        return this.nodes.get(nodeId);
    }

    private RMContainer getRMContainer(ContainerId containerId) {
        FiCaSchedulerApp application = this.getApplication(containerId.getApplicationAttemptId());
        return application == null ? null : application.getRMContainer(containerId);
    }

    @Override
    @Lock(value={Lock.NoLock.class})
    public void recover(RMStateStore.RMState state) throws Exception {
    }

    @Override
    public SchedulerNodeReport getNodeReport(NodeId nodeId) {
        FiCaSchedulerNode node = this.getNode(nodeId);
        return node == null ? null : new SchedulerNodeReport(node);
    }

    static class QueueHook {
        QueueHook() {
        }

        public CSQueue hook(CSQueue queue) {
            return queue;
        }
    }
}

