/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.amlauncher;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.security.PrivilegedAction;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DataInputByteBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.ContainerManagementProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainerRequest;
import org.apache.hadoop.yarn.api.protocolrecords.StopContainerRequest;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.security.AMRMTokenIdentifier;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.amlauncher.AMLauncherEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.event.RMAppAttemptLaunchFailedEvent;
import org.apache.hadoop.yarn.util.ConverterUtils;

public class AMLauncher
implements Runnable {
    private static final Log LOG = LogFactory.getLog(AMLauncher.class);
    private ContainerManagementProtocol containerMgrProxy;
    private final RMAppAttempt application;
    private final Configuration conf;
    private final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    private final AMLauncherEventType eventType;
    private final RMContext rmContext;
    private final Container masterContainer;
    private final EventHandler handler;

    public AMLauncher(RMContext rmContext, RMAppAttempt application, AMLauncherEventType eventType, Configuration conf) {
        this.application = application;
        this.conf = conf;
        this.eventType = eventType;
        this.rmContext = rmContext;
        this.handler = rmContext.getDispatcher().getEventHandler();
        this.masterContainer = application.getMasterContainer();
    }

    private void connect() throws IOException {
        ContainerId masterContainerID = this.masterContainer.getId();
        this.containerMgrProxy = this.getContainerMgrProxy(masterContainerID);
    }

    private void launch() throws IOException, YarnException {
        this.connect();
        ContainerId masterContainerID = this.masterContainer.getId();
        ApplicationSubmissionContext applicationContext = this.application.getSubmissionContext();
        LOG.info((Object)("Setting up container " + this.masterContainer + " for AM " + this.application.getAppAttemptId()));
        ContainerLaunchContext launchContext = this.createAMContainerLaunchContext(applicationContext, masterContainerID);
        StartContainerRequest request = (StartContainerRequest)this.recordFactory.newRecordInstance(StartContainerRequest.class);
        request.setContainerLaunchContext(launchContext);
        request.setContainerToken(this.masterContainer.getContainerToken());
        this.containerMgrProxy.startContainer(request);
        LOG.info((Object)("Done launching container " + this.masterContainer + " for AM " + this.application.getAppAttemptId()));
    }

    private void cleanup() throws IOException, YarnException {
        this.connect();
        ContainerId containerId = this.masterContainer.getId();
        StopContainerRequest stopRequest = (StopContainerRequest)this.recordFactory.newRecordInstance(StopContainerRequest.class);
        stopRequest.setContainerId(containerId);
        this.containerMgrProxy.stopContainer(stopRequest);
    }

    protected ContainerManagementProtocol getContainerMgrProxy(ContainerId containerId) {
        NodeId node = this.masterContainer.getNodeId();
        final InetSocketAddress containerManagerBindAddress = NetUtils.createSocketAddrForHost((String)node.getHost(), (int)node.getPort());
        final YarnRPC rpc = YarnRPC.create((Configuration)this.conf);
        UserGroupInformation currentUser = UserGroupInformation.createRemoteUser((String)containerId.getApplicationAttemptId().toString());
        String user = ((RMApp)this.rmContext.getRMApps().get(containerId.getApplicationAttemptId().getApplicationId())).getUser();
        org.apache.hadoop.yarn.api.records.Token token = this.rmContext.getNMTokenSecretManager().createNMToken(containerId.getApplicationAttemptId(), node, user);
        currentUser.addToken(ConverterUtils.convertFromYarn((org.apache.hadoop.yarn.api.records.Token)token, (InetSocketAddress)containerManagerBindAddress));
        return (ContainerManagementProtocol)currentUser.doAs((PrivilegedAction)new PrivilegedAction<ContainerManagementProtocol>(){

            @Override
            public ContainerManagementProtocol run() {
                return (ContainerManagementProtocol)rpc.getProxy(ContainerManagementProtocol.class, containerManagerBindAddress, AMLauncher.this.conf);
            }
        });
    }

    private ContainerLaunchContext createAMContainerLaunchContext(ApplicationSubmissionContext applicationMasterContext, ContainerId containerID) throws IOException {
        ContainerLaunchContext container = applicationMasterContext.getAMContainerSpec();
        LOG.info((Object)("Command to launch container " + containerID + " : " + StringUtils.arrayToString((String[])container.getCommands().toArray(new String[0]))));
        this.setupTokens(container, containerID);
        return container;
    }

    private void setupTokens(ContainerLaunchContext container, ContainerId containerID) throws IOException {
        Map environment = container.getEnvironment();
        environment.put("APPLICATION_WEB_PROXY_BASE", this.application.getWebProxyBase());
        ApplicationId applicationId = this.application.getAppAttemptId().getApplicationId();
        environment.put("APP_SUBMIT_TIME_ENV", String.valueOf(((RMApp)this.rmContext.getRMApps().get(applicationId)).getSubmitTime()));
        environment.put("MAX_APP_ATTEMPTS", String.valueOf(((RMApp)this.rmContext.getRMApps().get(applicationId)).getMaxAppAttempts()));
        if (UserGroupInformation.isSecurityEnabled()) {
            Token<AMRMTokenIdentifier> amrmToken;
            Credentials credentials = new Credentials();
            DataInputByteBuffer dibb = new DataInputByteBuffer();
            if (container.getTokens() != null) {
                dibb.reset(new ByteBuffer[]{container.getTokens()});
                credentials.readTokenStorageStream((DataInputStream)dibb);
            }
            if ((amrmToken = this.application.getAMRMToken()) != null) {
                credentials.addToken(amrmToken.getService(), amrmToken);
            }
            DataOutputBuffer dob = new DataOutputBuffer();
            credentials.writeTokenStorageToStream((DataOutputStream)dob);
            container.setTokens(ByteBuffer.wrap(dob.getData(), 0, dob.getLength()));
        }
    }

    @Override
    public void run() {
        switch (this.eventType) {
            case LAUNCH: {
                try {
                    LOG.info((Object)("Launching master" + this.application.getAppAttemptId()));
                    this.launch();
                    this.handler.handle((Event)new RMAppAttemptEvent(this.application.getAppAttemptId(), RMAppAttemptEventType.LAUNCHED));
                }
                catch (Exception ie) {
                    String message = "Error launching " + this.application.getAppAttemptId() + ". Got exception: " + StringUtils.stringifyException((Throwable)ie);
                    LOG.info((Object)message);
                    this.handler.handle((Event)new RMAppAttemptLaunchFailedEvent(this.application.getAppAttemptId(), message));
                }
                break;
            }
            case CLEANUP: {
                try {
                    LOG.info((Object)("Cleaning master " + this.application.getAppAttemptId()));
                    this.cleanup();
                }
                catch (IOException ie) {
                    LOG.info((Object)"Error cleaning master ", (Throwable)ie);
                }
                catch (YarnException e) {
                    StringBuilder sb = new StringBuilder("Container ");
                    sb.append(this.masterContainer.getId().toString());
                    sb.append(" is not handled by this NodeManager");
                    if (e.getMessage().contains(sb.toString())) break;
                    LOG.info((Object)"Error cleaning master ", (Throwable)e);
                }
                break;
            }
            default: {
                LOG.warn((Object)("Received unknown event-type " + (Object)((Object)this.eventType) + ". Ignoring."));
            }
        }
    }
}

