/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.recovery;

import java.io.DataOutputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.delegation.DelegationKey;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.impl.pb.ApplicationSubmissionContextPBImpl;
import org.apache.hadoop.yarn.event.AsyncDispatcher;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.security.AMRMTokenIdentifier;
import org.apache.hadoop.yarn.security.client.ClientToAMTokenIdentifier;
import org.apache.hadoop.yarn.security.client.RMDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStoreAppAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStoreAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStoreEvent;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStoreEventType;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStoreRemoveAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.impl.pb.ApplicationAttemptStateDataPBImpl;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.impl.pb.ApplicationStateDataPBImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppStoredEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.event.RMAppAttemptStoredEvent;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public abstract class RMStateStore {
    public static final Log LOG = LogFactory.getLog(RMStateStore.class);
    private Dispatcher rmDispatcher;
    AsyncDispatcher dispatcher;

    public void setDispatcher(Dispatcher dispatcher) {
        this.rmDispatcher = dispatcher;
    }

    public synchronized void init(Configuration conf) throws Exception {
        this.dispatcher = new AsyncDispatcher();
        this.dispatcher.init(conf);
        this.dispatcher.register(RMStateStoreEventType.class, (EventHandler)new ForwardingEventHandler());
        this.dispatcher.start();
        this.initInternal(conf);
    }

    protected abstract void initInternal(Configuration var1) throws Exception;

    public synchronized void close() throws Exception {
        this.closeInternal();
        this.dispatcher.stop();
    }

    protected abstract void closeInternal() throws Exception;

    public abstract RMState loadState() throws Exception;

    public synchronized void storeApplication(RMApp app) {
        ApplicationSubmissionContext context = app.getApplicationSubmissionContext();
        assert (context instanceof ApplicationSubmissionContextPBImpl);
        ApplicationState appState = new ApplicationState(app.getSubmitTime(), context, app.getUser());
        this.dispatcher.getEventHandler().handle((Event)new RMStateStoreAppEvent(appState));
    }

    protected abstract void storeApplicationState(String var1, ApplicationStateDataPBImpl var2) throws Exception;

    public synchronized void storeApplicationAttempt(RMAppAttempt appAttempt) {
        Credentials credentials = this.getTokensFromAppAttempt(appAttempt);
        ApplicationAttemptState attemptState = new ApplicationAttemptState(appAttempt.getAppAttemptId(), appAttempt.getMasterContainer(), credentials);
        this.dispatcher.getEventHandler().handle((Event)new RMStateStoreAppAttemptEvent(attemptState));
    }

    protected abstract void storeApplicationAttemptState(String var1, ApplicationAttemptStateDataPBImpl var2) throws Exception;

    public synchronized void storeRMDelegationTokenAndSequenceNumber(RMDelegationTokenIdentifier rmDTIdentifier, Long renewDate, int latestSequenceNumber) throws Exception {
        this.storeRMDelegationTokenAndSequenceNumberState(rmDTIdentifier, renewDate, latestSequenceNumber);
    }

    protected abstract void storeRMDelegationTokenAndSequenceNumberState(RMDelegationTokenIdentifier var1, Long var2, int var3) throws Exception;

    public synchronized void removeRMDelegationToken(RMDelegationTokenIdentifier rmDTIdentifier, int sequenceNumber) throws Exception {
        this.removeRMDelegationTokenState(rmDTIdentifier);
    }

    protected abstract void removeRMDelegationTokenState(RMDelegationTokenIdentifier var1) throws Exception;

    public synchronized void storeRMDTMasterKey(DelegationKey delegationKey) throws Exception {
        this.storeRMDTMasterKeyState(delegationKey);
    }

    protected abstract void storeRMDTMasterKeyState(DelegationKey var1) throws Exception;

    public synchronized void removeRMDTMasterKey(DelegationKey delegationKey) throws Exception {
        this.removeRMDTMasterKeyState(delegationKey);
    }

    protected abstract void removeRMDTMasterKeyState(DelegationKey var1) throws Exception;

    public synchronized void removeApplication(RMApp app) {
        ApplicationState appState = new ApplicationState(app.getSubmitTime(), app.getApplicationSubmissionContext(), app.getUser());
        for (RMAppAttempt appAttempt : app.getAppAttempts().values()) {
            Credentials credentials = this.getTokensFromAppAttempt(appAttempt);
            ApplicationAttemptState attemptState = new ApplicationAttemptState(appAttempt.getAppAttemptId(), appAttempt.getMasterContainer(), credentials);
            appState.attempts.put(attemptState.getAttemptId(), attemptState);
        }
        this.removeApplication(appState);
    }

    public synchronized void removeApplication(ApplicationState appState) {
        this.dispatcher.getEventHandler().handle((Event)new RMStateStoreRemoveAppEvent(appState));
    }

    protected abstract void removeApplicationState(ApplicationState var1) throws Exception;

    private Credentials getTokensFromAppAttempt(RMAppAttempt appAttempt) {
        Token<ClientToAMTokenIdentifier> clientToAMToken;
        Credentials credentials = new Credentials();
        Token<AMRMTokenIdentifier> appToken = appAttempt.getAMRMToken();
        if (appToken != null) {
            credentials.addToken(appToken.getService(), appToken);
        }
        if ((clientToAMToken = appAttempt.getClientToAMToken()) != null) {
            credentials.addToken(clientToAMToken.getService(), clientToAMToken);
        }
        return credentials;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void handleStoreEvent(RMStateStoreEvent event) {
        switch ((RMStateStoreEventType)event.getType()) {
            case STORE_APP: {
                ApplicationState apptState = ((RMStateStoreAppEvent)event).getAppState();
                Exception storedException = null;
                ApplicationStateDataPBImpl appStateData = new ApplicationStateDataPBImpl();
                appStateData.setSubmitTime(apptState.getSubmitTime());
                appStateData.setApplicationSubmissionContext(apptState.getApplicationSubmissionContext());
                appStateData.setUser(apptState.getUser());
                ApplicationId appId = apptState.getApplicationSubmissionContext().getApplicationId();
                LOG.info((Object)("Storing info for app: " + appId));
                try {
                    this.storeApplicationState(appId.toString(), appStateData);
                    this.notifyDoneStoringApplication(appId, storedException);
                    break;
                }
                catch (Exception e) {
                    try {
                        LOG.error((Object)("Error storing app: " + appId), (Throwable)e);
                        storedException = e;
                        this.notifyDoneStoringApplication(appId, storedException);
                        break;
                    }
                    catch (Throwable throwable) {
                        this.notifyDoneStoringApplication(appId, storedException);
                        throw throwable;
                    }
                }
            }
            case STORE_APP_ATTEMPT: {
                ApplicationAttemptState attemptState = ((RMStateStoreAppAttemptEvent)event).getAppAttemptState();
                Exception storedException = null;
                Credentials credentials = attemptState.getAppAttemptTokens();
                ByteBuffer appAttemptTokens = null;
                try {
                    if (credentials != null) {
                        DataOutputBuffer dob = new DataOutputBuffer();
                        credentials.writeTokenStorageToStream((DataOutputStream)dob);
                        appAttemptTokens = ByteBuffer.wrap(dob.getData(), 0, dob.getLength());
                    }
                    ApplicationAttemptStateDataPBImpl attemptStateData = (ApplicationAttemptStateDataPBImpl)ApplicationAttemptStateDataPBImpl.newApplicationAttemptStateData(attemptState.getAttemptId(), attemptState.getMasterContainer(), appAttemptTokens);
                    LOG.info((Object)("Storing info for attempt: " + attemptState.getAttemptId()));
                    this.storeApplicationAttemptState(attemptState.getAttemptId().toString(), attemptStateData);
                    this.notifyDoneStoringApplicationAttempt(attemptState.getAttemptId(), storedException);
                    break;
                }
                catch (Exception e) {
                    try {
                        LOG.error((Object)("Error storing appAttempt: " + attemptState.getAttemptId()), (Throwable)e);
                        storedException = e;
                        this.notifyDoneStoringApplicationAttempt(attemptState.getAttemptId(), storedException);
                        break;
                    }
                    catch (Throwable throwable) {
                        this.notifyDoneStoringApplicationAttempt(attemptState.getAttemptId(), storedException);
                        throw throwable;
                    }
                }
            }
            case REMOVE_APP: {
                ApplicationState appState = ((RMStateStoreRemoveAppEvent)event).getAppState();
                ApplicationId appId = appState.getAppId();
                LOG.info((Object)("Removing info for app: " + appId));
                try {
                    this.removeApplicationState(appState);
                }
                catch (Exception e) {
                    LOG.error((Object)("Error removing app: " + appId), (Throwable)e);
                }
                break;
            }
            default: {
                LOG.error((Object)("Unknown RMStateStoreEvent type: " + event.getType()));
            }
        }
    }

    private void notifyDoneStoringApplication(ApplicationId appId, Exception storedException) {
        this.rmDispatcher.getEventHandler().handle((Event)new RMAppStoredEvent(appId, storedException));
    }

    private void notifyDoneStoringApplicationAttempt(ApplicationAttemptId attemptId, Exception storedException) {
        this.rmDispatcher.getEventHandler().handle((Event)new RMAppAttemptStoredEvent(attemptId, storedException));
    }

    private final class ForwardingEventHandler
    implements EventHandler<RMStateStoreEvent> {
        private ForwardingEventHandler() {
        }

        public void handle(RMStateStoreEvent event) {
            RMStateStore.this.handleStoreEvent(event);
        }
    }

    public static class RMState {
        Map<ApplicationId, ApplicationState> appState = new HashMap<ApplicationId, ApplicationState>();
        RMDTSecretManagerState rmSecretManagerState = new RMDTSecretManagerState();

        public Map<ApplicationId, ApplicationState> getApplicationState() {
            return this.appState;
        }

        public RMDTSecretManagerState getRMDTSecretManagerState() {
            return this.rmSecretManagerState;
        }
    }

    public static class RMDTSecretManagerState {
        Map<RMDelegationTokenIdentifier, Long> delegationTokenState = new HashMap<RMDelegationTokenIdentifier, Long>();
        Set<DelegationKey> masterKeyState = new HashSet<DelegationKey>();
        int dtSequenceNumber = 0;

        public Map<RMDelegationTokenIdentifier, Long> getTokenState() {
            return this.delegationTokenState;
        }

        public Set<DelegationKey> getMasterKeyState() {
            return this.masterKeyState;
        }

        public int getDTSequenceNumber() {
            return this.dtSequenceNumber;
        }
    }

    public static class ApplicationState {
        final ApplicationSubmissionContext context;
        final long submitTime;
        final String user;
        Map<ApplicationAttemptId, ApplicationAttemptState> attempts = new HashMap<ApplicationAttemptId, ApplicationAttemptState>();

        ApplicationState(long submitTime, ApplicationSubmissionContext context, String user) {
            this.submitTime = submitTime;
            this.context = context;
            this.user = user;
        }

        public ApplicationId getAppId() {
            return this.context.getApplicationId();
        }

        public long getSubmitTime() {
            return this.submitTime;
        }

        public int getAttemptCount() {
            return this.attempts.size();
        }

        public ApplicationSubmissionContext getApplicationSubmissionContext() {
            return this.context;
        }

        public ApplicationAttemptState getAttempt(ApplicationAttemptId attemptId) {
            return this.attempts.get(attemptId);
        }

        public String getUser() {
            return this.user;
        }
    }

    public static class ApplicationAttemptState {
        final ApplicationAttemptId attemptId;
        final Container masterContainer;
        final Credentials appAttemptTokens;

        public ApplicationAttemptState(ApplicationAttemptId attemptId, Container masterContainer, Credentials appAttemptTokens) {
            this.attemptId = attemptId;
            this.masterContainer = masterContainer;
            this.appAttemptTokens = appAttemptTokens;
        }

        public Container getMasterContainer() {
            return this.masterContainer;
        }

        public ApplicationAttemptId getAttemptId() {
            return this.attemptId;
        }

        public Credentials getAppAttemptTokens() {
            return this.appAttemptTokens;
        }
    }
}

