/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.resource;

import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.resource.ResourceCalculator;
import org.apache.hadoop.yarn.server.resourcemanager.resource.Resources;

public class DominantResourceCalculator
extends ResourceCalculator {
    @Override
    public int compare(Resource clusterResource, Resource lhs, Resource rhs) {
        float r;
        if (lhs.equals((Object)rhs)) {
            return 0;
        }
        float l = this.getResourceAsValue(clusterResource, lhs, true);
        if (l < (r = this.getResourceAsValue(clusterResource, rhs, true))) {
            return -1;
        }
        if (l > r) {
            return 1;
        }
        l = this.getResourceAsValue(clusterResource, lhs, false);
        if (l < (r = this.getResourceAsValue(clusterResource, rhs, false))) {
            return -1;
        }
        if (l > r) {
            return 1;
        }
        return 0;
    }

    protected float getResourceAsValue(Resource clusterResource, Resource resource, boolean dominant) {
        return dominant ? Math.max((float)resource.getMemory() / (float)clusterResource.getMemory(), (float)resource.getVirtualCores() / (float)clusterResource.getVirtualCores()) : Math.min((float)resource.getMemory() / (float)clusterResource.getMemory(), (float)resource.getVirtualCores() / (float)clusterResource.getVirtualCores());
    }

    @Override
    public int computeAvailableContainers(Resource available, Resource required) {
        return Math.min(available.getMemory() / required.getMemory(), available.getVirtualCores() / required.getVirtualCores());
    }

    @Override
    public float divide(Resource clusterResource, Resource numerator, Resource denominator) {
        return this.getResourceAsValue(clusterResource, numerator, true) / this.getResourceAsValue(clusterResource, denominator, true);
    }

    @Override
    public float ratio(Resource a, Resource b) {
        return Math.max((float)a.getMemory() / (float)b.getMemory(), (float)a.getVirtualCores() / (float)b.getVirtualCores());
    }

    @Override
    public Resource divideAndCeil(Resource numerator, int denominator) {
        return Resources.createResource(DominantResourceCalculator.divideAndCeil(numerator.getMemory(), denominator), DominantResourceCalculator.divideAndCeil(numerator.getVirtualCores(), denominator));
    }

    @Override
    public Resource normalize(Resource r, Resource minimumResource, Resource maximumResource, Resource stepFactor) {
        int normalizedMemory = Math.min(DominantResourceCalculator.roundUp(Math.max(r.getMemory(), minimumResource.getMemory()), stepFactor.getMemory()), maximumResource.getMemory());
        int normalizedCores = Math.min(DominantResourceCalculator.roundUp(Math.max(r.getVirtualCores(), minimumResource.getVirtualCores()), stepFactor.getVirtualCores()), maximumResource.getVirtualCores());
        return Resources.createResource(normalizedMemory, normalizedCores);
    }

    @Override
    public Resource roundUp(Resource r, Resource stepFactor) {
        return Resources.createResource(DominantResourceCalculator.roundUp(r.getMemory(), stepFactor.getMemory()), DominantResourceCalculator.roundUp(r.getVirtualCores(), stepFactor.getVirtualCores()));
    }

    @Override
    public Resource roundDown(Resource r, Resource stepFactor) {
        return Resources.createResource(DominantResourceCalculator.roundDown(r.getMemory(), stepFactor.getMemory()), DominantResourceCalculator.roundDown(r.getVirtualCores(), stepFactor.getVirtualCores()));
    }

    @Override
    public Resource multiplyAndNormalizeUp(Resource r, double by, Resource stepFactor) {
        return Resources.createResource(DominantResourceCalculator.roundUp((int)Math.ceil((double)r.getMemory() * by), stepFactor.getMemory()), DominantResourceCalculator.roundUp((int)Math.ceil((double)r.getVirtualCores() * by), stepFactor.getVirtualCores()));
    }

    @Override
    public Resource multiplyAndNormalizeDown(Resource r, double by, Resource stepFactor) {
        return Resources.createResource(DominantResourceCalculator.roundDown((int)((double)r.getMemory() * by), stepFactor.getMemory()), DominantResourceCalculator.roundDown((int)((double)r.getVirtualCores() * by), stepFactor.getVirtualCores()));
    }
}

