/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fifo.FifoScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppAttemptInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppAttemptsInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppsInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.CapacitySchedulerInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ClusterInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ClusterMetricsInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.FifoSchedulerInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.NodeInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.NodesInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.SchedulerInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.SchedulerTypeInfo;
import org.apache.hadoop.yarn.server.security.ApplicationACLsManager;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.webapp.BadRequestException;
import org.apache.hadoop.yarn.webapp.NotFoundException;

@Singleton
@Path(value="/ws/v1/cluster")
public class RMWebServices {
    private static final String EMPTY = "";
    private final ResourceManager rm;
    private static RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    private final ApplicationACLsManager aclsManager;
    @Context
    private HttpServletResponse response;

    @Inject
    public RMWebServices(ResourceManager rm, ApplicationACLsManager aclsManager) {
        this.rm = rm;
        this.aclsManager = aclsManager;
    }

    protected Boolean hasAccess(RMApp app, HttpServletRequest hsr) {
        String remoteUser = hsr.getRemoteUser();
        UserGroupInformation callerUGI = null;
        if (remoteUser != null) {
            callerUGI = UserGroupInformation.createRemoteUser((String)remoteUser);
        }
        if (callerUGI != null && !this.aclsManager.checkAccess(callerUGI, ApplicationAccessType.VIEW_APP, app.getUser(), app.getApplicationId())) {
            return false;
        }
        return true;
    }

    private void init() {
        this.response.setContentType(null);
    }

    @GET
    @Produces(value={"application/json", "application/xml"})
    public ClusterInfo get() {
        return this.getClusterInfo();
    }

    @GET
    @Path(value="/info")
    @Produces(value={"application/json", "application/xml"})
    public ClusterInfo getClusterInfo() {
        this.init();
        return new ClusterInfo(this.rm);
    }

    @GET
    @Path(value="/metrics")
    @Produces(value={"application/json", "application/xml"})
    public ClusterMetricsInfo getClusterMetricsInfo() {
        this.init();
        return new ClusterMetricsInfo(this.rm, this.rm.getRMContext());
    }

    @GET
    @Path(value="/scheduler")
    @Produces(value={"application/json", "application/xml"})
    public SchedulerTypeInfo getSchedulerInfo() {
        SchedulerInfo sinfo;
        this.init();
        ResourceScheduler rs = this.rm.getResourceScheduler();
        if (rs instanceof CapacityScheduler) {
            CapacityScheduler cs = (CapacityScheduler)rs;
            CSQueue root = cs.getRootQueue();
            sinfo = new CapacitySchedulerInfo(root);
        } else if (rs instanceof FifoScheduler) {
            sinfo = new FifoSchedulerInfo(this.rm);
        } else {
            throw new NotFoundException("Unknown scheduler configured");
        }
        return new SchedulerTypeInfo(sinfo);
    }

    @GET
    @Path(value="/nodes")
    @Produces(value={"application/json", "application/xml"})
    public NodesInfo getNodes(@QueryParam(value="state") String state) {
        NodeInfo nodeInfo;
        this.init();
        ResourceScheduler sched = this.rm.getResourceScheduler();
        if (sched == null) {
            throw new NotFoundException("Null ResourceScheduler instance");
        }
        NodeState acceptedState = null;
        boolean all = false;
        if (state != null && !state.isEmpty()) {
            if (state.equalsIgnoreCase("all")) {
                all = true;
            } else {
                acceptedState = NodeState.valueOf((String)state.toUpperCase());
            }
        }
        NodesInfo allNodes = new NodesInfo();
        for (RMNode ni : this.rm.getRMContext().getRMNodes().values()) {
            if (!all && (acceptedState != null || ni.getState() == NodeState.UNHEALTHY) && acceptedState != ni.getState()) continue;
            nodeInfo = new NodeInfo(ni, sched);
            allNodes.add(nodeInfo);
        }
        if (all || acceptedState != null && (acceptedState == NodeState.DECOMMISSIONED || acceptedState == NodeState.LOST || acceptedState == NodeState.REBOOTED)) {
            for (RMNode ni : this.rm.getRMContext().getInactiveRMNodes().values()) {
                if (!all && acceptedState != ni.getState()) continue;
                nodeInfo = new NodeInfo(ni, sched);
                nodeInfo.setNodeHTTPAddress(EMPTY);
                allNodes.add(nodeInfo);
            }
        }
        return allNodes;
    }

    @GET
    @Path(value="/nodes/{nodeId}")
    @Produces(value={"application/json", "application/xml"})
    public NodeInfo getNode(@PathParam(value="nodeId") String nodeId) {
        this.init();
        if (nodeId == null || nodeId.isEmpty()) {
            throw new NotFoundException("nodeId, " + nodeId + ", is empty or null");
        }
        ResourceScheduler sched = this.rm.getResourceScheduler();
        if (sched == null) {
            throw new NotFoundException("Null ResourceScheduler instance");
        }
        NodeId nid = ConverterUtils.toNodeId((String)nodeId);
        RMNode ni = (RMNode)this.rm.getRMContext().getRMNodes().get(nid);
        boolean isInactive = false;
        if (ni == null) {
            ni = (RMNode)this.rm.getRMContext().getInactiveRMNodes().get(nid.getHost());
            if (ni == null) {
                throw new NotFoundException("nodeId, " + nodeId + ", is not found");
            }
            isInactive = true;
        }
        NodeInfo nodeInfo = new NodeInfo(ni, sched);
        if (isInactive) {
            nodeInfo.setNodeHTTPAddress(EMPTY);
        }
        return nodeInfo;
    }

    @GET
    @Path(value="/apps")
    @Produces(value={"application/json", "application/xml"})
    public AppsInfo getApps(@Context HttpServletRequest hsr, @QueryParam(value="state") String stateQuery, @QueryParam(value="finalStatus") String finalStatusQuery, @QueryParam(value="user") String userQuery, @QueryParam(value="queue") String queueQuery, @QueryParam(value="limit") String count, @QueryParam(value="startedTimeBegin") String startedBegin, @QueryParam(value="startedTimeEnd") String startedEnd, @QueryParam(value="finishedTimeBegin") String finishBegin, @QueryParam(value="finishedTimeEnd") String finishEnd) {
        long num = 0L;
        boolean checkCount = false;
        boolean checkStart = false;
        boolean checkEnd = false;
        long countNum = 0L;
        long sBegin = 0L;
        long sEnd = Long.MAX_VALUE;
        long fBegin = 0L;
        long fEnd = Long.MAX_VALUE;
        this.init();
        if (count != null && !count.isEmpty()) {
            checkCount = true;
            countNum = Long.parseLong(count);
            if (countNum <= 0L) {
                throw new BadRequestException("limit value must be greater then 0");
            }
        }
        if (startedBegin != null && !startedBegin.isEmpty()) {
            checkStart = true;
            sBegin = Long.parseLong(startedBegin);
            if (sBegin < 0L) {
                throw new BadRequestException("startedTimeBegin must be greater than 0");
            }
        }
        if (startedEnd != null && !startedEnd.isEmpty()) {
            checkStart = true;
            sEnd = Long.parseLong(startedEnd);
            if (sEnd < 0L) {
                throw new BadRequestException("startedTimeEnd must be greater than 0");
            }
        }
        if (sBegin > sEnd) {
            throw new BadRequestException("startedTimeEnd must be greater than startTimeBegin");
        }
        if (finishBegin != null && !finishBegin.isEmpty()) {
            checkEnd = true;
            fBegin = Long.parseLong(finishBegin);
            if (fBegin < 0L) {
                throw new BadRequestException("finishTimeBegin must be greater than 0");
            }
        }
        if (finishEnd != null && !finishEnd.isEmpty()) {
            checkEnd = true;
            fEnd = Long.parseLong(finishEnd);
            if (fEnd < 0L) {
                throw new BadRequestException("finishTimeEnd must be greater than 0");
            }
        }
        if (fBegin > fEnd) {
            throw new BadRequestException("finishTimeEnd must be greater than finishTimeBegin");
        }
        ConcurrentMap<ApplicationId, RMApp> apps = this.rm.getRMContext().getRMApps();
        AppsInfo allApps = new AppsInfo();
        for (RMApp rmapp : apps.values()) {
            if (checkCount && num == countNum) break;
            if (stateQuery != null && !stateQuery.isEmpty()) {
                RMAppState.valueOf(stateQuery);
                if (!rmapp.getState().toString().equalsIgnoreCase(stateQuery)) continue;
            }
            if (finalStatusQuery != null && !finalStatusQuery.isEmpty()) {
                FinalApplicationStatus.valueOf((String)finalStatusQuery);
                if (!rmapp.getFinalApplicationStatus().toString().equalsIgnoreCase(finalStatusQuery)) continue;
            }
            if (userQuery != null && !userQuery.isEmpty() && !rmapp.getUser().equals(userQuery)) continue;
            if (queueQuery != null && !queueQuery.isEmpty()) {
                ResourceScheduler rs = this.rm.getResourceScheduler();
                if (rs instanceof CapacityScheduler) {
                    CapacityScheduler cs = (CapacityScheduler)rs;
                    try {
                        cs.getQueueInfo(queueQuery, false, false);
                    }
                    catch (IOException e) {
                        throw new BadRequestException(e.getMessage());
                    }
                }
                if (!rmapp.getQueue().equals(queueQuery)) continue;
            }
            if (checkStart && (rmapp.getStartTime() < sBegin || rmapp.getStartTime() > sEnd) || checkEnd && (rmapp.getFinishTime() < fBegin || rmapp.getFinishTime() > fEnd)) continue;
            AppInfo app = new AppInfo(rmapp, this.hasAccess(rmapp, hsr));
            allApps.add(app);
            ++num;
        }
        return allApps;
    }

    @GET
    @Path(value="/apps/{appid}")
    @Produces(value={"application/json", "application/xml"})
    public AppInfo getApp(@Context HttpServletRequest hsr, @PathParam(value="appid") String appId) {
        this.init();
        if (appId == null || appId.isEmpty()) {
            throw new NotFoundException("appId, " + appId + ", is empty or null");
        }
        ApplicationId id = ConverterUtils.toApplicationId((RecordFactory)recordFactory, (String)appId);
        if (id == null) {
            throw new NotFoundException("appId is null");
        }
        RMApp app = (RMApp)this.rm.getRMContext().getRMApps().get(id);
        if (app == null) {
            throw new NotFoundException("app with id: " + appId + " not found");
        }
        return new AppInfo(app, this.hasAccess(app, hsr));
    }

    @GET
    @Path(value="/apps/{appid}/appattempts")
    @Produces(value={"application/json", "application/xml"})
    public AppAttemptsInfo getAppAttempts(@PathParam(value="appid") String appId) {
        this.init();
        if (appId == null || appId.isEmpty()) {
            throw new NotFoundException("appId, " + appId + ", is empty or null");
        }
        ApplicationId id = ConverterUtils.toApplicationId((RecordFactory)recordFactory, (String)appId);
        if (id == null) {
            throw new NotFoundException("appId is null");
        }
        RMApp app = (RMApp)this.rm.getRMContext().getRMApps().get(id);
        if (app == null) {
            throw new NotFoundException("app with id: " + appId + " not found");
        }
        AppAttemptsInfo appAttemptsInfo = new AppAttemptsInfo();
        for (RMAppAttempt attempt : app.getAppAttempts().values()) {
            AppAttemptInfo attemptInfo = new AppAttemptInfo(attempt, app.getUser());
            appAttemptsInfo.add(attemptInfo);
        }
        return appAttemptsInfo;
    }
}

