/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp.dao;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSLeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.QueueManager;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.FairSchedulerLeafQueueInfo;
import org.apache.hadoop.yarn.util.resource.Resources;

public class FairSchedulerQueueInfo {
    private int fairShare;
    private int minShare;
    private int maxShare;
    private int clusterMaxMem;
    private int maxApps;
    private float fractionUsed;
    private float fractionFairShare;
    private float fractionMinShare;
    private Resource minResources;
    private Resource maxResources;
    private Resource usedResources;
    private String queueName;
    private Collection<FairSchedulerQueueInfo> childInfos;

    public FairSchedulerQueueInfo(FSQueue queue, FairScheduler scheduler) {
        QueueManager manager = scheduler.getQueueManager();
        this.queueName = queue.getName();
        Resource clusterMax = scheduler.getClusterCapacity();
        this.clusterMaxMem = clusterMax.getMemory();
        this.usedResources = queue.getResourceUsage();
        this.fractionUsed = (float)this.usedResources.getMemory() / (float)this.clusterMaxMem;
        this.fairShare = queue.getFairShare().getMemory();
        this.minResources = queue.getMinShare();
        this.minShare = this.minResources.getMemory();
        this.maxResources = scheduler.getQueueManager().getMaxResources(this.queueName);
        if (this.maxResources.getMemory() > this.clusterMaxMem) {
            this.maxResources = Resources.createResource((int)this.clusterMaxMem);
        }
        this.maxShare = this.maxResources.getMemory();
        this.fractionFairShare = (float)this.fairShare / (float)this.clusterMaxMem;
        this.fractionMinShare = (float)this.minShare / (float)this.clusterMaxMem;
        this.maxApps = manager.getQueueMaxApps(this.queueName);
        Collection<FSQueue> childQueues = queue.getChildQueues();
        this.childInfos = new ArrayList<FairSchedulerQueueInfo>();
        for (FSQueue child : childQueues) {
            if (child instanceof FSLeafQueue) {
                this.childInfos.add(new FairSchedulerLeafQueueInfo((FSLeafQueue)child, scheduler));
                continue;
            }
            this.childInfos.add(new FairSchedulerQueueInfo(child, scheduler));
        }
    }

    public float getFairShareFraction() {
        return this.fractionFairShare;
    }

    public int getFairShare() {
        return this.fairShare;
    }

    public Resource getMinResources() {
        return this.minResources;
    }

    public Resource getMaxResources() {
        return this.maxResources;
    }

    public int getMaxApplications() {
        return this.maxApps;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public Resource getUsedResources() {
        return this.usedResources;
    }

    public float getMinShareFraction() {
        return this.fractionMinShare;
    }

    public float getUsedFraction() {
        return this.fractionUsed;
    }

    public float getMaxResourcesFraction() {
        return (float)this.maxShare / (float)this.clusterMaxMem;
    }

    public Collection<FairSchedulerQueueInfo> getChildQueues() {
        return this.childInfos;
    }
}

