/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.QueueState;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.server.resourcemanager.resource.ResourceWeights;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Queue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AllocationConfigurationException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSSchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.QueueManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.Schedulable;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.SchedulingPolicy;
import org.apache.hadoop.yarn.util.resource.Resources;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public abstract class FSQueue
extends Schedulable
implements Queue {
    private final String name;
    private final QueueManager queueMgr;
    private final FairScheduler scheduler;
    private final FSQueueMetrics metrics;
    protected final FSParentQueue parent;
    protected final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    protected SchedulingPolicy policy = SchedulingPolicy.getDefault();

    public FSQueue(String name, QueueManager queueMgr, FairScheduler scheduler, FSParentQueue parent) {
        this.name = name;
        this.queueMgr = queueMgr;
        this.scheduler = scheduler;
        this.metrics = FSQueueMetrics.forQueue(this.getName(), parent, true, scheduler.getConf());
        this.metrics.setMinShare(this.getMinShare());
        this.metrics.setMaxShare(this.getMaxShare());
        this.parent = parent;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getQueueName() {
        return this.name;
    }

    public SchedulingPolicy getPolicy() {
        return this.policy;
    }

    protected void throwPolicyDoesnotApplyException(SchedulingPolicy policy) throws AllocationConfigurationException {
        throw new AllocationConfigurationException("SchedulingPolicy " + policy + " does not apply to queue " + this.getName());
    }

    public abstract void setPolicy(SchedulingPolicy var1) throws AllocationConfigurationException;

    @Override
    public ResourceWeights getWeights() {
        return this.queueMgr.getQueueWeight(this.getName());
    }

    @Override
    public Resource getMinShare() {
        return this.queueMgr.getMinResources(this.getName());
    }

    @Override
    public Resource getMaxShare() {
        return this.queueMgr.getMaxResources(this.getName());
    }

    @Override
    public long getStartTime() {
        return 0L;
    }

    @Override
    public Priority getPriority() {
        Priority p = (Priority)this.recordFactory.newRecordInstance(Priority.class);
        p.setPriority(1);
        return p;
    }

    @Override
    public QueueInfo getQueueInfo(boolean includeChildQueues, boolean recursive) {
        QueueInfo queueInfo = (QueueInfo)this.recordFactory.newRecordInstance(QueueInfo.class);
        queueInfo.setQueueName(this.getQueueName());
        queueInfo.setCapacity((float)this.getFairShare().getMemory() / (float)this.scheduler.getClusterCapacity().getMemory());
        queueInfo.setCapacity((float)this.getResourceUsage().getMemory() / (float)this.scheduler.getClusterCapacity().getMemory());
        ArrayList<QueueInfo> childQueueInfos = new ArrayList<QueueInfo>();
        if (includeChildQueues) {
            Collection<FSQueue> childQueues = this.getChildQueues();
            for (FSQueue child : childQueues) {
                childQueueInfos.add(child.getQueueInfo(recursive, recursive));
            }
        }
        queueInfo.setChildQueues(childQueueInfos);
        queueInfo.setQueueState(QueueState.RUNNING);
        return queueInfo;
    }

    @Override
    public Map<QueueACL, AccessControlList> getQueueAcls() {
        Map<QueueACL, AccessControlList> acls = this.queueMgr.getQueueAcls(this.getName());
        return new HashMap<QueueACL, AccessControlList>(acls);
    }

    @Override
    public FSQueueMetrics getMetrics() {
        return this.metrics;
    }

    @Override
    public void setFairShare(Resource fairShare) {
        super.setFairShare(fairShare);
        this.metrics.setFairShare(fairShare);
    }

    @Override
    public boolean hasAccess(QueueACL acl, UserGroupInformation user) {
        if (this.queueMgr.getQueueAcls(this.getName()).get(acl).isUserAllowed(user)) {
            return true;
        }
        return this.parent != null && this.parent.hasAccess(acl, user);
    }

    public abstract void recomputeShares();

    public abstract Collection<FSQueue> getChildQueues();

    protected boolean assignContainerPreCheck(FSSchedulerNode node) {
        return Resources.fitsIn((Resource)this.getResourceUsage(), (Resource)this.queueMgr.getMaxResources(this.getName())) && node.getReservedContainer() == null;
    }
}

