/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.security.QueueACLsManager;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.JAXBContextResolver;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RMWebServices;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RmController;
import org.apache.hadoop.yarn.server.security.ApplicationACLsManager;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.webapp.GenericExceptionHandler;
import org.apache.hadoop.yarn.webapp.WebApp;
import org.apache.hadoop.yarn.webapp.YarnWebParams;

public class RMWebApp
extends WebApp
implements YarnWebParams {
    private final ResourceManager rm;

    public RMWebApp(ResourceManager rm) {
        this.rm = rm;
    }

    public void setup() {
        this.bind(JAXBContextResolver.class);
        this.bind(RMWebServices.class);
        this.bind(GenericExceptionHandler.class);
        if (this.rm != null) {
            this.bind(ResourceManager.class).toInstance((Object)this.rm);
            this.bind(RMContext.class).toInstance((Object)this.rm.getRMContext());
            this.bind(ApplicationACLsManager.class).toInstance((Object)this.rm.getApplicationACLsManager());
            this.bind(QueueACLsManager.class).toInstance((Object)this.rm.getQueueACLsManager());
        }
        this.route("/", RmController.class);
        this.route(StringHelper.pajoin((Object[])new Object[]{"/nodes", "node.state"}), RmController.class, "nodes");
        this.route(StringHelper.pajoin((Object[])new Object[]{"/apps", "app.state"}), RmController.class);
        this.route("/cluster", RmController.class, "about");
        this.route(StringHelper.pajoin((Object[])new Object[]{"/app", "app.id"}), RmController.class, "app");
        this.route("/scheduler", RmController.class, "scheduler");
        this.route(StringHelper.pajoin((Object[])new Object[]{"/queue", "queue.name"}), RmController.class, "queue");
    }
}

