/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import com.google.inject.Inject;
import java.util.Collection;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.ApplicationBaseProtocol;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptReport;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerReport;
import org.apache.hadoop.yarn.api.records.YarnApplicationAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AbstractYarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplicationAttempt;
import org.apache.hadoop.yarn.server.webapp.AppAttemptBlock;
import org.apache.hadoop.yarn.server.webapp.dao.AppAttemptInfo;
import org.apache.hadoop.yarn.webapp.View;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;

public class RMAppAttemptBlock
extends AppAttemptBlock {
    private final ResourceManager rm;
    protected Configuration conf;

    @Inject
    RMAppAttemptBlock(View.ViewContext ctx, ResourceManager rm, Configuration conf) {
        super((ApplicationBaseProtocol)rm.getClientRMService(), ctx);
        this.rm = rm;
        this.conf = conf;
    }

    protected void render(HtmlBlock.Block html) {
        super.render(html);
    }

    private RMAppAttempt getRMAppAttempt() {
        ApplicationId appId = this.appAttemptId.getApplicationId();
        RMAppAttempt attempt = null;
        RMApp rmApp = (RMApp)this.rm.getRMContext().getRMApps().get(appId);
        if (rmApp != null) {
            attempt = rmApp.getAppAttempts().get(this.appAttemptId);
        }
        return attempt;
    }

    protected void generateOverview(ApplicationAttemptReport appAttemptReport, Collection<ContainerReport> containers, AppAttemptInfo appAttempt, String node) {
        String blacklistedNodes = "-";
        Set<String> nodes = RMAppAttemptBlock.getBlacklistedNodes(this.rm, this.getRMAppAttempt().getAppAttemptId());
        if (nodes != null && !nodes.isEmpty()) {
            blacklistedNodes = StringUtils.join(nodes, (String)", ");
        }
        this.info("Application Attempt Overview")._("Application Attempt State:", (Object)(appAttempt.getAppAttemptState() == null ? "N/A" : appAttempt.getAppAttemptState()))._("AM Container:", appAttempt.getAmContainerId() == null || containers == null || !this.hasAMContainer(appAttemptReport.getAMContainerId(), containers) ? null : this.root_url(new String[]{"container", appAttempt.getAmContainerId()}), (Object)String.valueOf(appAttempt.getAmContainerId()))._("Node:", (Object)node)._("Tracking URL:", appAttempt.getTrackingUrl() == null || appAttempt.getTrackingUrl().equals("N/A") ? null : this.root_url(new String[]{appAttempt.getTrackingUrl()}), (Object)(appAttempt.getTrackingUrl() == null || appAttempt.getTrackingUrl().equals("N/A") ? "Unassigned" : (appAttempt.getAppAttemptState() == YarnApplicationAttemptState.FINISHED || appAttempt.getAppAttemptState() == YarnApplicationAttemptState.FAILED || appAttempt.getAppAttemptState() == YarnApplicationAttemptState.KILLED ? "History" : "ApplicationMaster")))._("Diagnostics Info:", (Object)(appAttempt.getDiagnosticsInfo() == null ? "" : appAttempt.getDiagnosticsInfo()))._("Blacklisted Nodes:", (Object)blacklistedNodes);
    }

    public static Set<String> getBlacklistedNodes(ResourceManager rm, ApplicationAttemptId appid) {
        AbstractYarnScheduler ayScheduler;
        Object attempt;
        if (rm.getResourceScheduler() instanceof AbstractYarnScheduler && (attempt = (ayScheduler = (AbstractYarnScheduler)rm.getResourceScheduler()).getApplicationAttempt(appid)) != null) {
            return ((SchedulerApplicationAttempt)attempt).getBlacklistedNodes();
        }
        return null;
    }
}

