/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.webproxy;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.util.StringHelper;

public class ProxyUriUtils {
    private static final Log LOG = LogFactory.getLog(ProxyUriUtils.class);
    public static final String PROXY_SERVLET_NAME = "proxy";
    public static final String PROXY_BASE = "/proxy/";
    public static final String PROXY_PATH_SPEC = "/proxy/*";
    public static final String PROXY_APPROVAL_PARAM = "proxyapproved";

    private static String uriEncode(Object o) {
        try {
            assert (o != null) : "o canot be null";
            return URLEncoder.encode(o.toString(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 is not supported by this system?", e);
        }
    }

    public static String getPath(ApplicationId id) {
        if (id == null) {
            throw new IllegalArgumentException("Application id cannot be null ");
        }
        return StringHelper.ujoin((String)PROXY_BASE, (String[])new String[]{ProxyUriUtils.uriEncode(id)});
    }

    public static String getPath(ApplicationId id, String path) {
        if (path == null) {
            return ProxyUriUtils.getPath(id);
        }
        return StringHelper.ujoin((String)ProxyUriUtils.getPath(id), (String[])new String[]{path});
    }

    public static String getPathAndQuery(ApplicationId id, String path, String query, boolean approved) {
        StringBuilder newp = new StringBuilder();
        newp.append(ProxyUriUtils.getPath(id, path));
        boolean first = ProxyUriUtils.appendQuery(newp, query, true);
        if (approved) {
            ProxyUriUtils.appendQuery(newp, "proxyapproved=true", first);
        }
        return newp.toString();
    }

    private static boolean appendQuery(StringBuilder builder, String query, boolean first) {
        if (query != null && !query.isEmpty()) {
            if (first && !query.startsWith("?")) {
                builder.append('?');
            }
            if (!first && !query.startsWith("&")) {
                builder.append('&');
            }
            builder.append(query);
            return false;
        }
        return first;
    }

    public static URI getProxyUri(URI originalUri, URI proxyUri, ApplicationId id) {
        try {
            String path = ProxyUriUtils.getPath(id, originalUri.getPath());
            return new URI(proxyUri.getScheme(), proxyUri.getAuthority(), path, originalUri.getQuery(), originalUri.getFragment());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Could not proxify " + originalUri, e);
        }
    }

    public static URI getUriFromAMUrl(String noSchemeUrl) throws URISyntaxException {
        return new URI("http://" + noSchemeUrl);
    }
}

