/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.webproxy;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashSet;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.server.webproxy.AppReportFetcher;
import org.apache.hadoop.yarn.server.webproxy.ProxyUriUtils;
import org.apache.hadoop.yarn.util.Apps;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.webapp.hamlet.Hamlet;
import org.apache.hadoop.yarn.webapp.hamlet.HamletImpl;
import org.apache.hadoop.yarn.webapp.hamlet.HamletSpec;

public class WebAppProxyServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = LogFactory.getLog(WebAppProxyServlet.class);
    private static final HashSet<String> passThroughHeaders = new HashSet<String>(Arrays.asList("User-Agent", "Accept", "Accept-Encoding", "Accept-Language", "Accept-Charset"));
    public static final String PROXY_USER_COOKIE_NAME = "proxy-user";

    private static void notFound(HttpServletResponse resp, String message) throws IOException {
        resp.setStatus(404);
        resp.setContentType("text/html; charset=UTF-8");
        Page p = new Page(resp.getWriter());
        p.html().h1(message)._();
    }

    private static void warnUserPage(HttpServletResponse resp, String link, String user, ApplicationId id) throws IOException {
        resp.addCookie(WebAppProxyServlet.makeCheckCookie(id, false));
        resp.setContentType("text/html; charset=UTF-8");
        Page p = new Page(resp.getWriter());
        ((Hamlet.HTML)p.html().h1("WARNING: The following page may not be safe!").h3()._(new Object[]{"click "}).a(link, "here")._(new Object[]{" to continue to an Application Master web interface owned by ", user})._())._();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void proxyLink(HttpServletRequest req, HttpServletResponse resp, java.net.URI link, Cookie c) throws IOException {
        URI uri = new URI(link.toString(), false);
        HttpClient client = new HttpClient();
        GetMethod method = new GetMethod(uri.getEscapedURI());
        Enumeration names = req.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            if (!passThroughHeaders.contains(name)) continue;
            String value = req.getHeader(name);
            LOG.debug((Object)("REQ HEADER: " + name + " : " + value));
            method.setRequestHeader(name, value);
        }
        String user = req.getRemoteUser();
        if (user != null && !user.isEmpty()) {
            method.setRequestHeader("Cookie", "proxy-user=" + URLEncoder.encode(user, "ASCII"));
        }
        ServletOutputStream out = resp.getOutputStream();
        try {
            InputStream in;
            resp.setStatus(client.executeMethod((HttpMethod)method));
            for (Header header : method.getResponseHeaders()) {
                resp.setHeader(header.getName(), header.getValue());
            }
            if (c != null) {
                resp.addCookie(c);
            }
            if ((in = method.getResponseBodyAsStream()) != null) {
                IOUtils.copyBytes((InputStream)in, (OutputStream)out, (int)4096, (boolean)true);
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    private static String getCheckCookieName(ApplicationId id) {
        return "checked_" + id;
    }

    private static Cookie makeCheckCookie(ApplicationId id, boolean isSet) {
        Cookie c = new Cookie(WebAppProxyServlet.getCheckCookieName(id), String.valueOf(isSet));
        c.setPath(ProxyUriUtils.getPath(id));
        c.setMaxAge(7200);
        return c;
    }

    private boolean isSecurityEnabled() {
        Boolean b = (Boolean)this.getServletContext().getAttribute("IsSecurityEnabled");
        if (b != null) {
            return b;
        }
        return false;
    }

    private ApplicationReport getApplicationReport(ApplicationId id) throws IOException {
        return ((AppReportFetcher)this.getServletContext().getAttribute("AppUrlFetcher")).getApplicationReport(id);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try {
            String userApprovedParamS = req.getParameter("proxyapproved");
            boolean userWasWarned = false;
            boolean userApproved = userApprovedParamS != null && Boolean.valueOf(userApprovedParamS) != false;
            boolean securityEnabled = this.isSecurityEnabled();
            String remoteUser = req.getRemoteUser();
            String pathInfo = req.getPathInfo();
            String[] parts = pathInfo.split("/", 3);
            if (parts.length < 2) {
                LOG.warn((Object)(remoteUser + " Gave an invalid proxy path " + pathInfo));
                WebAppProxyServlet.notFound(resp, "Your path appears to be formatted incorrectly.");
                return;
            }
            String appId = parts[1];
            String rest = parts.length > 2 ? parts[2] : "";
            ApplicationId id = Apps.toAppID((String)appId);
            if (id == null) {
                LOG.warn((Object)(req.getRemoteUser() + " Attempting to access " + appId + " that is invalid"));
                WebAppProxyServlet.notFound(resp, appId + " appears to be formatted incorrectly.");
                return;
            }
            if (securityEnabled) {
                String cookieName = WebAppProxyServlet.getCheckCookieName(id);
                for (Cookie c : req.getCookies()) {
                    if (!cookieName.equals(c.getName())) continue;
                    userWasWarned = true;
                    userApproved = userApproved || Boolean.valueOf(c.getValue()) != false;
                    break;
                }
            }
            boolean checkUser = securityEnabled && (!userWasWarned || !userApproved);
            ApplicationReport applicationReport = this.getApplicationReport(id);
            if (applicationReport == null) {
                LOG.warn((Object)(req.getRemoteUser() + " Attempting to access " + id + " that was not found"));
                WebAppProxyServlet.notFound(resp, "Application " + appId + " could not be found, " + "please try the history server");
                return;
            }
            java.net.URI trackingUri = ProxyUriUtils.getUriFromAMUrl(applicationReport.getOriginalTrackingUrl());
            String runningUser = applicationReport.getUser();
            if (checkUser && !runningUser.equals(remoteUser)) {
                LOG.info((Object)("Asking " + remoteUser + " if they want to connect to the " + "app master GUI of " + appId + " owned by " + runningUser));
                WebAppProxyServlet.warnUserPage(resp, ProxyUriUtils.getPathAndQuery(id, rest, req.getQueryString(), true), runningUser, id);
                return;
            }
            java.net.URI toFetch = new java.net.URI(req.getScheme(), trackingUri.getAuthority(), StringHelper.ujoin((String)trackingUri.getPath(), (String[])new String[]{rest}), req.getQueryString(), null);
            LOG.info((Object)(req.getRemoteUser() + " is accessing unchecked " + toFetch + " which is the app master GUI of " + appId + " owned by " + runningUser));
            switch (applicationReport.getYarnApplicationState()) {
                case KILLED: 
                case FINISHED: 
                case FAILED: {
                    resp.sendRedirect(resp.encodeRedirectURL(toFetch.toString()));
                    return;
                }
            }
            Cookie c = null;
            if (userWasWarned && userApproved) {
                c = WebAppProxyServlet.makeCheckCookie(id, true);
            }
            WebAppProxyServlet.proxyLink(req, resp, toFetch, c);
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    private static class Page
    extends Hamlet {
        Page(PrintWriter out) {
            super(out, 0, false);
        }

        public Hamlet.HTML<_> html() {
            return new Hamlet.HTML((Hamlet)this, "html", null, EnumSet.of(HamletImpl.EOpt.ENDTAG));
        }
    }

    private static class _
    implements HamletSpec._ {
        private _() {
        }
    }
}

