/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.webproxy.amfilter;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.yarn.server.webproxy.amfilter.AmIpPrincipal;
import org.apache.hadoop.yarn.server.webproxy.amfilter.AmIpServletRequestWrapper;

public class AmIpFilter
implements Filter {
    private static final Log LOG = LogFactory.getLog(AmIpFilter.class);
    public static final String PROXY_HOST = "PROXY_HOST";
    public static final String PROXY_URI_BASE = "PROXY_URI_BASE";
    private static final long updateInterval = 300000L;
    private String proxyHost;
    private Set<String> proxyAddresses = null;
    private long lastUpdate;
    private String proxyUriBase;

    public void init(FilterConfig conf) throws ServletException {
        this.proxyHost = conf.getInitParameter(PROXY_HOST);
        this.proxyUriBase = conf.getInitParameter(PROXY_URI_BASE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getProxyAddresses() throws ServletException {
        long now = System.currentTimeMillis();
        AmIpFilter amIpFilter = this;
        synchronized (amIpFilter) {
            if (this.proxyAddresses == null || this.lastUpdate + 300000L >= now) {
                try {
                    this.proxyAddresses = new HashSet<String>();
                    for (InetAddress add : InetAddress.getAllByName(this.proxyHost)) {
                        this.proxyAddresses.add(add.getHostAddress());
                    }
                    this.lastUpdate = now;
                }
                catch (UnknownHostException e) {
                    throw new ServletException("Could not locate " + this.proxyHost, (Throwable)e);
                }
            }
            return this.proxyAddresses;
        }
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        if (!(req instanceof HttpServletRequest)) {
            throw new ServletException("This filter only works for HTTP/HTTPS");
        }
        HttpServletRequest httpReq = (HttpServletRequest)req;
        HttpServletResponse httpResp = (HttpServletResponse)resp;
        if (!this.getProxyAddresses().contains(httpReq.getRemoteAddr())) {
            String redirectUrl = httpResp.encodeRedirectURL(this.proxyUriBase + httpReq.getRequestURI());
            httpResp.sendRedirect(redirectUrl);
            return;
        }
        String user = null;
        for (Cookie c : httpReq.getCookies()) {
            if (!"proxy-user".equals(c.getName())) continue;
            user = c.getValue();
            break;
        }
        if (user == null) {
            LOG.warn((Object)"Could not find proxy-user cookie, so user will not be set");
            chain.doFilter(req, resp);
        } else {
            AmIpPrincipal principal = new AmIpPrincipal(user);
            AmIpServletRequestWrapper requestWrapper = new AmIpServletRequestWrapper(httpReq, principal);
            chain.doFilter((ServletRequest)requestWrapper, resp);
        }
    }
}

