/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.webproxy;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.YarnException;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.webproxy.WebAppProxy;
import org.apache.hadoop.yarn.service.CompositeService;
import org.apache.hadoop.yarn.service.Service;

public class WebAppProxyServer
extends CompositeService {
    private static final Log LOG = LogFactory.getLog(WebAppProxyServer.class);
    private WebAppProxy proxy = null;

    public WebAppProxyServer() {
        super(WebAppProxyServer.class.getName());
    }

    public synchronized void init(Configuration conf) {
        YarnConfiguration config = new YarnConfiguration(conf);
        try {
            this.doSecureLogin(conf);
        }
        catch (IOException ie) {
            throw new YarnException("Proxy Server Failed to login", (Throwable)ie);
        }
        this.proxy = new WebAppProxy();
        this.addService((Service)this.proxy);
        super.init((Configuration)config);
    }

    protected void doSecureLogin(Configuration conf) throws IOException {
        SecurityUtil.login((Configuration)conf, (String)"yarn.web-proxy.keytab", (String)"yarn.web-proxy.principal");
    }

    public static void main(String[] args) {
        StringUtils.startupShutdownMessage(WebAppProxyServer.class, (String[])args, (Log)LOG);
        try {
            WebAppProxyServer proxy = new WebAppProxyServer();
            Runtime.getRuntime().addShutdownHook((Thread)new CompositeService.CompositeServiceShutdownHook((CompositeService)proxy));
            YarnConfiguration conf = new YarnConfiguration();
            proxy.init((Configuration)conf);
            proxy.start();
        }
        catch (Throwable t) {
            LOG.fatal((Object)"Error starting Proxy server", t);
            System.exit(-1);
        }
    }
}

