/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AsyncAdmin;
import org.apache.hadoop.hbase.client.AsyncAdminBuilder;
import org.apache.hadoop.hbase.client.AsyncAdminBuilderBase;
import org.apache.hadoop.hbase.client.AsyncBufferedMutatorBuilder;
import org.apache.hadoop.hbase.client.AsyncBufferedMutatorBuilderImpl;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.client.AsyncConnectionConfiguration;
import org.apache.hadoop.hbase.client.AsyncHBaseAdmin;
import org.apache.hadoop.hbase.client.AsyncRegionLocator;
import org.apache.hadoop.hbase.client.AsyncRegistry;
import org.apache.hadoop.hbase.client.AsyncRpcRetryingCallerFactory;
import org.apache.hadoop.hbase.client.AsyncTable;
import org.apache.hadoop.hbase.client.AsyncTableBuilder;
import org.apache.hadoop.hbase.client.AsyncTableBuilderBase;
import org.apache.hadoop.hbase.client.AsyncTableImpl;
import org.apache.hadoop.hbase.client.AsyncTableRegionLocator;
import org.apache.hadoop.hbase.client.AsyncTableRegionLocatorImpl;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.client.NonceGenerator;
import org.apache.hadoop.hbase.client.PerClientRandomNonceGenerator;
import org.apache.hadoop.hbase.client.RawAsyncHBaseAdmin;
import org.apache.hadoop.hbase.client.RawAsyncTable;
import org.apache.hadoop.hbase.client.RawAsyncTableImpl;
import org.apache.hadoop.hbase.ipc.HBaseRpcController;
import org.apache.hadoop.hbase.ipc.RpcClient;
import org.apache.hadoop.hbase.ipc.RpcClientFactory;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.RpcCallback;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.RpcChannel;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.RpcController;
import org.apache.hadoop.hbase.shaded.io.netty.util.HashedWheelTimer;
import org.apache.hadoop.hbase.shaded.protobuf.RequestConverter;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProtos;
import org.apache.hadoop.hbase.util.CollectionUtils;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class AsyncConnectionImpl
implements AsyncConnection {
    private static final Log LOG = LogFactory.getLog(AsyncConnectionImpl.class);
    @VisibleForTesting
    static final HashedWheelTimer RETRY_TIMER = new HashedWheelTimer(Threads.newDaemonThreadFactory((String)"Async-Client-Retry-Timer"), 10L, TimeUnit.MILLISECONDS);
    private static final String RESOLVE_HOSTNAME_ON_FAIL_KEY = "hbase.resolve.hostnames.on.failure";
    private final Configuration conf;
    final AsyncConnectionConfiguration connConf;
    private final User user;
    final AsyncRegistry registry;
    private final int rpcTimeout;
    private final RpcClient rpcClient;
    final RpcControllerFactory rpcControllerFactory;
    private final boolean hostnameCanChange;
    private final AsyncRegionLocator locator;
    final AsyncRpcRetryingCallerFactory callerFactory;
    private final NonceGenerator nonceGenerator;
    private final ConcurrentMap<String, ClientProtos.ClientService.Interface> rsStubs = new ConcurrentHashMap<String, ClientProtos.ClientService.Interface>();
    private final ConcurrentMap<String, AdminProtos.AdminService.Interface> adminSubs = new ConcurrentHashMap<String, AdminProtos.AdminService.Interface>();
    private final AtomicReference<MasterProtos.MasterService.Interface> masterStub = new AtomicReference();
    private final AtomicReference<CompletableFuture<MasterProtos.MasterService.Interface>> masterStubMakeFuture = new AtomicReference();

    public AsyncConnectionImpl(Configuration conf, AsyncRegistry registry, String clusterId, User user) {
        this.conf = conf;
        this.user = user;
        this.connConf = new AsyncConnectionConfiguration(conf);
        this.registry = registry;
        this.rpcClient = RpcClientFactory.createClient(conf, clusterId);
        this.rpcControllerFactory = RpcControllerFactory.instantiate(conf);
        this.hostnameCanChange = conf.getBoolean(RESOLVE_HOSTNAME_ON_FAIL_KEY, true);
        this.rpcTimeout = (int)Math.min(Integer.MAX_VALUE, TimeUnit.NANOSECONDS.toMillis(this.connConf.getRpcTimeoutNs()));
        this.locator = new AsyncRegionLocator(this, RETRY_TIMER);
        this.callerFactory = new AsyncRpcRetryingCallerFactory(this, RETRY_TIMER);
        this.nonceGenerator = conf.getBoolean("hbase.client.nonces.enabled", true) ? PerClientRandomNonceGenerator.get() : ConnectionUtils.NO_NONCE_GENERATOR;
    }

    @Override
    public Configuration getConfiguration() {
        return this.conf;
    }

    @Override
    public void close() {
        IOUtils.closeQuietly((Closeable)this.rpcClient);
        IOUtils.closeQuietly((Closeable)this.registry);
    }

    @Override
    public AsyncTableRegionLocator getRegionLocator(TableName tableName) {
        return new AsyncTableRegionLocatorImpl(tableName, this.locator);
    }

    @VisibleForTesting
    AsyncRegionLocator getLocator() {
        return this.locator;
    }

    @VisibleForTesting
    public NonceGenerator getNonceGenerator() {
        return this.nonceGenerator;
    }

    private ClientProtos.ClientService.Interface createRegionServerStub(ServerName serverName) throws IOException {
        return ClientProtos.ClientService.newStub((RpcChannel)this.rpcClient.createRpcChannel(serverName, this.user, this.rpcTimeout));
    }

    ClientProtos.ClientService.Interface getRegionServerStub(ServerName serverName) throws IOException {
        return (ClientProtos.ClientService.Interface)CollectionUtils.computeIfAbsentEx(this.rsStubs, (Object)ConnectionUtils.getStubKey(ClientProtos.ClientService.Interface.class.getSimpleName(), serverName, this.hostnameCanChange), () -> this.createRegionServerStub(serverName));
    }

    private MasterProtos.MasterService.Interface createMasterStub(ServerName serverName) throws IOException {
        return MasterProtos.MasterService.newStub((RpcChannel)this.rpcClient.createRpcChannel(serverName, this.user, this.rpcTimeout));
    }

    private AdminProtos.AdminService.Interface createAdminServerStub(ServerName serverName) throws IOException {
        return AdminProtos.AdminService.newStub((RpcChannel)this.rpcClient.createRpcChannel(serverName, this.user, this.rpcTimeout));
    }

    AdminProtos.AdminService.Interface getAdminStub(ServerName serverName) throws IOException {
        return (AdminProtos.AdminService.Interface)CollectionUtils.computeIfAbsentEx(this.adminSubs, (Object)ConnectionUtils.getStubKey(AdminProtos.AdminService.Interface.class.getSimpleName(), serverName, this.hostnameCanChange), () -> this.createAdminServerStub(serverName));
    }

    private void makeMasterStub(final CompletableFuture<MasterProtos.MasterService.Interface> future) {
        this.registry.getMasterAddress().whenComplete((sn, error) -> {
            if (sn == null) {
                String msg = "ZooKeeper available but no active master location found";
                LOG.info((Object)msg);
                ((CompletableFuture)this.masterStubMakeFuture.getAndSet(null)).completeExceptionally(new MasterNotRunningException(msg));
                return;
            }
            try {
                final MasterProtos.MasterService.Interface stub = this.createMasterStub((ServerName)sn);
                final HBaseRpcController controller = this.getRpcController();
                stub.isMasterRunning((RpcController)controller, RequestConverter.buildIsMasterRunningRequest(), (RpcCallback)new RpcCallback<MasterProtos.IsMasterRunningResponse>(){

                    public void run(MasterProtos.IsMasterRunningResponse resp) {
                        if (controller.failed() || resp == null || resp != null && !resp.getIsMasterRunning()) {
                            ((CompletableFuture)AsyncConnectionImpl.this.masterStubMakeFuture.getAndSet(null)).completeExceptionally(new MasterNotRunningException("Master connection is not running anymore"));
                        } else {
                            AsyncConnectionImpl.this.masterStub.set(stub);
                            AsyncConnectionImpl.this.masterStubMakeFuture.set(null);
                            future.complete(stub);
                        }
                    }
                });
            }
            catch (IOException e) {
                ((CompletableFuture)this.masterStubMakeFuture.getAndSet(null)).completeExceptionally(new IOException("Failed to create async master stub", e));
            }
        });
    }

    CompletableFuture<MasterProtos.MasterService.Interface> getMasterStub() {
        CompletableFuture<MasterProtos.MasterService.Interface> future;
        final MasterProtos.MasterService.Interface masterStub = this.masterStub.get();
        if (masterStub == null) {
            CompletableFuture<MasterProtos.MasterService.Interface> future2;
            while (true) {
                if (this.masterStubMakeFuture.compareAndSet(null, new CompletableFuture())) {
                    future2 = this.masterStubMakeFuture.get();
                    this.makeMasterStub(future2);
                    continue;
                }
                future2 = this.masterStubMakeFuture.get();
                if (future2 != null) break;
            }
            return future2;
        }
        while (true) {
            if (this.masterStubMakeFuture.compareAndSet(null, new CompletableFuture())) {
                future = this.masterStubMakeFuture.get();
                final HBaseRpcController controller = this.getRpcController();
                masterStub.isMasterRunning((RpcController)controller, RequestConverter.buildIsMasterRunningRequest(), (RpcCallback)new RpcCallback<MasterProtos.IsMasterRunningResponse>(){

                    public void run(MasterProtos.IsMasterRunningResponse resp) {
                        if (controller.failed() || resp == null || resp != null && !resp.getIsMasterRunning()) {
                            AsyncConnectionImpl.this.makeMasterStub(future);
                        } else {
                            future.complete(masterStub);
                        }
                    }
                });
                continue;
            }
            future = this.masterStubMakeFuture.get();
            if (future != null) break;
        }
        return future;
    }

    private HBaseRpcController getRpcController() {
        HBaseRpcController controller = this.rpcControllerFactory.newController();
        controller.setCallTimeout((int)TimeUnit.NANOSECONDS.toMillis(this.connConf.getRpcTimeoutNs()));
        return controller;
    }

    @Override
    public AsyncTableBuilder<RawAsyncTable> getRawTableBuilder(TableName tableName) {
        return new AsyncTableBuilderBase<RawAsyncTable>(tableName, this.connConf){

            @Override
            public RawAsyncTable build() {
                return new RawAsyncTableImpl(AsyncConnectionImpl.this, this);
            }
        };
    }

    @Override
    public AsyncTableBuilder<AsyncTable> getTableBuilder(TableName tableName, final ExecutorService pool) {
        return new AsyncTableBuilderBase<AsyncTable>(tableName, this.connConf){

            @Override
            public AsyncTable build() {
                RawAsyncTableImpl rawTable = new RawAsyncTableImpl(AsyncConnectionImpl.this, this);
                return new AsyncTableImpl(AsyncConnectionImpl.this, rawTable, pool);
            }
        };
    }

    @Override
    public AsyncAdminBuilder getAdminBuilder() {
        return new AsyncAdminBuilderBase(this.connConf){

            @Override
            public AsyncAdmin build() {
                return new RawAsyncHBaseAdmin(AsyncConnectionImpl.this, this);
            }
        };
    }

    @Override
    public AsyncAdminBuilder getAdminBuilder(final ExecutorService pool) {
        return new AsyncAdminBuilderBase(this.connConf){

            @Override
            public AsyncAdmin build() {
                RawAsyncHBaseAdmin rawAdmin = new RawAsyncHBaseAdmin(AsyncConnectionImpl.this, this);
                return new AsyncHBaseAdmin(rawAdmin, pool);
            }
        };
    }

    @Override
    public AsyncBufferedMutatorBuilder getBufferedMutatorBuilder(TableName tableName) {
        return new AsyncBufferedMutatorBuilderImpl(this.connConf, this.getRawTableBuilder(tableName));
    }

    @Override
    public AsyncBufferedMutatorBuilder getBufferedMutatorBuilder(TableName tableName, ExecutorService pool) {
        return new AsyncBufferedMutatorBuilderImpl(this.connConf, this.getTableBuilder(tableName, pool));
    }
}

